/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.counsel;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.counsel.UFOFaqMgmtDAO;

public class UFOFaqMgmtWB
extends UFOBaseWB {
    public UFOFaqMgmtWB() {
    }

    public UFOFaqMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchFaqList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("question", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("answer", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ALL)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                        info.put("question", CmUtil.nullTrim(info.getString("keyword")));
                        info.put("answer", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    result.put("LIST", dao.searchFaqListPaging(info));
                    result.put("TOTCNT", dao.getFaqListCnt(info));
                } else if (info.isExist("BEST")) {
                    result.put("LIST", dao.bestFaqList(info));
                } else {
                    result.put("LIST", dao.searchFaqList(info));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)result);
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_SEARCH_IF", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchFaqInfoList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("question", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("answer", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    result.put("LIST", dao.searchFaqInfoPaging(info));
                    result.put("TOTCNT", dao.getFaqInfoCnt(info));
                } else {
                    result.put("LIST", dao.searchFaqInfo(info));
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectFaqInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectFaqInfo(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectFaqSiteInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectFaqInfo(info));
                result.put("LIST", dao.searchFaqSite(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_SELECT_SITELIST", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertFaqInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                info.put("seq", dao.getMaxSeq(info));
                this.startTransaction();
                resCnt = dao.insertFaqInfo(info);
                String[] splitAttr = new String[]{"siteCd", "useFl", "status"};
                String[] keepAttr = new String[]{"cd", "seq"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                int i = 0;
                while (i < arrInfo.length) {
                    if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                        if (arrInfo[i].getBoolean("useFl")) {
                            resCnt1 += dao.insertSiteFaq(arrInfo[i]);
                        }
                    } else if (!arrInfo[i].getBoolean("useFl")) {
                        resCnt1 += dao.deleteSiteFaq(arrInfo[i]);
                    }
                    ++i;
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateFaqInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateFaqInfo(info);
                String[] splitAttr = new String[]{"siteCd", "useFl", "status"};
                String[] keepAttr = new String[]{"cd", "seq"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                int i = 0;
                while (i < arrInfo.length) {
                    if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                        if (arrInfo[i].getBoolean("useFl")) {
                            resCnt1 += dao.insertSiteFaq(arrInfo[i]);
                        }
                    } else if (!arrInfo[i].getBoolean("useFl")) {
                        resCnt1 += dao.deleteSiteFaq(arrInfo[i]);
                    }
                    ++i;
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteFaqInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                this.startTransaction();
                info.put("siteCd", "");
                resCnt1 = dao.deleteSiteFaq(info);
                resCnt = dao.deleteFaqInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateFaqSiteInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                this.startTransaction();
                String[] splitAttr = new String[]{"seq", "useFl"};
                String[] keepAttr = new String[]{"siteCd", "cd"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                int orderBy = 1;
                int i = 0;
                while (i < arrInfo.length) {
                    if (arrInfo[i].getBoolean("useFl")) {
                        arrInfo[i].put("orderBy", orderBy++);
                        resCnt += dao.updateSiteFaq(arrInfo[i]);
                    } else {
                        resCnt += dao.deleteSiteFaq(arrInfo[i]);
                    }
                    ++i;
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]SITE_FAQ_MODIFY", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchFaqCenterList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("question", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("answer", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ALL)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                        info.put("question", CmUtil.nullTrim(info.getString("keyword")));
                        info.put("answer", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    result.put("LIST", dao.searchFaqCenterListPaging(info));
                    result.put("TOTCNT", dao.getFaqCenterListCnt(info));
                } else {
                    result.put("LIST", dao.searchFaqCenterList(info));
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_CENTER_SEARCH_IF", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult faqBestRnk(int rnk) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.faqBestRnk(rnk));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_BESTRNK_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateFaqBest(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOFaqMgmtDAO dao = new UFOFaqMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updateFaqInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]FAQ_BEST_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

