/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.contents;

import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import com.ufo.contents.UFOPublicCntMgmtDAO;
import com.ufo.contents.entity.PublicContentsEntity;
import java.util.Vector;

public class UFOPublicCntMgmtWB
extends UFOBaseWB {
    public UFOPublicCntMgmtWB() {
    }

    public UFOPublicCntMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchCntList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPublicCntMgmtDAO dao = new UFOPublicCntMgmtDAO(this.getConnection(this));
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER)) {
                        info.put("RegId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (info.isPage()) {
                    Vector list = dao.searchPubContentsPaging(info);
                    if (list != null) {
                        int i = 0;
                        while (i < list.size()) {
                            PublicContentsEntity entity = (PublicContentsEntity)list.get(i);
                            entity.comtList = dao.searchCntComtList(entity.toRequest());
                            ++i;
                        }
                    }
                    result.put("LIST", list);
                    result.put("TOTCNT", dao.getPubContentsCnt(info));
                } else {
                    Vector list = dao.searchPubContents(info);
                    if (list != null) {
                        int i = 0;
                        while (i < list.size()) {
                            PublicContentsEntity entity = (PublicContentsEntity)list.get(i);
                            entity.comtList = dao.searchCntComtList(entity.toRequest());
                            ++i;
                        }
                    }
                    result.put("LIST", list);
                }
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONTENTS_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectCntInfoBasic(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPublicCntMgmtDAO dao = new UFOPublicCntMgmtDAO(this.getConnection(this));
                PublicContentsEntity entity = dao.selectPubContents(info);
                if (entity != null) {
                    entity.comtList = dao.searchCntComtList(info);
                }
                result.put("VIEW", entity);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONTENTS_SELECT_BASIC", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectCntInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOPublicCntMgmtDAO dao = new UFOPublicCntMgmtDAO(this.getConnection(this));
                PublicContentsEntity entity = dao.selectPubContents(info);
                if (entity != null) {
                    entity.comtList = dao.searchCntComtList(info);
                }
                result.put("VIEW", entity);
                result.put("PREV", dao.selectPubContents(info, "P"));
                result.put("NEXT", dao.selectPubContents(info, "N"));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONTENTS_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertCntInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOPublicCntMgmtDAO dao = new UFOPublicCntMgmtDAO(this.getConnection(this));
                info.put("seq", dao.getMaxSeq(info));
                this.startTransaction();
                resCnt = dao.insertPubContents(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONTENTS_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateCntInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOPublicCntMgmtDAO dao = new UFOPublicCntMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.updatePubContents(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONTENTS_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult hitDownCnt(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOPublicCntMgmtDAO dao = new UFOPublicCntMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.hitDownCnt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONTENST_DOWNCNT_INC", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteCntInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOPublicCntMgmtDAO dao = new UFOPublicCntMgmtDAO(this.getConnection(this));
                this.startTransaction();
                if (info.isExist("subSeq")) {
                    info.remove("subSeq");
                }
                resCnt1 = dao.deleteCntComt(info);
                resCnt = dao.deletePubContents(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONTENTS_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertCntComt(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOPublicCntMgmtDAO dao = new UFOPublicCntMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.insertCntComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONTENTS_COMT_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteCntComt(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOPublicCntMgmtDAO dao = new UFOPublicCntMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteCntComt(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]CONTENTS_COMT_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

