/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.common.utility;

import com.ufo.common.UFOSessionInfo;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.JSPHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LoginHelper {
    public static boolean isLogin(HttpServletRequest req, String siteCd) {
        String sessionName = "__" + siteCd.toLowerCase() + "_login_sess";
        if (JSPHelper.getSessionInfo(req, sessionName) == null) {
            String requestURI = req.getRequestURI();
            String queryString = req.getQueryString();
            requestURI = requestURI == null ? "" : requestURI.trim();
            queryString = queryString == null ? "" : "?" + queryString.trim();
            req.setAttribute("__redirectURL", (Object)(String.valueOf(requestURI) + queryString));
            return false;
        }
        HttpSession session = req.getSession();
        session.setAttribute("__current_site", (Object)siteCd.toUpperCase());
        return true;
    }

    public static void setRedirectURL(HttpServletRequest req, String url) {
        String oldUrl = (String)req.getAttribute("__redirectURL");
        if (oldUrl != null) {
            req.removeAttribute("__redirectURL");
        }
        req.setAttribute("__redirectURL", (Object)url);
    }

    public static String getRedirectURL(HttpServletRequest req) {
        String reUrl = "";
        reUrl = req.getParameter("redirectURL");
        if (reUrl == null || reUrl.equals("")) {
            reUrl = (String)req.getAttribute("__redirectURL");
        }
        if (reUrl == null || reUrl.equals("")) {
            reUrl = req.getHeader("referer");
        }
        return reUrl;
    }

    public static UFOSessionInfo newLoginInfo(HttpServletRequest req, String siteCd) {
        String sessionName = "__" + siteCd.toLowerCase() + "_login_sess";
        UFOSessionInfo sessionInfo = UFOSessionInfo.newInstance(req, siteCd, sessionName);
        return sessionInfo;
    }

    public static void releaseLoginInfo(HttpServletRequest req, String siteCd) {
        UFOSessionInfo sessionInfo = LoginHelper.getLoginInfo(req, siteCd);
        if (sessionInfo != null) {
            String sessionName = "__" + siteCd.toLowerCase() + "_login_sess";
            sessionInfo.release(req, sessionName);
        }
    }

    public static UFOSessionInfo getLoginInfo(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        if (session == null) {
            return null;
        }
        String current_site = (String)session.getAttribute("__current_site");
        if (current_site == null) {
            return null;
        }
        return LoginHelper.getLoginInfo(req, current_site);
    }

    public static UFOSessionInfo getLoginInfo(HttpServletRequest req, String siteCd) {
        String sessionName = "__" + siteCd.toLowerCase() + "_login_sess";
        UFOSessionInfo info = JSPHelper.getSessionInfo(req, sessionName);
        return info;
    }

    public static String getAttribute(HttpServletRequest req, String name) {
        HttpSession session = req.getSession(true);
        if (session == null) {
            return null;
        }
        String current_site = (String)session.getAttribute("__current_site");
        if (current_site == null) {
            return null;
        }
        return LoginHelper.getAttribute(req, current_site, name);
    }

    public static String getAttribute(HttpServletRequest req, String siteCd, String name) {
        UFOSessionInfo info = LoginHelper.getLoginInfo(req, siteCd);
        if (info == null) {
            return null;
        }
        return (String)info.get(name);
    }

    public static boolean setAttribute(HttpServletRequest req, String name, String value) {
        HttpSession session = req.getSession(true);
        if (session == null) {
            return false;
        }
        String current_site = (String)session.getAttribute("__current_site");
        if (current_site == null) {
            return false;
        }
        return LoginHelper.setAttribute(req, current_site, name, value);
    }

    public static boolean setAttribute(HttpServletRequest req, String siteCd, String name, String value) {
        UFOSessionInfo info = LoginHelper.getLoginInfo(req, siteCd);
        if (info == null) {
            return false;
        }
        info.put(name, value);
        return true;
    }

    public static Object getMemBasicInfo(HttpServletRequest req, String siteCd) {
        UFOSessionInfo info = LoginHelper.getLoginInfo(req, siteCd);
        if (info == null) {
            return null;
        }
        return info.get("SS_BASIC_INFO");
    }

    public static void setMemBasicInfo(HttpServletRequest req, String siteCd, Object obj) {
        UFOSessionInfo info = LoginHelper.getLoginInfo(req, siteCd);
        info.put("SS_BASIC_INFO", obj);
    }

    public static Object getMemSiteInfo(HttpServletRequest req, String siteCd) {
        UFOSessionInfo info = LoginHelper.getLoginInfo(req, siteCd);
        if (info == null) {
            return null;
        }
        return info.get("SS_SITE_INFO");
    }

    public static void setMemSiteInfo(HttpServletRequest req, String siteCd, Object obj) {
        UFOSessionInfo info = LoginHelper.getLoginInfo(req, siteCd);
        info.put("SS_SITE_INFO", obj);
    }

    public static String getCurLoginId(HttpServletRequest req) {
        HttpSession session;
        if (req == null) {
            return "sysadmin";
        }
        String loginId = LoginHelper.getAttribute(req, "SS_LOGIN_ID");
        if (loginId == null && (loginId = (String)(session = req.getSession()).getAttribute("TMP_LOGIN_ID")) == null) {
            return "sysadmin";
        }
        return loginId;
    }

    public static String getCurLoginId(HttpServletRequest req, String siteCd) {
        HttpSession session;
        String loginId = LoginHelper.getAttribute(req, siteCd, "SS_LOGIN_ID");
        if (loginId == null && (loginId = (String)(session = req.getSession()).getAttribute("TMP_LOGIN_ID")) == null) {
            return "sysadmin";
        }
        return loginId;
    }

    public static void setCurLoginId(HttpServletRequest req, String siteCd, String value) {
        boolean result = LoginHelper.setAttribute(req, siteCd, "SS_LOGIN_ID", value);
        if (!result) {
            HttpSession session = req.getSession();
            session.setAttribute("TMP_LOGIN_ID", (Object)value);
        }
    }

    public static String writeLogin() {
        String loginURL = "/login.jsp";
        String redirectURL = "/main.jsp";
        return LoginHelper.writeLogin(loginURL, redirectURL);
    }

    public static String writeLogin(String loginURL) {
        String redirectURL = "/main.jsp";
        return LoginHelper.writeLogin(loginURL, redirectURL);
    }

    public static String writeLogin(String loginURL, String redirectURL) {
        String jspUrl = "";
        jspUrl = !CmUtil.nullTrim(redirectURL).equals("") ? String.valueOf(CmUtil.nullTrim(loginURL)) + "?redirectURL=" + CmUtil.nullTrim(redirectURL) : CmUtil.nullTrim(loginURL);
        String message = "Session Not Found.Please Log in again!";
        StringBuffer toDoHTML = new StringBuffer();
        toDoHTML.append("<html>\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        toDoHTML.append("<body>\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        toDoHTML.append("<script>\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        toDoHTML.append("\talert('" + message + "');\t\t\t\t\t\t\t\t\n");
        toDoHTML.append("\tif( top ){\t\t\t\t\t\t\t\t\t\t\t\t\n");
        toDoHTML.append("\t\ttop.location.href='" + jspUrl + "';\t\t\t\t\n");
        toDoHTML.append("\t} else{\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        toDoHTML.append("\t\twindow.location.href='" + jspUrl + "';\t\t\t\n");
        toDoHTML.append("\t}\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        toDoHTML.append("</script>\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        toDoHTML.append("</body>\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        toDoHTML.append("</html>\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        return toDoHTML.toString();
    }
}

