/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.common.utility;

import com.ufo.common.UFORequest;
import com.ufo.common.entity.FileSystemInfoEntity;
import com.ufo.common.utility.UtilConst;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.Key;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.regexp.RE;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CmUtil {
    public static String RND_BIGALPHA = "100";
    public static String RND_SMLALPHA = "010";
    public static String RND_NUMBER = "001";
    public static String RND_BIGALPHANUM = "101";
    public static String RND_SMLALPHANUM = "011";
    private static final int PAD_LIMIT = 8192;
    static /* synthetic */ Class class$0;

    public static String mAscToKsc(String argStr) {
        String strToReturn = null;
        if (argStr == null) {
            return strToReturn;
        }
        try {
            strToReturn = new String(argStr.getBytes("8859_1"), "KSC5601");
        }
        catch (Exception e) {
            strToReturn = null;
        }
        return strToReturn;
    }

    public static String mKscToAsc(String argStr) {
        String strToReturn = null;
        if (argStr == null) {
            return strToReturn;
        }
        try {
            strToReturn = new String(argStr.getBytes("KSC5601"), "8859_1");
        }
        catch (Exception e) {
            strToReturn = null;
        }
        return strToReturn;
    }

    public static String randomStr(String prefix, String gubn, int length) {
        if (gubn == null && gubn.length() == 0) {
            return prefix;
        }
        String temp1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String temp2 = "abcdefghijklmnopqrstuvwxyz";
        String temp3 = "0123456789";
        String[] temp = new String[]{temp1, temp2, temp3};
        String seedStr = "";
        StringBuffer rndStr = new StringBuffer();
        int i = 0;
        while (i < gubn.length() && i < 3) {
            char c = gubn.charAt(i);
            if (c == '1') {
                seedStr = String.valueOf(seedStr) + temp[i];
            }
            ++i;
        }
        Date dt = new Date();
        Random rnd = new Random(dt.getTime());
        int rndLen = length - CmUtil.nullTrim(prefix).length();
        int j = 0;
        while (j < rndLen) {
            int index = Math.abs(rnd.nextInt()) % seedStr.length();
            rndStr.append(seedStr.charAt(index));
            ++j;
        }
        return String.valueOf(CmUtil.nullTrim(prefix)) + rndStr.toString();
    }

    public static String truncateStr(String str, int maxLength) {
        if (str == null) {
            return "";
        }
        StringBuffer outStr = new StringBuffer();
        char[] chArr = str.toCharArray();
        int i = 0;
        while (i < maxLength) {
            try {
                if (!Character.isDigit(chArr[i]) && !Character.isLowerCase(chArr[i])) {
                    --maxLength;
                }
                outStr.append(chArr[i]);
            }
            catch (ArrayIndexOutOfBoundsException arrEx) {
                return str;
            }
            ++i;
        }
        return String.valueOf(outStr.toString()) + "...";
    }

    public static String newLineStr(String str, int length) {
        if (str == null) {
            return "";
        }
        int strLength = str.length();
        int tmpLength = 0;
        StringBuffer outStr = new StringBuffer();
        char[] chArr = str.toCharArray();
        int i = 0;
        while (i < strLength) {
            try {
                tmpLength = !Character.isDigit(chArr[i]) && !Character.isLowerCase(chArr[i]) ? (tmpLength += 2) : ++tmpLength;
                outStr.append(chArr[i]);
                if (tmpLength > length) {
                    outStr.append("<br>");
                    tmpLength = 0;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrEx) {
                return str;
            }
            ++i;
        }
        return outStr.toString();
    }

    public static String moveDate(int type, int count, String strDt, String inPatten, String outPatten) {
        Calendar calendar = Calendar.getInstance();
        Date date = null;
        if (strDt == null || strDt.equals("")) {
            return "";
        }
        if ((strDt = strDt.trim()).equals("")) {
            return "";
        }
        try {
            date = new SimpleDateFormat(inPatten).parse(strDt);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException ee) {
            ee.printStackTrace();
        }
        calendar.setTime(date);
        SimpleDateFormat todayFormat = null;
        try {
            todayFormat = new SimpleDateFormat(outPatten);
            int field = 0;
            switch (type) {
                case 1: {
                    field = 1;
                    break;
                }
                case 2: {
                    field = 2;
                    break;
                }
                case 3: {
                    field = 5;
                    break;
                }
                case 4: {
                    field = 10;
                    break;
                }
                case 5: {
                    field = 12;
                    break;
                }
                case 6: {
                    field = 13;
                }
            }
            calendar.add(field, count);
            return todayFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String moveDate(int type, int count, String strDt, String patten) {
        return CmUtil.moveDate(type, count, strDt, "yyyyMMdd", patten);
    }

    public static String formatDate(Date dt, String patten) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat(patten);
        return sdf.format(dt);
    }

    public static String formatDate(String strDt, String inPatten, String outPatten) throws Exception {
        if (strDt == null || strDt.equals("")) {
            return "";
        }
        if ((strDt = strDt.trim()).equals("")) {
            return "";
        }
        Date dt = new SimpleDateFormat(inPatten).parse(strDt);
        SimpleDateFormat sdf = new SimpleDateFormat(outPatten);
        return sdf.format(dt);
    }

    public static String formatDate(String strDt, String patten) throws Exception {
        return CmUtil.formatDate(strDt, "yyyyMMdd", patten);
    }

    public static String formatNumber(String strNum, int fraction) throws Exception {
        return CmUtil.formatNumber(Double.parseDouble(strNum), fraction);
    }

    public static String formatNumber(double num, int fraction) throws Exception {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMinimumFractionDigits(fraction);
        nf.setMaximumFractionDigits(fraction);
        return nf.format(num);
    }

    public static String formatPercent(double num, int fraction) throws Exception {
        NumberFormat nf = NumberFormat.getPercentInstance();
        nf.setMinimumFractionDigits(fraction);
        nf.setMaximumFractionDigits(fraction);
        return nf.format(num);
    }

    public static String formatCurrency(double num) throws Exception {
        NumberFormat nf = NumberFormat.getCurrencyInstance();
        return nf.format(num);
    }

    public static String[] toStrArray(Vector strVt) {
        if (strVt == null) {
            return null;
        }
        int length = strVt.size();
        String[] strArr = new String[length];
        int i = 0;
        while (i < length) {
            strArr[i] = (String)strVt.get(i);
            ++i;
        }
        return strArr;
    }

    public static String getFileSize(String fileNm, String unit) throws Exception {
        String filesize = "";
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        File file = new File(CmUtil.nullTrim(fileNm));
        if (!file.isFile() || !file.exists()) {
            return "N/A";
        }
        long size = file.length();
        filesize = unit.toUpperCase().equals("K") ? String.valueOf(nf.format((double)size / 1024.0)) + " KB" : (unit.toUpperCase().equals("M") ? String.valueOf(nf.format((double)size / 1024.0 / 1024.0)) + " MB" : String.valueOf(nf.format((double)size)) + " Byte");
        return filesize;
    }

    public static Vector viewDirectory(String curPath, int curDepth) throws Exception {
        Vector<FileSystemInfoEntity> result = new Vector<FileSystemInfoEntity>();
        String path = curPath;
        int depth = curDepth + 1;
        System.out.println("Path : " + path);
        File vfile = new File(path);
        if (vfile.exists() && vfile.isDirectory()) {
            FileSystemInfoEntity entity = new FileSystemInfoEntity();
            entity.name = vfile.getName();
            entity.fileTp = "D";
            entity.depth = depth;
            String[] sfile = vfile.list();
            if (sfile != null) {
                entity.isList = true;
            }
            result.add(entity);
            if (sfile != null) {
                int i = 0;
                while (i < sfile.length) {
                    Vector sRes = CmUtil.viewDirectory(String.valueOf(path) + "/" + sfile[i], depth);
                    if (sRes != null) {
                        result.addAll(sRes);
                    }
                    ++i;
                }
            }
        } else {
            return null;
        }
        return result;
    }

    public static boolean createDirectory(String path) throws Exception {
        String strPath = String.valueOf(UtilConst.UFO_SYS) + CmUtil.nullTrim(path);
        File dir = new File(strPath);
        if (dir.isDirectory() && dir.exists()) {
            return true;
        }
        Vector<String> vtPath = new Vector<String>();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            vtPath.add(st.nextToken());
        }
        try {
            strPath = UtilConst.UFO_SYS;
            int i = 0;
            while (i < vtPath.size()) {
                dir = new File(strPath = String.valueOf(strPath) + "/" + CmUtil.nullTrim((String)vtPath.get(i)));
                if (!dir.exists() || !dir.isDirectory()) {
                    System.out.println("[UFO]Create Directory : " + strPath);
                    dir.mkdir();
                }
                ++i;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String copyFile(String source, String targetDirectory) throws Exception {
        return CmUtil.copyFile(source, targetDirectory, true);
    }

    public static String copyFile(String source, String targetDirectory, boolean mkDir) throws Exception {
        int i;
        String tarFileNm = "";
        File srcFile = null;
        File tarDir = null;
        File tarFile = null;
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        tarDir = new File(CmUtil.nullTrim(targetDirectory));
        if (!tarDir.exists() || !tarDir.isDirectory()) {
            if (mkDir) {
                tarDir.mkdir();
            } else {
                throw new Exception("[UFO] Error : Not Fount Target Directory.");
            }
        }
        srcFile = new File(CmUtil.nullTrim(source));
        String tarfileNm = String.valueOf(CmUtil.nullTrim(targetDirectory)) + srcFile.getName();
        tarFile = new File(tarfileNm);
        if (tarFile.exists()) {
            i = 1;
            while (i > 0) {
                tarfileNm = String.valueOf(CmUtil.nullTrim(targetDirectory)) + "dup" + i + "_" + srcFile.getName();
                tarFile = new File(tarfileNm);
                if (!tarFile.exists()) break;
                ++i;
            }
        }
        bis = new BufferedInputStream(new FileInputStream(srcFile));
        bos = new BufferedOutputStream(new FileOutputStream(tarFile));
        i = 0;
        while ((i = bis.read()) != -1) {
            bos.write(i);
        }
        bis.close();
        bos.close();
        return tarFile.getName();
    }

    public static boolean deleteFile(String fileNm) throws Exception {
        File file = new File(CmUtil.nullTrim(fileNm));
        if (file.isFile() && file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static String moveFile(String source, String targetDirectory) throws Exception {
        String tarFileNm = CmUtil.copyFile(source, targetDirectory);
        CmUtil.deleteFile(source);
        return tarFileNm;
    }

    public static String encodeURL(String str) throws UnsupportedEncodingException {
        if (str == null || str.length() < 1) {
            return "";
        }
        String tStr = new String(str.getBytes(), "euc-kr");
        String result = CmUtil.replace(URLEncoder.encode(str), "+", "%20");
        return result;
    }

    public static String htmlEncode(String str) throws Exception {
        if (str != null && !str.equals("")) {
            str = CmUtil.replace(str, "<", "&lt;");
            str = CmUtil.replace(str, ">", "&gt;");
            str = CmUtil.replace(str, "\"", "&quot;");
        }
        return str;
    }

    public static String jscriptEncode(String str) throws Exception {
        if (str != null && !str.equals("")) {
            str = CmUtil.replace(str, "\"", "\\\"");
            str = CmUtil.replace(str, "\n", "\\n");
            str = CmUtil.replace(str, "\r", "");
        }
        return str;
    }

    public static String replace(String str, String pattern, String replace) {
        if (str == null || str.length() < 1) {
            return "";
        }
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static String replace(String fullStr, String[] orgStr, String[] newStr) {
        if (!CmUtil.nullTrim(fullStr).equals("")) {
            int idx = orgStr.length;
            if (idx != newStr.length) {
                return fullStr;
            }
            String string = new String(fullStr);
            int[] orgLen = new int[idx];
            int s = 0;
            int buffer = (int)((double)string.length() * 1.5);
            StringBuffer result = new StringBuffer(buffer);
            int i = 0;
            while (i < idx) {
                int e = 0;
                s = 0;
                orgLen[i] = orgStr[i].length();
                while ((e = string.indexOf(orgStr[i], s)) >= 0) {
                    result.append(string.substring(s, e));
                    result.append(newStr[i]);
                    s = e + orgLen[i];
                }
                result = result.append(string.substring(s));
                string = result.toString();
                result.delete(0, string.length());
                ++i;
            }
            return string;
        }
        return "";
    }

    public static String removeHTML(String strHTML) {
        String pattern = "<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>";
        RE re = new RE(pattern);
        return re.subst(strHTML, " ", 0);
    }

    public static String rtrim(String str) {
        if (str == null) {
            return "";
        }
        int i = str.length() - 1;
        while (i >= 0) {
            if (str.charAt(i) != ' ') {
                return str.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public static String ltrim(String str) {
        if (str == null) {
            return "";
        }
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) != ' ') {
                return str.substring(i);
            }
            ++i;
        }
        return "";
    }

    public static String null2Zero(String str) {
        str = str == null || CmUtil.nullTrim(str).equals("") ? "0" : str.trim();
        return str;
    }

    public static String nullTrim(String str) {
        str = str == null ? "" : str.trim();
        return str;
    }

    public static String null2String(String str, String str2) {
        if (str == null) {
            str = "";
            str = str2 == null ? "" : str2;
        } else {
            str = str.trim();
        }
        return str;
    }

    public static String br2n(String str) {
        return CmUtil.replace(str, "<br>", "\n");
    }

    public static String n2br(String str) {
        return CmUtil.replace(str, "\n", "<br>");
    }

    public static String bk2n(String str) {
        return CmUtil.replace(str, " ", "\n");
    }

    public static String n2bk(String str) {
        return CmUtil.replace(str, "\n", " ");
    }

    public static String removeHyphen(String str) {
        return CmUtil.nullTrim(CmUtil.replace(str, "-", ""));
    }

    public static String removeComma(String str) {
        return CmUtil.nullTrim(CmUtil.replace(str, ",", ""));
    }

    public static UFORequest msg2Request(UFORequest info, Message msg, String emailCd) throws Exception {
        UFORequest request = new UFORequest(info.getRequest(), "MAIL2");
        StringBuffer sendNm = new StringBuffer();
        StringBuffer sendEmail = new StringBuffer();
        StringBuffer recvNm = new StringBuffer();
        StringBuffer recvEmail = new StringBuffer();
        String subject = "";
        String contents = "";
        InternetAddress[] sender = (InternetAddress[])msg.getFrom();
        int s = 0;
        while (s < sender.length) {
            if (s > 0) {
                sendNm.append("\ufffd\ufffd");
                sendEmail.append("\ufffd\ufffd");
            }
            sendNm.append(sender[s].getPersonal());
            sendEmail.append(sender[s].getAddress());
            ++s;
        }
        InternetAddress[] receiver = (InternetAddress[])msg.getRecipients(Message.RecipientType.TO);
        int r = 0;
        while (r < receiver.length) {
            if (r > 0) {
                recvNm.append("\ufffd\ufffd");
                recvEmail.append("\ufffd\ufffd");
            }
            recvNm.append(receiver[r].getPersonal());
            recvEmail.append(receiver[r].getAddress());
            ++r;
        }
        subject = msg.getSubject();
        Object obj = msg.getContent();
        if (obj instanceof String) {
            contents = (String)obj;
        } else if (obj instanceof Multipart) {
            MimeMultipart mpart = (MimeMultipart)obj;
            MimeBodyPart bp = (MimeBodyPart)mpart.getBodyPart(0);
            contents = (String)bp.getContent();
        }
        request.put("emailCd", emailCd);
        request.put("sendNm", sendNm.toString());
        request.put("sendEmail", sendEmail.toString());
        request.put("recvNm", recvNm.toString());
        request.put("recvEmail", recvEmail.toString());
        request.put("subject", subject);
        request.put("contents", contents);
        return request;
    }

    /*
     * Unable to fully structure code
     */
    public static String replaceWec(String original, String oldstr, String newstr) {
        convert = new String();
        pos = 0;
        begin = 0;
        pos = original.indexOf(oldstr);
        if (pos != -1) ** GOTO lbl10
        return original;
lbl-1000:
        // 1 sources

        {
            convert = String.valueOf(convert) + original.substring(begin, pos) + newstr;
            begin = pos + oldstr.length();
            pos = original.indexOf(oldstr, begin);
lbl10:
            // 2 sources

            ** while (pos != -1)
        }
lbl11:
        // 1 sources

        convert = String.valueOf(convert) + original.substring(begin);
        return convert;
    }

    public static String convertHtmlcharsWec(String htmlstr) {
        String convert = new String();
        convert = CmUtil.replaceWec(htmlstr, "<", "&lt;");
        convert = CmUtil.replaceWec(convert, ">", "&gt;");
        convert = CmUtil.replaceWec(convert, "\"", "&quot;");
        convert = CmUtil.replaceWec(convert, "&nbsp;", "&amp;nbsp;");
        return convert;
    }

    public static boolean chmodFile(String fileNm, int mod) {
        boolean rvResult = false;
        if (!(System.getProperty("os.name", "").equals("AIX") && System.getProperty("os.version", "").equals("5.3") && System.getProperty("java.version", "").startsWith("1.4"))) {
            return false;
        }
        if (fileNm == null) {
            return false;
        }
        if (fileNm.indexOf("*") != -1) {
            return false;
        }
        if (fileNm.indexOf("?") != -1) {
            return false;
        }
        if (mod > 777 || mod < 111) {
            return false;
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec("chmod " + mod + " " + fileNm);
            InputStream is = process.getErrorStream();
            rvResult = is.read() == -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return rvResult;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static String padding(int repeat, char padChar) throws IndexOutOfBoundsException {
        if (repeat < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat);
        }
        char[] buf = new char[repeat];
        int i = 0;
        while (i < buf.length) {
            buf[i] = padChar;
            ++i;
        }
        return new String(buf);
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return CmUtil.leftPad(str, size, String.valueOf(padChar));
        }
        return CmUtil.padding(pads, padChar).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (CmUtil.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return CmUtil.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        int i = 0;
        while (i < pads) {
            padding[i] = padChars[i % padLen];
            ++i;
        }
        return new String(padding).concat(str);
    }

    public static String lessen(String content, int length) {
        if (content != null) {
            if (content.length() > length) {
                content = String.valueOf(content.substring(0, length).trim()) + "...";
            }
        } else {
            content = "";
        }
        return content;
    }

    public static String encrypt(String strVal) throws Exception {
        String rv = null;
        if (strVal == null || "".equals(strVal)) {
            return strVal;
        }
        try {
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ufo.common.utility.CmUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ObjectInputStream ois = new ObjectInputStream(clazz.getResourceAsStream("CmUtil.key"));
            Key key = (Key)ois.readObject();
            ois.close();
            cipher.init(1, key);
            String amalgam = strVal;
            byte[] inputBytes1 = amalgam.getBytes("8859_1");
            byte[] outputBytes1 = cipher.doFinal(inputBytes1);
            BASE64Encoder encoder = new BASE64Encoder();
            rv = encoder.encode(outputBytes1);
            rv = CmUtil.replace(rv, "\t", "_t");
            rv = CmUtil.replace(rv, "\b", "_b");
            rv = CmUtil.replace(rv, "\n", "_n");
            rv = CmUtil.replace(rv, "\r", "_r");
            rv = CmUtil.replace(rv, "\f", "_f");
            rv = CmUtil.replace(rv, "'", "_q");
            rv = CmUtil.replace(rv, "\"", "_Q");
            rv = CmUtil.replace(rv, "\\", "__");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rv;
    }

    public static String decrypt(String strVal) {
        String rv = null;
        if (strVal == null || "".equals(strVal)) {
            return strVal;
        }
        try {
            strVal = CmUtil.replace(strVal, "_t", "\t");
            strVal = CmUtil.replace(strVal, "_b", "\b");
            strVal = CmUtil.replace(strVal, "_n", "\n");
            strVal = CmUtil.replace(strVal, "_r", "\r");
            strVal = CmUtil.replace(strVal, "_f", "\f");
            strVal = CmUtil.replace(strVal, "_q", "'");
            strVal = CmUtil.replace(strVal, "_Q", "\"");
            strVal = CmUtil.replace(strVal, "__", "\\");
            Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ufo.common.utility.CmUtil");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ObjectInputStream ois = new ObjectInputStream(clazz.getResourceAsStream("CmUtil.key"));
            Key key = (Key)ois.readObject();
            ois.close();
            cipher.init(2, key);
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] inputBytes1 = decoder.decodeBuffer(strVal);
            byte[] outputBytes2 = cipher.doFinal(inputBytes1);
            rv = new String(outputBytes2, "8859_1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rv;
    }

    public static String getIdHidden(String id) {
        if (id == null || id.equals("")) {
            return "";
        }
        if (id.length() < 2) {
            return id;
        }
        String temp = id.substring(id.length() - 2, id.length());
        String tail = "";
        int i = 0;
        while (i < temp.length()) {
            tail = String.valueOf(tail) + "*";
            ++i;
        }
        return String.valueOf(id.substring(0, id.length() - 2)) + tail;
    }
}

