/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.common.base;

import com.ufo.common.UFOException;
import com.ufo.common.db.APDBConnection;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UFOBaseWB {
    protected static final Log LOG;
    private String siteCd = null;
    private boolean isConn = true;
    private boolean isTransaction = false;
    private APDBConnection apConn = null;
    private Connection conn = null;
    private String caller = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ufo.common.base.UFOBaseWB");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public UFOBaseWB() {
    }

    public UFOBaseWB(String siteCd) {
        this.siteCd = siteCd;
    }

    public UFOBaseWB(String siteCd, Connection conn) {
        this.siteCd = siteCd;
        this.conn = conn;
        this.isConn = false;
    }

    public UFOBaseWB(Connection conn) {
        this.conn = conn;
        this.isConn = false;
    }

    public Connection getConnection(Object obj) throws UFOException {
        return this.getConnection(obj.getClass().getName());
    }

    public Connection getConnection(String caller) throws UFOException {
        try {
            if (this.conn == null) {
                if (this.apConn == null) {
                    this.apConn = new APDBConnection(caller);
                }
                this.conn = this.apConn.getConnection();
            }
        }
        catch (Exception ex) {
            throw new UFOException(this.getClass().getName(), "DBM-0100", "[GET-CONNECTION]", ex);
        }
        return this.conn;
    }

    public void startTransaction() throws UFOException {
        try {
            if (this.isConn && !this.conn.isClosed()) {
                this.conn.setAutoCommit(false);
            }
        }
        catch (SQLException sqlEx) {
            throw new UFOException(this.getClass().getName(), "DBM-0101", "[TRANSACTION_START]", sqlEx);
        }
    }

    public void commit() throws UFOException {
        try {
            if (this.isConn && !this.conn.isClosed()) {
                this.conn.commit();
                this.conn.setAutoCommit(true);
            }
        }
        catch (SQLException sqlEx) {
            throw new UFOException(this.getClass().getName(), "DBM-0101", "[TRANS-COMMIT]", sqlEx);
        }
    }

    public void rollback() throws UFOException {
        try {
            if (this.isConn && !this.conn.isClosed()) {
                this.conn.rollback();
                this.conn.setAutoCommit(true);
            }
        }
        catch (SQLException sqlEx) {
            throw new UFOException(this.getClass().getName(), "DBM-0101", "[TRANS-ROLLBACK]", sqlEx);
        }
    }

    public void closeConnection() throws UFOException {
        try {
            if (this.isConn && this.conn != null) {
                if (!this.conn.isClosed()) {
                    this.conn.close();
                }
                this.apConn.closeConnection();
                this.conn = null;
                this.apConn = null;
            }
        }
        catch (Exception ex) {
            throw new UFOException(this.getClass().getName(), "DBM-0100", "[RELESE_CONNECTION]", ex);
        }
    }
}

