/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.common;

import com.namo.NamoMime;
import com.oreilly.servlet.MultipartRequest;
import com.ufo.common.utility.CmUtil;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class UFORequest
extends Hashtable {
    private boolean isFile = true;
    private boolean isPage = true;
    private int curPage = 1;
    private int pageSize = 10;
    private String name = null;
    private HttpServletRequest request = null;
    private MultipartRequest multiRequest = null;

    public UFORequest() {
        this.name = "unknown";
    }

    public UFORequest(String name) {
        this.name = name;
    }

    public UFORequest(HttpServletRequest request) {
        this.request = request;
    }

    public UFORequest(HttpServletRequest request, String name) {
        this.name = name;
        this.request = request;
    }

    public Object clone() {
        return super.clone();
    }

    public UFORequest cloneReq(String name) {
        UFORequest newReq = new UFORequest(name);
        newReq.isPage = this.isPage;
        newReq.request = this.request;
        newReq.multiRequest = this.multiRequest;
        UFORequest src = this;
        UFORequest target = newReq;
        Enumeration e = src.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = src.get((Object)key);
            target.put(key, value);
        }
        return newReq;
    }

    public Object get(String key) {
        return super.get(key.toUpperCase());
    }

    public void put(String key, Object obj) {
        if (obj != null) {
            super.put(key.toUpperCase(), obj);
        }
    }

    public void put(String key, boolean bool) {
        super.put(key.toUpperCase(), new Boolean(bool));
    }

    public void put(String key, int num) {
        super.put(key.toUpperCase(), new Integer(num));
    }

    public void put(String key, long num) {
        super.put(key.toUpperCase(), new Long(num));
    }

    public void put(String key, float num) {
        super.put(key.toUpperCase(), new Float(num));
    }

    public void put(String key, double num) {
        super.put(key.toUpperCase(), new Double(num));
    }

    public void remove(String key) {
        super.remove(key.toUpperCase());
    }

    public boolean isEquals(String key, String str) {
        return CmUtil.nullTrim(this.getString(key.toUpperCase())).equals(str);
    }

    public boolean isArray(String key) {
        boolean result = false;
        try {
            int length;
            Object o = super.get(key.toUpperCase());
            Class<?> c = o.getClass();
            if (o != null && c.isArray() && (length = Array.getLength(o)) > 1) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isExist(String key) {
        return super.containsKey(key.toUpperCase());
    }

    public boolean isSpace(String key) {
        String value;
        return !this.isExist(key) || (value = this.getString(key.toUpperCase())) == null || value.trim().equals("");
    }

    public String getString(String key) {
        String value = "";
        try {
            Object item;
            int length;
            Object o = super.get(key.toUpperCase());
            Class<?> c = o.getClass();
            value = o == null ? "" : (c.isArray() ? ((length = Array.getLength(o)) == 0 ? "" : ((item = Array.get(o, 0)) == null ? "" : item.toString())) : o.toString());
        }
        catch (Exception e) {
            value = "";
        }
        return value;
    }

    public boolean getBoolean(String key) {
        boolean isTrue = false;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Boolean) {
                Boolean tmp = (Boolean)obj;
                isTrue = tmp;
            } else {
                String value = this.getString(key.toUpperCase());
                isTrue = new Boolean(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isTrue;
    }

    public String getYN(String key) {
        String str = this.getString(key).toUpperCase();
        if (this.getBoolean(key) || str.equals("Y") || str.equals("YES") || str.equals("ON") || str.equals("1")) {
            return "Y";
        }
        return "N";
    }

    public double getDouble(String key) {
        double num = 0.0;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Double) {
                Double tmp = (Double)obj;
                num = tmp;
            } else {
                String value = UFORequest.removeComma(this.getString(key.toUpperCase()));
                if (!value.equals("")) {
                    num = Double.valueOf(value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public float getFloat(String key) {
        float num = 0.0f;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Float) {
                Float tmp = (Float)obj;
                num = tmp.floatValue();
            } else {
                num = (float)this.getDouble(key.toUpperCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public int getInt(String key) {
        int num = 0;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Integer) {
                Integer tmp = (Integer)obj;
                num = tmp;
            } else {
                num = (int)this.getDouble(key.toUpperCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public long getLong(String key) {
        long num = 0L;
        try {
            Object obj = this.get(key.toUpperCase());
            if (obj instanceof Long) {
                Long tmp = (Long)obj;
                num = tmp;
            } else {
                num = (long)this.getDouble(key.toUpperCase());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return num;
    }

    public String[] getArray(String key) {
        String[] arr = null;
        try {
            Object o = super.get(key.toUpperCase());
            Class<?> c = o.getClass();
            if (o != null) {
                if (c.isArray()) {
                    int length = Array.getLength(o);
                    if (length != 0) {
                        arr = new String[length];
                        int i = 0;
                        while (i < length) {
                            Object item = Array.get(o, i);
                            arr[i] = item == null ? "" : item.toString();
                            ++i;
                        }
                    }
                } else {
                    arr = new String[]{o.toString()};
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arr;
    }

    public Vector getVector(String key) {
        Vector<String> vector = new Vector<String>();
        try {
            Object o = super.get(key.toUpperCase());
            Class<?> c = o.getClass();
            if (o != null) {
                if (c.isArray()) {
                    int length = Array.getLength(o);
                    if (length != 0) {
                        int i = 0;
                        while (i < length) {
                            Object item = Array.get(o, i);
                            if (item == null) {
                                vector.addElement("");
                            } else {
                                vector.addElement(item.toString());
                            }
                            ++i;
                        }
                    }
                } else {
                    vector.addElement(o.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    public String getFileName(String key) {
        String fileName = "";
        if (this.multiRequest == null) {
            return null;
        }
        int index = -1;
        String[] arrForm = this.getArray("_fileForm");
        if (arrForm != null) {
            int i = 0;
            while (i < arrForm.length) {
                if (arrForm[i].equals(key)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                String[] arrFileName = this.getArray("_fileNm");
                fileName = arrFileName[index];
            }
        }
        return fileName;
    }

    public String getFileExt(String key) {
        String fileExt = "";
        if (this.multiRequest == null) {
            return null;
        }
        int index = -1;
        String[] arrForm = this.getArray("_fileForm");
        if (arrForm != null) {
            int i = 0;
            while (i < arrForm.length) {
                if (arrForm[i].equals(key)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                String[] arrFileExt = this.getArray("_fileExt");
                fileExt = arrFileExt[index];
            }
        }
        return fileExt;
    }

    public long getFileSize(String key) {
        long fileSize = 0L;
        if (this.multiRequest == null) {
            return 0L;
        }
        int index = -1;
        String[] arrForm = this.getArray("_fileForm");
        if (arrForm != null) {
            int i = 0;
            while (i < arrForm.length) {
                if (arrForm[i].equals(key)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index != -1) {
                String[] arrFileSize = this.getArray("_fileSize");
                fileSize = Long.parseLong(arrFileSize[index]);
            }
        }
        return fileSize;
    }

    public void saveWecFile(String key, String saveURL, String savePath) throws Exception {
        this.saveWecFile(key, saveURL, savePath, null);
    }

    public void saveWecFile(String key, String saveURL, String savePath, String encType) throws Exception {
        if (!this.isEquals("wec_flag", "Y")) {
            return;
        }
        String msgbody = this.getString(key);
        String textCnts = "";
        NamoMime mime = new NamoMime();
        mime.setSaveURL(saveURL);
        mime.setSavePath(savePath);
        mime.decode(msgbody);
        mime.saveFile();
        Hashtable fileInfo = mime.getFileInfo();
        this.put("wec_fileExt", fileInfo.get("wec_fileExt"));
        this.put("wec_fileSize", fileInfo.get("wec_fileSize"));
        this.put("wec_fileNm", fileInfo.get("wec_fileNm"));
        this.put("wec_filePath", fileInfo.get("wec_filePath"));
        this.put("wec_flag", "Y");
        textCnts = CmUtil.replaceWec(mime.getBodyContent(), "'", "\\'");
        String[] fileNm = this.getArray("wec_fileNm");
        if (fileNm != null) {
            int i = 0;
            while (i < fileNm.length) {
                String tmpNm = fileNm[i];
                textCnts = CmUtil.replace(textCnts, tmpNm, CmUtil.encodeURL(tmpNm));
                ++i;
            }
        }
        if (encType != null) {
            this.put(key, new String(textCnts.getBytes(), encType));
        } else {
            this.put(key, textCnts);
        }
    }

    private static String removeComma(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(",") != -1) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c != ',') {
                    buf.append(c);
                }
                ++i;
            }
            return buf.toString();
        }
        return str;
    }

    public UFORequest[] toArray(String[] splitAttr) {
        return this.toArray(this, splitAttr, null);
    }

    public UFORequest[] toArray(String[] splitAttr, String[] keepAttr) {
        return this.toArray(this, splitAttr, keepAttr);
    }

    public UFORequest[] toArray(UFORequest info, String[] splitAttr) {
        return this.toArray(info, splitAttr, null);
    }

    public UFORequest[] toArray(UFORequest info, String[] splitAttr, String[] keepAttr) {
        if (splitAttr == null) {
            System.err.println("UFO Warning : [String[] splitAttr is null.");
            return null;
        }
        int length = 0;
        UFORequest[] arrReq = null;
        int i = 0;
        while (i < splitAttr.length) {
            String name = splitAttr[i].toUpperCase();
            String[] arr = this.getArray(name);
            if (arr == null) {
                System.err.println("UFO Warning : [" + name + "] Attribute is null.");
                return null;
            }
            if (i == 0) {
                length = arr.length;
                arrReq = new UFORequest[length];
                int r = 0;
                while (r < length) {
                    arrReq[r] = keepAttr != null ? new UFORequest() : info.cloneReq("ARR" + r);
                    ++r;
                }
            } else if (i > 0 && length != arr.length) {
                System.err.println("UFO Warning : Each Array's Length is different.");
                return null;
            }
            int j = 0;
            while (j < length) {
                if (keepAttr != null) {
                    int k = 0;
                    while (k < keepAttr.length) {
                        arrReq[j].setRequest(info.getRequest());
                        if (this.isExist(keepAttr[k].toUpperCase())) {
                            arrReq[j].put(keepAttr[k].toUpperCase(), this.getString(keepAttr[k].toUpperCase()));
                        }
                        ++k;
                    }
                }
                arrReq[j].put(name, arr[j]);
                ++j;
            }
            ++i;
        }
        return arrReq;
    }

    public String getIPAddr() {
        return this.request.getRemoteAddr();
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration keys = this.keys();
        Enumeration objects = this.elements();
        buf.append("{");
        int i = 0;
        while (i <= max) {
            String key = keys.nextElement().toString();
            String value = null;
            Object o = objects.nextElement();
            if (o == null) {
                value = "";
            } else {
                Class<?> c = o.getClass();
                if (c.isArray()) {
                    int length = Array.getLength(o);
                    if (length == 0) {
                        value = "";
                    } else if (length == 1) {
                        Object item = Array.get(o, 0);
                        value = item == null ? "" : item.toString();
                    } else {
                        StringBuffer valueBuf = new StringBuffer();
                        valueBuf.append("[");
                        int j = 0;
                        while (j < length) {
                            Object item = Array.get(o, j);
                            if (item != null) {
                                valueBuf.append(item.toString());
                            }
                            if (j < length - 1) {
                                valueBuf.append(",");
                            }
                            ++j;
                        }
                        valueBuf.append("]");
                        value = valueBuf.toString();
                    }
                } else {
                    value = o.toString();
                }
            }
            buf.append(String.valueOf(key) + "=" + value);
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return "UFOReqeust [" + this.name + "]:" + buf.toString();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public MultipartRequest getMultiRequest() {
        return this.multiRequest;
    }

    public void setMultiRequest(MultipartRequest request) {
        this.multiRequest = request;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public void setFile(boolean b) {
        this.isFile = b;
    }

    public boolean isPage() {
        return this.isPage;
    }

    public void setPage(boolean b) {
        this.isPage = b;
    }

    public int getCurPage() {
        return this.curPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setCurPage(int i) {
        this.curPage = i;
    }

    public void setPageSize(int i) {
        this.pageSize = i;
    }
}

