/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.common;

import com.ufo.common.utility.UtilConst;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class LogManager {
    static String logFileInterval = "1";
    static String logFilePath_realserver = String.valueOf(UtilConst.UFO_SYS) + "/UFOLogs/";
    static String devSVRtraceLevel = "0";
    private Hashtable LOGQueue = new Hashtable();
    private static LogManager thisInstance;

    private LogManager() {
        LogWriter logWriter = new LogWriter();
        logWriter.start();
    }

    public static void addDEVLog(int traceLevel, String developerID, String className, String methodName, String description) {
        LogManager.addDEVLog(traceLevel, developerID, className, methodName, description, null);
    }

    public static void addDEVLog(int traceLevel, String developerID, String className, String methodName, String description, String comment) {
        int settingLevel = Integer.parseInt(devSVRtraceLevel);
        if (settingLevel == 0 || traceLevel > settingLevel) {
            return;
        }
        LogManager.getInstance();
        StringBuffer logSTR = new StringBuffer();
        logSTR.append("[").append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
        logSTR.append("] [").append(className);
        logSTR.append("] [").append(methodName);
        logSTR.append("] [").append("level:" + traceLevel);
        logSTR.append("] [").append(description);
        if (comment != null) {
            logSTR.append("] [").append(comment);
        }
        logSTR.append("]");
        if (className.indexOf("jsp") != -1 && description.equals("End")) {
            logSTR.append(System.getProperty("line.separator"));
        }
        thisInstance.addLogMessage("dev" + developerID, logSTR.toString());
    }

    public static synchronized LogManager getInstance() {
        if (thisInstance == null) {
            thisInstance = new LogManager();
            System.setProperty("LogManager", String.valueOf(thisInstance.hashCode()));
        }
        return thisInstance;
    }

    public static void addERRLog(String className, String infomationMessage, String description) {
        LogManager.addSYSLog("ERR", className, infomationMessage, description);
    }

    private void addLogMessage(String logID, String logMessage) {
        Vector<String> objVec = (Vector<String>)this.LOGQueue.get(logID);
        if (objVec == null) {
            objVec = new Vector<String>();
            this.LOGQueue.put(logID, objVec);
        }
        objVec.addElement(logMessage);
    }

    public static void addParamLog(String developerID, String className, HttpServletRequest req) {
        String parameters = "";
        Enumeration enumS = req.getParameterNames();
        while (enumS.hasMoreElements()) {
            String name = (String)enumS.nextElement();
            parameters = String.valueOf(parameters) + name + ":[" + req.getParameter(name) + "],  ";
        }
        LogManager.addDEVLog(4, developerID, className, "getParameter", parameters);
    }

    public static void addSYSLog(String systemID, String className, String infomationMessage) {
        LogManager.addSYSLog(systemID, className, infomationMessage, null);
    }

    public static void addSYSLog(String systemID, String className, String infomationMessage, String description) {
        LogManager.getInstance();
        StringBuffer logSTR = new StringBuffer();
        logSTR.append("[").append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
        logSTR.append("] [").append(className);
        logSTR.append("] [").append(infomationMessage);
        if (description != null) {
            logSTR.append("] [").append(description);
        }
        logSTR.append("]");
        thisInstance.addLogMessage(systemID, logSTR.toString());
    }

    class LogWriter
    extends Thread {
        public void run() {
            LogManager.getInstance();
            String logID = "";
            Vector objVec = null;
            while (true) {
                try {
                    Enumeration enumS = LogManager.this.LOGQueue.keys();
                    while (enumS.hasMoreElements()) {
                        logID = (String)enumS.nextElement();
                        objVec = (Vector)LogManager.this.LOGQueue.get(logID);
                        if (objVec.size() == 0) continue;
                        this.LogWriting(logID, objVec);
                    }
                }
                catch (Exception e) {
                    break;
                }
                try {
                    String oldHashCode = System.getProperty("LogManager");
                    String thisHashCode = String.valueOf(thisInstance.hashCode());
                    if (oldHashCode != null && !oldHashCode.equals(thisHashCode)) break;
                    Thread.sleep(Long.parseLong(logFileInterval) * 1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            thisInstance = null;
        }

        public void LogWriting(String logID, Vector QName) throws Exception {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String logginPath = "";
            logginPath = logFilePath_realserver;
            String time = new SimpleDateFormat("yyyyMMdd").format(new Date());
            String FileName = String.valueOf(logginPath) + logID + time + ".log";
            try {
                File logFile = new File(FileName);
                PrintWriter writer = null;
                String fileName = logFile.getAbsolutePath();
                FileWriter fw = new FileWriter(fileName, true);
                writer = new PrintWriter((Writer)new BufferedWriter(fw), false);
                Vector mQueue = (Vector)QName.clone();
                QName.clear();
                int i = 0;
                while (i < mQueue.size()) {
                    writer.println((String)mQueue.get(i));
                    ++i;
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                System.out.println(":::::::::: " + FileName + "\ufffd\ufffd \ufffd\ufffd\ufffd\u4e2e\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\u02bd\ufffd\ufffd\u03f4\ufffd.");
                throw e;
            }
        }
    }
}

