/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.bbs;

import com.ufo.bbs.UFOBbsMgmtDAO;
import com.ufo.bbs.entity.BbsAttachEntity;
import com.ufo.bbs.entity.BbsInfoEntity;
import com.ufo.bbs.entity.BbsMainEntity;
import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;
import com.ufo.common.utility.UtilConst;
import java.util.Vector;
import javax.servlet.http.HttpSession;

public class UFOBbsMgmtWB
extends UFOBaseWB {
    public UFOBbsMgmtWB() {
    }

    public UFOBbsMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOBbsMgmtWB(UFORequest info) throws UFOException {
        super(info.getString("siteCd"));
        BbsInfoEntity bbsInfo = null;
        HttpSession session = info.getRequest().getSession();
        bbsInfo = (BbsInfoEntity)session.getAttribute("__ufo_bbs_info");
        try {
            try {
                if (!info.isSpace("siteCd") || !info.isSpace("bbsCd")) {
                    session.removeAttribute("__ufo_bbs_info");
                    UFORequest req = new UFORequest();
                    UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this));
                    bbsInfo = dao.selectBbsInfo(info);
                    session.setAttribute("__ufo_bbs_info", (Object)bbsInfo);
                    info.put("__ufo_bbs_info", bbsInfo);
                    if (bbsInfo != null) {
                        info.put("__ufo_bbs_path", bbsInfo.attachPath);
                    }
                }
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[BBS_WB_CON]", ex);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public UFOResult searchBbsInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchBbsInfo(info));
            }
            catch (Exception etcEx) {
                etcEx.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_INFO_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBbsSeq(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this));
                result.put("BBSSEQ", dao.selectBbsSeq(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_BBSSEQ_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBbsInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectBbsInfo(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_INFO_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertBbsInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                CmUtil.createDirectory(info.getString("attachPath"));
                resCnt = dao.insertBbsInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_INFO_INSERT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateBbsInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                CmUtil.createDirectory(info.getString("attachPath"));
                resCnt = dao.updateBbsInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_INFO_UPDATE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteBbsInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        int resCnt = 0;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this));
                this.startTransaction();
                resCnt = dao.deleteBbsInfo(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception etcEx) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_INFO_DELETE", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchBbsList(UFORequest info) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        Vector bbsList = null;
        int bbsListCnt = 0;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ID)) {
                        info.put("cstmId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER) || info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("cstmNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("notes1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("notes2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE3)) {
                        info.put("notes3", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE4)) {
                        info.put("notes4", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_IP)) {
                        info.put("ip", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                if (CmUtil.nullTrim(bbsInfo.replyFl).equals("Y")) {
                    bbsList = dao.searchReList(info);
                    bbsListCnt = dao.getReListCnt(info);
                } else {
                    bbsList = dao.searchList(info);
                    bbsListCnt = dao.getListCnt(info);
                }
                if (bbsList != null && (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") || CmUtil.nullTrim(bbsInfo.comtFl).equals("Y") || CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y"))) {
                    int i = 0;
                    while (i < bbsList.size()) {
                        Vector vt1;
                        BbsMainEntity entity = (BbsMainEntity)bbsList.get(i);
                        if (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") && (vt1 = dao.searchFTList(entity.toRequest())) != null) {
                            entity.fileVt = vt1;
                            entity.fileCnt = vt1.size();
                        }
                        if (CmUtil.nullTrim(bbsInfo.comtFl).equals("Y")) {
                            UFORequest cReq = entity.toRequest();
                            if (info.isExist("comtPage") && info.isExist("comtSize")) {
                                cReq.put("comtPage", info.getInt("comtPage"));
                                cReq.put("comtSize", info.getInt("comtSize"));
                                entity.comtVt = dao.searchDTListPaging(cReq);
                                entity.comtCnt = dao.getDTListCnt(cReq);
                            } else {
                                entity.comtVt = dao.searchDTList(cReq);
                                entity.comtCnt = dao.getDTListCnt(cReq);
                            }
                        }
                        if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y")) {
                            UFORequest pReq = entity.toRequest();
                            pReq.put("notes", info.getString("notes"));
                            Vector prdtVt = dao.searchPTList(pReq);
                            if (prdtVt != null) {
                                entity.prdtVt = prdtVt;
                                entity.prdtCnt = prdtVt.size();
                            }
                        }
                        ++i;
                    }
                }
                result.put("LIST", bbsList);
                result.put("TOTCNT", bbsListCnt);
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_LIST_SEARCH", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBbsBasicList(UFORequest info) throws Exception {
        return this.selectBbsBasicList(info, true);
    }

    public UFOResult selectBbsBasicList(UFORequest info, boolean isView) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        BbsMainEntity entity = null;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                if (isView) {
                    dao.hitReadCnt(info);
                }
                if ((entity = dao.selectBbsBasic(info)) != null) {
                    Vector vt1;
                    if (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") && (vt1 = dao.searchFTList(entity.toRequest())) != null) {
                        entity.fileVt = vt1;
                        entity.fileCnt = vt1.size();
                    }
                    if (CmUtil.nullTrim(bbsInfo.comtFl).equals("Y")) {
                        UFORequest cReq = entity.toRequest();
                        if (info.isExist("comtPage") && info.isExist("comtSize")) {
                            cReq.put("comtPage", info.getInt("comtPage"));
                            cReq.put("comtSize", info.getInt("comtSize"));
                            entity.comtVt = dao.searchDTListPaging(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        } else {
                            entity.comtVt = dao.searchDTList(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        }
                    }
                    if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y")) {
                        UFORequest pReq = entity.toRequest();
                        pReq.put("notes", info.getString("notes"));
                        Vector prdtVt = dao.searchPTList(pReq);
                        if (prdtVt != null) {
                            entity.prdtVt = prdtVt;
                            entity.prdtCnt = prdtVt.size();
                        }
                    }
                }
                result.put("VIEW", entity);
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_LIST_SELECT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBbsList(UFORequest info) throws Exception {
        return this.selectBbsList(info, true);
    }

    public UFOResult selectBbsList(UFORequest info, boolean isView) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        BbsMainEntity entity = null;
        try {
            try {
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ID)) {
                        info.put("cstmId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER) || info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("cstmNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("notes1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("notes2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE3)) {
                        info.put("notes3", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE4)) {
                        info.put("notes4", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                if (isView) {
                    dao.hitReadCnt(info);
                }
                if (CmUtil.nullTrim(bbsInfo.replyFl).equals("Y")) {
                    entity = dao.selectReBbs(info);
                    info.put("rowNo", entity.rowNo);
                    result.put("PREV", dao.selectReBbsByRow(info, "P"));
                    result.put("NEXT", dao.selectReBbsByRow(info, "N"));
                } else {
                    entity = dao.selectBbs(info);
                    info.put("rowNo", entity.rowNo);
                    result.put("PREV", dao.selectBbsByRow(info, "P"));
                    result.put("NEXT", dao.selectBbsByRow(info, "N"));
                }
                if (entity != null) {
                    Vector vt1;
                    if (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") && (vt1 = dao.searchFTList(entity.toRequest())) != null) {
                        entity.fileVt = vt1;
                        entity.fileCnt = vt1.size();
                    }
                    if (CmUtil.nullTrim(bbsInfo.comtFl).equals("Y")) {
                        UFORequest cReq = entity.toRequest();
                        if (info.isExist("comtPage") && info.isExist("comtSize")) {
                            cReq.put("comtPage", info.getInt("comtPage"));
                            cReq.put("comtSize", info.getInt("comtSize"));
                            entity.comtVt = dao.searchDTListPaging(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        } else {
                            entity.comtVt = dao.searchDTList(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        }
                    }
                    if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y")) {
                        UFORequest pReq = entity.toRequest();
                        pReq.put("notes", info.getString("notes"));
                        Vector prdtVt = dao.searchPTList(pReq);
                        if (prdtVt != null) {
                            entity.prdtVt = prdtVt;
                            entity.prdtCnt = prdtVt.size();
                        }
                    }
                }
                result.put("VIEW", entity);
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_LIST_SELECT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBbsList2(UFORequest info) throws Exception {
        return this.selectBbsList2(info, true);
    }

    public UFOResult selectBbsList2(UFORequest info, boolean isView) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        BbsMainEntity entity = null;
        try {
            try {
                UFORequest temp;
                BbsMainEntity analyzeInfo;
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ID)) {
                        info.put("cstmId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER) || info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("cstmNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("notes1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("notes2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE3)) {
                        info.put("notes3", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE4)) {
                        info.put("notes4", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                if (isView) {
                    dao.hitReadCnt(info);
                }
                if (CmUtil.nullTrim(bbsInfo.replyFl).equals("Y")) {
                    entity = dao.selectBbsBasic(info);
                    analyzeInfo = dao.analyzeReBbs(info);
                    if (analyzeInfo != null) {
                        temp = info.cloneReq("ANALYZE");
                        temp.put("bbsSeq", analyzeInfo.prevSeq);
                        result.put("PREVSEQ", analyzeInfo.prevSeq);
                        result.put("PREV", dao.selectBbsBasic(temp));
                        temp.put("bbsSeq", analyzeInfo.nextSeq);
                        result.put("NEXTSEQ", analyzeInfo.nextSeq);
                        result.put("NEXT", dao.selectBbsBasic(temp));
                    }
                } else {
                    entity = dao.selectBbsBasic(info);
                    analyzeInfo = dao.analyzeBbs(info);
                    if (analyzeInfo != null) {
                        temp = info.cloneReq("ANALYZE");
                        temp.put("bbsSeq", analyzeInfo.prevSeq);
                        result.put("PREVSEQ", analyzeInfo.prevSeq);
                        result.put("PREV", dao.selectBbsBasic(temp));
                        temp.put("bbsSeq", analyzeInfo.nextSeq);
                        result.put("NEXTSEQ", analyzeInfo.nextSeq);
                        result.put("NEXT", dao.selectBbsBasic(temp));
                    }
                }
                if (entity != null) {
                    Vector vt1;
                    if (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") && (vt1 = dao.searchFTList(entity.toRequest())) != null) {
                        entity.fileVt = vt1;
                        entity.fileCnt = vt1.size();
                    }
                    if (CmUtil.nullTrim(bbsInfo.comtFl).equals("Y")) {
                        UFORequest cReq = entity.toRequest();
                        if (info.isExist("comtPage") && info.isExist("comtSize")) {
                            cReq.put("comtPage", info.getInt("comtPage"));
                            cReq.put("comtSize", info.getInt("comtSize"));
                            entity.comtVt = dao.searchDTListPaging(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        } else {
                            entity.comtVt = dao.searchDTList(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        }
                    }
                    if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y")) {
                        UFORequest pReq = entity.toRequest();
                        pReq.put("notes", info.getString("notes"));
                        Vector prdtVt = dao.searchPTList(pReq);
                        if (prdtVt != null) {
                            entity.prdtVt = prdtVt;
                            entity.prdtCnt = prdtVt.size();
                        }
                    }
                }
                result.put("VIEW", entity);
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_LIST_SELECT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertBbsList(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                String[] prdtKeepAttr;
                String[] prdtSplitAttr;
                UFORequest[] prdtArrInfo;
                String[] wecKeepAttr;
                String[] wecSplitAttr;
                UFORequest[] wecArrInfo;
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                info.put("bbsSeq", dao.getMaxSeq(info));
                this.startTransaction();
                resCnt = dao.insertBbs(info);
                String[] splitAttr = new String[]{"fileExt", "fileSize", "fileNm"};
                String[] keepAttr = new String[]{"bbsSeq", "filePath", "regId"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (!CmUtil.nullTrim(arrInfo[i].getString("fileNm")).equals("__NULL")) {
                            arrInfo[i].put("fileTp", "A");
                            resCnt1 += dao.insertBbsFT(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (info.isEquals("wec_flag", "Y") && (wecArrInfo = info.toArray(info, wecSplitAttr = new String[]{"wec_fileExt", "wec_fileSize", "wec_fileNm"}, wecKeepAttr = new String[]{"bbsSeq", "wec_filePath", "regId"})) != null) {
                    int i = 0;
                    while (i < wecArrInfo.length) {
                        wecArrInfo[i].put("fileExt", wecArrInfo[i].get("wec_fileExt"));
                        wecArrInfo[i].put("fileSize", wecArrInfo[i].get("wec_fileSize"));
                        wecArrInfo[i].put("fileNm", wecArrInfo[i].get("wec_fileNm"));
                        wecArrInfo[i].put("filePath", wecArrInfo[i].get("wec_filePath"));
                        wecArrInfo[i].put("fileTp", "E");
                        resCnt1 += dao.insertBbsFT(wecArrInfo[i]);
                        ++i;
                    }
                }
                BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
                if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y") && info.isExist("prdtCd") && (prdtArrInfo = info.toArray(info, prdtSplitAttr = new String[]{"prdtCd", "status", "notes"}, prdtKeepAttr = new String[]{"siteCd", "bbsCd", "bbsSeq"})) != null) {
                    int i = 0;
                    while (i < prdtArrInfo.length) {
                        if (CmUtil.nullTrim(prdtArrInfo[i].getString("status")).equals("I")) {
                            resCnt1 += dao.insertBbsPT(prdtArrInfo[i]);
                        } else if (!CmUtil.nullTrim(prdtArrInfo[i].getString("status")).equals("U")) {
                            resCnt1 += dao.deleteBbsPT(prdtArrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    result.put("bbsSeq", info.getInt("bbsSeq"));
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_LIST_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertBbsList2(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                String[] prdtKeepAttr;
                String[] prdtSplitAttr;
                UFORequest[] prdtArrInfo;
                String[] wecKeepAttr;
                String[] wecSplitAttr;
                UFORequest[] wecArrInfo;
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                info.put("bbsSeq", dao.getMaxSeq(info));
                this.startTransaction();
                resCnt = dao.insertBbs(info);
                String[] splitAttr = new String[]{"seq", "fileExt", "fileSize", "fileNm"};
                String[] keepAttr = new String[]{"bbsSeq", "filePath", "regId"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (!CmUtil.nullTrim(arrInfo[i].getString("fileNm")).equals("__NULL")) {
                            arrInfo[i].put("fileTp", "F");
                            resCnt1 += dao.insertBbsFT(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (info.isEquals("wec_flag", "Y") && (wecArrInfo = info.toArray(info, wecSplitAttr = new String[]{"wec_fileExt", "wec_fileSize", "wec_fileNm"}, wecKeepAttr = new String[]{"bbsSeq", "wec_filePath", "regId"})) != null) {
                    int i = 0;
                    while (i < wecArrInfo.length) {
                        wecArrInfo[i].put("fileExt", wecArrInfo[i].get("wec_fileExt"));
                        wecArrInfo[i].put("fileSize", wecArrInfo[i].get("wec_fileSize"));
                        wecArrInfo[i].put("fileNm", wecArrInfo[i].get("wec_fileNm"));
                        wecArrInfo[i].put("filePath", wecArrInfo[i].get("wec_filePath"));
                        wecArrInfo[i].put("fileTp", "E");
                        resCnt1 += dao.insertBbsFT(wecArrInfo[i]);
                        ++i;
                    }
                }
                BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
                if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y") && info.isExist("prdtCd") && (prdtArrInfo = info.toArray(info, prdtSplitAttr = new String[]{"prdtCd", "status", "notes"}, prdtKeepAttr = new String[]{"siteCd", "bbsCd", "bbsSeq"})) != null) {
                    int i = 0;
                    while (i < prdtArrInfo.length) {
                        if (CmUtil.nullTrim(prdtArrInfo[i].getString("status")).equals("I")) {
                            resCnt1 += dao.insertBbsPT(prdtArrInfo[i]);
                        } else if (!CmUtil.nullTrim(prdtArrInfo[i].getString("status")).equals("U")) {
                            resCnt1 += dao.deleteBbsPT(prdtArrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_LIST_INSERT2", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateBbsList(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                String[] prdtKeepAttr;
                String[] prdtSplitAttr;
                UFORequest[] prdtArrInfo;
                String[] wecKeepAttr;
                String[] wecSplitAttr;
                UFORequest[] wecArrInfo;
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                resCnt = dao.updateBbs(info);
                String[] splitAttr = new String[]{"fileExt", "fileSize", "fileNm"};
                String[] keepAttr = new String[]{"bbsSeq", "filePath", "regId"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (!CmUtil.nullTrim(arrInfo[i].getString("fileNm")).equals("__NULL")) {
                            arrInfo[i].put("fileTp", "A");
                            resCnt1 += dao.insertBbsFT(arrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (info.isEquals("wec_flag", "Y") && (wecArrInfo = info.toArray(info, wecSplitAttr = new String[]{"wec_fileExt", "wec_fileSize", "wec_fileNm"}, wecKeepAttr = new String[]{"bbsSeq", "wec_filePath", "regId"})) != null) {
                    int i = 0;
                    while (i < wecArrInfo.length) {
                        wecArrInfo[i].put("fileExt", wecArrInfo[i].get("wec_fileExt"));
                        wecArrInfo[i].put("fileSize", wecArrInfo[i].get("wec_fileSize"));
                        wecArrInfo[i].put("fileNm", wecArrInfo[i].get("wec_fileNm"));
                        wecArrInfo[i].put("filePath", wecArrInfo[i].get("wec_filePath"));
                        wecArrInfo[i].put("fileTp", "E");
                        resCnt1 += dao.insertBbsFT(wecArrInfo[i]);
                        ++i;
                    }
                }
                BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
                if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y") && info.isExist("prdtCd") && (prdtArrInfo = info.toArray(info, prdtSplitAttr = new String[]{"prdtCd", "status", "notes"}, prdtKeepAttr = new String[]{"siteCd", "bbsCd", "bbsSeq"})) != null) {
                    int i = 0;
                    while (i < prdtArrInfo.length) {
                        if (CmUtil.nullTrim(prdtArrInfo[i].getString("status")).equals("I")) {
                            resCnt1 += dao.insertBbsPT(prdtArrInfo[i]);
                        } else if (!CmUtil.nullTrim(prdtArrInfo[i].getString("status")).equals("U")) {
                            resCnt1 += dao.deleteBbsPT(prdtArrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_LIST_UPADTE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateBbsList2(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                String[] prdtKeepAttr;
                String[] prdtSplitAttr;
                UFORequest[] prdtArrInfo;
                String[] wecKeepAttr;
                String[] wecSplitAttr;
                UFORequest[] wecArrInfo;
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                resCnt = dao.updateBbs(info);
                String[] splitAttr = new String[]{"seq", "fileExt", "fileSize", "fileNm"};
                String[] keepAttr = new String[]{"bbsSeq", "filePath", "regId"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        if (!CmUtil.nullTrim(arrInfo[i].getString("fileNm")).equals("__NULL")) {
                            BbsAttachEntity tmpEntity = dao.selectFTInfo(arrInfo[i]);
                            if (tmpEntity != null) {
                                dao.deleteFileFT(tmpEntity.toRequest());
                                resCnt1 += dao.updateBbsFT(arrInfo[i]);
                            } else {
                                arrInfo[i].put("fileTp", "F");
                                resCnt1 += dao.insertBbsFT(arrInfo[i]);
                            }
                        }
                        ++i;
                    }
                }
                if (info.isEquals("wec_flag", "Y") && (wecArrInfo = info.toArray(info, wecSplitAttr = new String[]{"wec_fileExt", "wec_fileSize", "wec_fileNm"}, wecKeepAttr = new String[]{"bbsSeq", "wec_filePath", "regId"})) != null) {
                    int i = 0;
                    while (i < wecArrInfo.length) {
                        wecArrInfo[i].put("fileExt", wecArrInfo[i].get("wec_fileExt"));
                        wecArrInfo[i].put("fileSize", wecArrInfo[i].get("wec_fileSize"));
                        wecArrInfo[i].put("fileNm", wecArrInfo[i].get("wec_fileNm"));
                        wecArrInfo[i].put("filePath", wecArrInfo[i].get("wec_filePath"));
                        wecArrInfo[i].put("fileTp", "E");
                        resCnt1 += dao.insertBbsFT(wecArrInfo[i]);
                        ++i;
                    }
                }
                BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
                if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y") && info.isExist("prdtCd") && (prdtArrInfo = info.toArray(info, prdtSplitAttr = new String[]{"prdtCd", "status", "notes"}, prdtKeepAttr = new String[]{"siteCd", "bbsCd", "bbsSeq"})) != null) {
                    int i = 0;
                    while (i < prdtArrInfo.length) {
                        if (CmUtil.nullTrim(prdtArrInfo[i].getString("status")).equals("I")) {
                            resCnt1 += dao.insertBbsPT(prdtArrInfo[i]);
                        } else if (!CmUtil.nullTrim(prdtArrInfo[i].getString("status")).equals("U")) {
                            resCnt1 += dao.deleteBbsPT(prdtArrInfo[i]);
                        }
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_LIST_UPADTE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteBbsList(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                resCnt = dao.deleteBbsList(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_LIST_DELETE_ALL", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchBbsComtList(UFORequest info) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                if (info.isPage()) {
                    result.put("LIST", dao.searchDTListPaging(info));
                    result.put("TOTCNT", dao.getDTListCnt(info));
                } else {
                    result.put("LIST", dao.searchDTList(info));
                }
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_COMT_SEARCH", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBbsComtList(UFORequest info) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                result.put("VIEW", dao.selectDTList(info));
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_COMT_SELECT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertComt(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                resCnt = dao.insertBbsDT(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_COMT_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateComt(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                resCnt = dao.updateBbsDT(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_COMT_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteComt(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                resCnt = dao.deleteBbsDT(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_COMT_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteComtFlag(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                String[] splitAttr = new String[]{"seq"};
                String[] keepAttr = new String[]{"bbsSeq"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                if (arrInfo != null) {
                    int i = 0;
                    while (i < arrInfo.length) {
                        arrInfo[i].put("delFl", "Y");
                        resCnt += dao.updateBbsDT(arrInfo[i]);
                        ++i;
                    }
                }
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_COMT_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertFile(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                info.remove("seq");
                resCnt = dao.insertBbsFT(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_COMT_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteFile(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        int resCnt1 = 0;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                resCnt1 = dao.deleteFileFT(info);
                resCnt = dao.deleteBbsFT(info);
                if (resCnt > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_COMT_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult recomBbsList(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        int resCnt1 = 0;
        Boolean chkRes = null;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                chkRes = new Boolean(dao.checkRecmYn(info));
                if (chkRes.booleanValue()) {
                    result.put("FLAG", "false");
                    result.put("MESG", "\ufffd\u0339\ufffd \ufffd\ufffd\u00f5 \ufffd\u03fc\u033d\ufffd\ufffd\u03f4\ufffd.");
                } else {
                    this.startTransaction();
                    resCnt = dao.hitRecomCnt(info);
                    resCnt1 = dao.insertBbsHT(info);
                    if (resCnt > 0 && resCnt1 > 0) {
                        result.put("FLAG", "true");
                        result.put("MESG", "\ufffd\ufffd\u00f5 \ufffd\u01fe\ufffd\ufffd\ufffd\u03f4\ufffd.");
                        this.commit();
                    } else {
                        result.put("FLAG", "false");
                        result.put("MESG", "\ufffd\ufffd\u00f5\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\u03ff\ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
                        this.rollback();
                    }
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]HIT_RECOMMEND_COUNT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchMainList(UFORequest info) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        Vector bbsList = null;
        int bbsListCnt = 0;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ID)) {
                        info.put("cstmId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER) || info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("cstmNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("notes1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("notes2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE3)) {
                        info.put("notes3", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE4)) {
                        info.put("notes4", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                bbsList = dao.searchList(info);
                bbsListCnt = dao.getListCnt(info);
                if (bbsList != null && (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") || CmUtil.nullTrim(bbsInfo.comtFl).equals("Y") || CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y"))) {
                    int i = 0;
                    while (i < bbsList.size()) {
                        Vector vt2;
                        Vector vt1;
                        BbsMainEntity entity = (BbsMainEntity)bbsList.get(i);
                        if (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") && (vt1 = dao.searchFTList(entity.toRequest())) != null) {
                            entity.fileVt = vt1;
                            entity.fileCnt = vt1.size();
                        }
                        if (CmUtil.nullTrim(bbsInfo.comtFl).equals("Y") && (vt2 = dao.searchDTList(entity.toRequest())) != null) {
                            entity.comtVt = vt2;
                            entity.comtCnt = vt2.size();
                        }
                        if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y")) {
                            UFORequest pReq = entity.toRequest();
                            pReq.put("notes", info.getString("notes"));
                            Vector prdtVt = dao.searchPTList(pReq);
                            if (prdtVt != null) {
                                entity.prdtVt = prdtVt;
                                entity.prdtCnt = prdtVt.size();
                            }
                        }
                        ++i;
                    }
                }
                result.put("LIST", bbsList);
                result.put("TOTCNT", bbsListCnt);
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_MAIN_LIST_SEARCH", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchSubList(UFORequest info) throws Exception {
        return this.searchSubList(info, true);
    }

    public UFOResult searchSubList(UFORequest info, boolean isView) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        BbsMainEntity mEntity = null;
        Vector bbsList = null;
        int bbsListCnt = 0;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                dao.hitReadCnt(info);
                mEntity = dao.selectBbsBasic(info);
                if (mEntity != null) {
                    Vector vt1;
                    if (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") && (vt1 = dao.searchFTList(mEntity.toRequest())) != null) {
                        mEntity.fileVt = vt1;
                        mEntity.fileCnt = vt1.size();
                    }
                    if (CmUtil.nullTrim(bbsInfo.comtFl).equals("Y")) {
                        UFORequest cReq = mEntity.toRequest();
                        if (info.isExist("comtPage") && info.isExist("comtSize")) {
                            cReq.put("comtPage", info.getInt("comtPage"));
                            cReq.put("comtSize", info.getInt("comtSize"));
                            mEntity.comtVt = dao.searchDTListPaging(cReq);
                            mEntity.comtCnt = dao.getDTListCnt(cReq);
                        } else {
                            mEntity.comtVt = dao.searchDTList(cReq);
                            mEntity.comtCnt = dao.getDTListCnt(cReq);
                        }
                    }
                    if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y")) {
                        UFORequest pReq = mEntity.toRequest();
                        pReq.put("notes", info.getString("notes"));
                        Vector prdtVt = dao.searchPTList(pReq);
                        if (prdtVt != null) {
                            mEntity.prdtVt = prdtVt;
                            mEntity.prdtCnt = prdtVt.size();
                        }
                    }
                }
                result.put("VIEW", mEntity);
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ID)) {
                        info.put("cstmId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER) || info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("cstmNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("notes1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("notes2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE3)) {
                        info.put("notes3", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE4)) {
                        info.put("notes4", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                bbsList = dao.searchStartReList(info);
                bbsListCnt = dao.getStartReListCnt(info);
                if (bbsList != null && (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") || CmUtil.nullTrim(bbsInfo.comtFl).equals("Y") || CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y"))) {
                    int i = 0;
                    while (i < bbsList.size()) {
                        Vector vt2;
                        Vector vt1;
                        BbsMainEntity entity = (BbsMainEntity)bbsList.get(i);
                        if (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") && (vt1 = dao.searchFTList(entity.toRequest())) != null) {
                            entity.fileVt = vt1;
                            entity.fileCnt = vt1.size();
                        }
                        if (CmUtil.nullTrim(bbsInfo.comtFl).equals("Y") && (vt2 = dao.searchDTList(entity.toRequest())) != null) {
                            entity.comtVt = vt2;
                            entity.comtCnt = vt2.size();
                        }
                        if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y")) {
                            UFORequest pReq = mEntity.toRequest();
                            pReq.put("notes", info.getString("notes"));
                            Vector prdtVt = dao.searchPTList(pReq);
                            if (prdtVt != null) {
                                mEntity.prdtVt = prdtVt;
                                mEntity.prdtCnt = prdtVt.size();
                            }
                        }
                        ++i;
                    }
                }
                result.put("LIST", bbsList);
                result.put("TOTCNT", bbsListCnt);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_SUB_LIST_SEARCH", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectSubList(UFORequest info) throws Exception {
        return this.selectSubList(info, true);
    }

    public UFOResult selectSubList(UFORequest info, boolean isView) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        BbsMainEntity entity = null;
        try {
            try {
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ID)) {
                        info.put("cstmId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER) || info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("cstmNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("notes1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("notes2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE3)) {
                        info.put("notes3", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE4)) {
                        info.put("notes4", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                if (isView) {
                    dao.hitReadCnt(info);
                }
                entity = dao.selectStartReBbs(info);
                info.put("rowNo", entity.rowNo);
                result.put("PREV", dao.selectStartReBbsByRow(info, "P"));
                result.put("NEXT", dao.selectStartReBbsByRow(info, "N"));
                if (entity != null) {
                    Vector vt1;
                    if (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") && (vt1 = dao.searchFTList(entity.toRequest())) != null) {
                        entity.fileVt = vt1;
                        entity.fileCnt = vt1.size();
                    }
                    if (CmUtil.nullTrim(bbsInfo.comtFl).equals("Y")) {
                        UFORequest cReq = entity.toRequest();
                        if (info.isExist("comtPage") && info.isExist("comtSize")) {
                            cReq.put("comtPage", info.getInt("comtPage"));
                            cReq.put("comtSize", info.getInt("comtSize"));
                            entity.comtVt = dao.searchDTListPaging(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        } else {
                            entity.comtVt = dao.searchDTList(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        }
                    }
                    if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y")) {
                        UFORequest pReq = entity.toRequest();
                        pReq.put("notes", info.getString("notes"));
                        Vector prdtVt = dao.searchPTList(pReq);
                        if (prdtVt != null) {
                            entity.prdtVt = prdtVt;
                            entity.prdtCnt = prdtVt.size();
                        }
                    }
                }
                result.put("VIEW", entity);
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_SUB_LIST_SELECT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectSubList2(UFORequest info) throws Exception {
        return this.selectSubList(info, true);
    }

    public UFOResult selectSubList2(UFORequest info, boolean isView) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        BbsMainEntity entity = null;
        try {
            try {
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ID)) {
                        info.put("cstmId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER) || info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("cstmNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("notes1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("notes2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE3)) {
                        info.put("notes3", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE4)) {
                        info.put("notes4", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                if (isView) {
                    dao.hitReadCnt(info);
                }
                entity = dao.selectStartReBbs(info);
                BbsMainEntity analyzeInfo = dao.analyzeStartReBbs(info);
                if (analyzeInfo != null) {
                    UFORequest temp = info.cloneReq("ANALYZE");
                    temp.put("bbsSeq", analyzeInfo.prevSeq);
                    result.put("PREVSEQ", analyzeInfo.prevSeq);
                    result.put("PREV", dao.selectBbsBasic(temp));
                    temp.put("bbsSeq", analyzeInfo.nextSeq);
                    result.put("NEXTSEQ", analyzeInfo.nextSeq);
                    result.put("NEXT", dao.selectBbsBasic(temp));
                }
                if (entity != null) {
                    Vector vt1;
                    if (CmUtil.nullTrim(bbsInfo.attachFl).equals("Y") && (vt1 = dao.searchFTList(entity.toRequest())) != null) {
                        entity.fileVt = vt1;
                        entity.fileCnt = vt1.size();
                    }
                    if (CmUtil.nullTrim(bbsInfo.comtFl).equals("Y")) {
                        UFORequest cReq = entity.toRequest();
                        if (info.isExist("comtPage") && info.isExist("comtSize")) {
                            cReq.put("comtPage", info.getInt("comtPage"));
                            cReq.put("comtSize", info.getInt("comtSize"));
                            entity.comtVt = dao.searchDTListPaging(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        } else {
                            entity.comtVt = dao.searchDTList(cReq);
                            entity.comtCnt = dao.getDTListCnt(cReq);
                        }
                    }
                    if (CmUtil.nullTrim(bbsInfo.prdtFl).equals("Y")) {
                        UFORequest pReq = entity.toRequest();
                        pReq.put("notes", info.getString("notes"));
                        Vector prdtVt = dao.searchPTList(pReq);
                        if (prdtVt != null) {
                            entity.prdtVt = prdtVt;
                            entity.prdtCnt = prdtVt.size();
                        }
                    }
                }
                result.put("VIEW", entity);
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_SUB_LIST_SELECT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectBbsListPrevNext(UFORequest info) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        BbsMainEntity entity = null;
        try {
            try {
                if (info.isExist("keygubn") && info.isExist("keyword")) {
                    if (info.getString("keygubn").equals(UtilConst.FIELD_TITLE)) {
                        info.put("title", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_CONTENTS)) {
                        info.put("contents", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_ID)) {
                        info.put("cstmId", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_WRITER) || info.getString("keygubn").equals(UtilConst.FIELD_NAME)) {
                        info.put("cstmNm", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE1)) {
                        info.put("notes1", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE2)) {
                        info.put("notes2", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE3)) {
                        info.put("notes3", CmUtil.nullTrim(info.getString("keyword")));
                    }
                    if (info.getString("keygubn").equals(UtilConst.FIELD_NOTE4)) {
                        info.put("notes4", CmUtil.nullTrim(info.getString("keyword")));
                    }
                }
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                if (CmUtil.nullTrim(bbsInfo.replyFl).equals("Y")) {
                    entity = dao.selectReBbs(info);
                    info.put("rowNo", entity.rowNo);
                    result.put("PREV", dao.selectReBbsByRow(info, "P"));
                    result.put("NEXT", dao.selectReBbsByRow(info, "N"));
                } else {
                    entity = dao.selectBbs(info);
                    info.put("rowNo", entity.rowNo);
                    result.put("PREV", dao.selectBbsByRow(info, "P"));
                    result.put("NEXT", dao.selectBbsByRow(info, "N"));
                }
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_PREV_NEXT_SELECT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchBbsRecomList(UFORequest info) throws Exception {
        if (!info.isExist("__ufo_bbs_info")) {
            return new UFOResult();
        }
        BbsInfoEntity bbsInfo = (BbsInfoEntity)info.get("__ufo_bbs_info");
        UFOResult result = new UFOResult();
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), bbsInfo);
                result.put("LIST", dao.searchHTList(info));
            }
            catch (Exception ex) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_RECOM_SEARCH", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteRecom(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        if (!info.isExist("__ufo_bbs_info")) {
            result.put("FLAG", "false");
            result.put("MESG", "\ufffd\u053d\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u03f4\ufffd.");
            return result;
        }
        int resCnt = 0;
        boolean resCnt1 = false;
        try {
            try {
                UFOBbsMgmtDAO dao = new UFOBbsMgmtDAO(this.getConnection(this), (BbsInfoEntity)info.get("__ufo_bbs_info"));
                this.startTransaction();
                resCnt = dao.deleteBbsHT(info);
                if (resCnt > 0) {
                    dao.deltRecomCnt(info);
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]BBS_RECOM_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

