/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.admin;

import com.ufo.admin.UFOAuthMgmtDAO;
import com.ufo.admin.UFOMenuMgmtDAO;
import com.ufo.admin.entity.MenuInfoEntity;
import com.ufo.admin.entity.PrgmInfoEntity;
import com.ufo.base.UFOSiteInfoDAO;
import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import java.util.Vector;

public class UFOMenuMgmtWB
extends UFOBaseWB {
    public UFOMenuMgmtWB() {
    }

    public UFOMenuMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchTopMenu(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchTopMenuList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]TOP_MENU_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchLeftMenu(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                Vector menuVt;
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                if (!info.isExist("uppMenuCd")) {
                    info.put("uppMenuCd", "__UPPMENUCD__");
                }
                if ((menuVt = dao.searchLeftMenuList(info)) != null) {
                    String[] arrAttr = new String[]{"menuCd"};
                    int i = 0;
                    while (i < menuVt.size()) {
                        MenuInfoEntity temp = (MenuInfoEntity)menuVt.get(i);
                        UFORequest tmpInfo = temp.toRequest(arrAttr);
                        tmpInfo.put("siteCd", info.getString("siteCd"));
                        tmpInfo.put("authCd", info.getString("authCd"));
                        temp.prgmVt = dao.searchLeftPrgmList(tmpInfo);
                        ++i;
                    }
                }
                result.put("LIST", menuVt);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]LEFT_MENU_PROGRAM_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchMenuList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchMenuList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MENU_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectMenuInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectMenu(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MENU_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertMenuInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                this.startTransaction();
                result1 = dao.insertMenu(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MENU_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateMenuInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                this.startTransaction();
                result1 = dao.updateMenu(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MENU_UPDATE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteMenuInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        int result2 = 0;
        int result3 = 0;
        int result4 = 0;
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                UFOSiteInfoDAO siteDao = new UFOSiteInfoDAO(this.getConnection(this));
                UFOAuthMgmtDAO authDao = new UFOAuthMgmtDAO(this.getConnection(this));
                this.startTransaction();
                UFORequest temp = new UFORequest(info.getRequest());
                temp.put("_base", info.getString("menuCd"));
                Vector subMenuVt = dao.searchMenuList(temp);
                if (subMenuVt != null) {
                    int i = 0;
                    while (i < subMenuVt.size()) {
                        MenuInfoEntity mEntity = (MenuInfoEntity)subMenuVt.get(i);
                        String[] mArrAttr = new String[]{"menuCd"};
                        UFORequest temp1 = mEntity.toRequest(info.getRequest(), mArrAttr);
                        Vector prgmVt = dao.searchPrgmList(temp1);
                        if (prgmVt != null) {
                            int j = 0;
                            while (j < prgmVt.size()) {
                                PrgmInfoEntity pEntity = (PrgmInfoEntity)prgmVt.get(j);
                                String[] pArrAttr = new String[]{"prgmCd"};
                                UFORequest temp2 = pEntity.toRequest(info.getRequest(), pArrAttr);
                                result4 = authDao.deletePrgmAuth(temp2);
                                result3 = siteDao.deleteSitePrgm(temp2);
                                result2 = dao.deletePrgm(temp2);
                                ++j;
                            }
                        }
                        result1 += dao.deleteMenu(temp1);
                        ++i;
                    }
                }
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]MENU_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchPrgmList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchPrgmList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]PROGRAM_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectPrgmInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectPrgm(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]PROGRAM_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertPrgmInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                this.startTransaction();
                result1 = dao.insertPrgm(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]PROGRAM_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updatePrgmInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                this.startTransaction();
                result1 = dao.updatePrgm(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]PROGRAM_UPDATE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deletePrgmInfo(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        int result2 = 0;
        int result3 = 0;
        try {
            try {
                UFOMenuMgmtDAO dao = new UFOMenuMgmtDAO(this.getConnection(this));
                UFOSiteInfoDAO siteDao = new UFOSiteInfoDAO(this.getConnection(this));
                UFOAuthMgmtDAO authDao = new UFOAuthMgmtDAO(this.getConnection(this));
                this.startTransaction();
                result3 = authDao.deletePrgmAuth(info);
                result2 = siteDao.deleteSitePrgm(info);
                result1 = dao.deletePrgm(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]PROGRAM_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

