/*
 * Decompiled with CFR 0.152.
 */
package com.ufo.admin;

import com.ufo.admin.UFOAuthMgmtDAO;
import com.ufo.admin.entity.AuthPrgmEntity;
import com.ufo.common.UFOException;
import com.ufo.common.UFORequest;
import com.ufo.common.UFOResult;
import com.ufo.common.base.UFOBaseWB;
import com.ufo.common.utility.CmUtil;

public class UFOAuthMgmtWB
extends UFOBaseWB {
    public UFOAuthMgmtWB() {
    }

    public UFOAuthMgmtWB(String siteCd) {
        super(siteCd);
    }

    public UFOResult searchAuthSite(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchAuthSiteList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]AUTH_SITE_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchAuthList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchAuthList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]AUTH_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult selectAuthInfo(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                result.put("VIEW", dao.selectAuth(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]AUTH_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult insertAuth(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                String authCd = dao.getNewCd();
                info.put("authCd", authCd);
                this.startTransaction();
                result1 = dao.insertAuth(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]AUTH_INSERT", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult updateAuth(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                this.startTransaction();
                result1 = dao.updateAuth(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]AUTH_UPDATE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deleteAuth(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        int result2 = 0;
        int result3 = 0;
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                this.startTransaction();
                result2 = dao.deleteAdminAuth(info);
                result3 = dao.deletePrgmAuth(info);
                result1 = dao.deleteAuth(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]AUTH_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult searchPrgmAuthList(UFORequest info) throws UFOException {
        UFOResult result = new UFOResult();
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                result.put("LIST", dao.searchPrgmAuthList(info));
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]PROGRAM_AUTH_SEARCH", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult modifyPrgmAuth(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                this.startTransaction();
                String[] splitAttr = new String[]{"prgmCd", "inqAuth", "regAuth", "modAuth", "delAuth", "useFl", "status"};
                String[] keepAttr = new String[]{"siteCd", "authCd", "regIp"};
                UFORequest[] arrInfo = info.toArray(info, splitAttr, keepAttr);
                int i = 0;
                while (i < arrInfo.length) {
                    if (CmUtil.nullTrim(arrInfo[i].getString("status")).equals("I")) {
                        if (arrInfo[i].getBoolean("useFl")) {
                            result1 += dao.insertPrgmAuth(arrInfo[i]);
                        }
                    } else {
                        result1 = arrInfo[i].getBoolean("useFl") ? (result1 += dao.updatePrgmAuth(arrInfo[i])) : (result1 += dao.deletePrgmAuth(arrInfo[i]));
                    }
                    ++i;
                }
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]PROGRAM_AUTH_MODIFY", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public UFOResult deletePrgmSite(UFORequest info) throws Exception {
        UFOResult result = new UFOResult();
        int result1 = 0;
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                this.startTransaction();
                result1 = dao.deletePrgmAuth(info);
                if (result1 > 0) {
                    result.put("FLAG", "true");
                    result.put("MESG", " ");
                    this.commit();
                } else {
                    result.put("FLAG", "false");
                    result.put("MESG", "FAIL");
                    this.rollback();
                }
            }
            catch (Exception ex) {
                this.rollback();
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]PROGRAM_AUTH_DELETE", ex);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }

    public AuthPrgmEntity selectPrgmAuth(UFORequest info) throws UFOException {
        AuthPrgmEntity result = new AuthPrgmEntity();
        try {
            try {
                UFOAuthMgmtDAO dao = new UFOAuthMgmtDAO(this.getConnection(this));
                result = dao.selectPrgmAuth(info);
            }
            catch (Exception etcEx) {
                throw new UFOException(this.getClass().getName(), "SQL-0100", "[WB]AUTH_SELECT", etcEx);
            }
        }
        finally {
            this.closeConnection();
        }
        return result;
    }
}

