/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.extras.module;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.reflect.ClassUtil;
import org.apache.tiles.servlet.wildcard.WildcardServletTilesApplicationContext;
import org.apache.tiles.startup.TilesInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModularTilesInitializer
implements TilesInitializer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private List<TilesInitializer> initializers;

    public void initialize(TilesApplicationContext preliminaryContext) {
        WildcardServletTilesApplicationContext applicationContext = new WildcardServletTilesApplicationContext((ServletContext)preliminaryContext.getContext());
        this.loadInitializers((TilesApplicationContext)applicationContext);
        for (TilesInitializer initializer : this.initializers) {
            initializer.initialize(preliminaryContext);
        }
    }

    public void destroy() {
        for (TilesInitializer initializer : this.initializers) {
            initializer.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitializers(TilesApplicationContext applicationContext) {
        this.initializers = new ArrayList<TilesInitializer>();
        try {
            Set urls = applicationContext.getResources("classpath*:META-INF/MANIFEST.MF");
            try {
                URL mainUrl = applicationContext.getResource("/META-INF/MANIFEST.MF");
                if (mainUrl != null) {
                    urls.add(mainUrl);
                }
            }
            catch (FileNotFoundException e) {
                this.logger.debug("Cannot find main manifest, ignoring the problem", (Throwable)e);
            }
            for (URL url : urls) {
                InputStream stream = url.openStream();
                try {
                    String initializerName;
                    Manifest manifest = new Manifest(stream);
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes == null || (initializerName = attributes.getValue("Tiles-Initializer")) == null) continue;
                    TilesInitializer initializer = (TilesInitializer)ClassUtil.instantiate((String)initializerName);
                    this.initializers.add(initializer);
                }
                finally {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new DefinitionsFactoryException("Error getting manifest files", (Exception)e);
        }
    }
}

