/*
 * Decompiled with CFR 0.152.
 */
package com.solbitech.common.util;

import ai.org.apache.commons.codec.binary.Base64;
import com.solbitech.common.sys.CommControl;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertImage
extends CommControl {
    private String type = "";
    private List<String> fileList;
    private Map<String, String> convertCd;
    private Map<String, String> mapParam;
    private Map<String, Object> convertImageMap;
    private Logger logger;

    public ConvertImage(PageContext pageContext) {
        this.commPageContext = pageContext;
        this.initLogger("ConvertImage");
    }

    public ConvertImage(HttpServletRequest commHttpRequest, PageContext pageContext) {
        this.commHttpRequest = commHttpRequest;
        this.commPageContext = pageContext;
        this.initLogger("ConvertImage");
    }

    public ConvertImage(HttpServletRequest commHttpRequest, HttpServletResponse commHttpResponse, PageContext pageContext) {
        this.commHttpRequest = commHttpRequest;
        this.commHttpResponse = commHttpResponse;
        this.commPageContext = pageContext;
        this.initLogger("ConvertImage");
    }

    public void setImageData(String imageInput) {
        BufferedImage buffImage = null;
        this.convertImageMap = null;
        try {
            this.convertImageMap = new HashMap<String, Object>();
            if (imageInput.indexOf("http://") != -1) {
                URL imageUrl = new URL(imageInput);
                URLConnection urlConnection = imageUrl.openConnection();
                HttpURLConnection connCode = (HttpURLConnection)urlConnection;
                if (connCode.getResponseCode() != 200) {
                    this.convertImageMap.put("code", "");
                    return;
                }
                buffImage = ImageIO.read(imageUrl);
            } else {
                File imageFile = new File(imageInput);
                if (!imageFile.exists()) {
                    this.convertImageMap.put("code", "");
                    return;
                }
                buffImage = ImageIO.read(imageFile);
            }
            this.convertImageMap.put("code", "200");
            this.convertImageMap.put("path", imageInput);
            this.convertImageMap.put("type", buffImage.getType());
            this.convertImageMap.put("width", buffImage.getWidth());
            this.convertImageMap.put("height", buffImage.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] initCreateConvert() throws IOException {
        Base64 decoder = null;
        String imageDataBytes = "";
        byte[] imageBinaryData = null;
        try {
            this.logger = commLog;
            decoder = new Base64();
            String imgdata = this.getB(this.commHttpRequest.getParameter("baseImg"));
            imageDataBytes = imgdata.substring(imgdata.indexOf(",") + 1);
            imageBinaryData = decoder.decode(imageDataBytes);
        }
        catch (Exception e) {
            this.debugLog(this.logger, "#initCreateConvert ===> " + e);
        }
        return imageBinaryData;
    }

    private void initCreateConvert(JspWriter out) throws IOException {
        try {
            this.logger = commLog;
            String savepath = this.getSavepath();
            if (this.initParameters()) {
                JSONObject chartTree = new JSONObject();
                this.fileList = new ArrayList<String>();
                for (String keyNm : this.mapParam.keySet()) {
                    chartTree.put((Object)keyNm, (Object)this.createService(this.mapParam.get(keyNm), savepath));
                }
                if (chartTree.size() > 0) {
                    chartTree.put((Object)"create", (Object)"ok");
                }
                if (out != null) {
                    out.println(chartTree.toJSONString());
                }
            }
        }
        catch (Exception e) {
            this.debugLog(this.logger, "#initCreateConvert ===> " + e);
        }
    }

    private final String getSavepath() {
        if (commProperties != null) {
            String savePath = this.getB(commProperties.getProperty("tempPath"));
            if (savePath.equals("")) {
                savePath = this.getB(commProperties.getProperty("pdfPath"));
            }
            return savePath;
        }
        return "";
    }

    private final void setCode() {
        this.convertCd = new HashMap<String, String>();
        this.convertCd.put("HC", "highChart");
        this.convertCd.put("SG", "signature");
    }

    private final boolean initParameters() {
        this.mapParam = new HashMap<String, String>();
        Enumeration param = this.commHttpRequest.getParameterNames();
        while (param.hasMoreElements()) {
            String paramKey = (String)param.nextElement();
            if (paramKey.indexOf("chart_") != -1) {
                this.type = "highcharts";
                this.mapParam.put(paramKey, this.getB(this.commHttpRequest.getParameter(paramKey)));
                continue;
            }
            if (paramKey.indexOf("sign_") == -1) continue;
            this.type = "signature";
            this.mapParam.put(paramKey, this.getB(this.commHttpRequest.getParameter(paramKey)));
        }
        return this.mapParam.size() > 0;
    }

    private String createService(String imgdata, String savepath) {
        Base64 decoder = null;
        String rndCnt = "";
        String imageDataBytes = "";
        StringBuffer imagePath = null;
        FileOutputStream fileOutStream = null;
        try {
            if (savepath.equals("")) {
                return "";
            }
            try {
                imagePath = new StringBuffer();
                imagePath.append(savepath);
                String fileKey = String.valueOf(this.getCommDT("YYMMDDHHmmss")) + (int)(Math.random() * 100.0);
                if (this.type.equals("highcharts")) {
                    rndCnt = "HC";
                    imagePath.append("highChart-");
                } else if (this.type.equals("signature")) {
                    rndCnt = "SG";
                    imagePath.append("signature-");
                }
                rndCnt = String.valueOf(rndCnt) + fileKey;
                imagePath.append(fileKey).append(".png");
                this.fileList.add(imagePath.toString());
                decoder = new Base64();
                imageDataBytes = imgdata.substring(imgdata.indexOf(",") + 1);
                byte[] imageBinaryData = decoder.decode(imageDataBytes);
                this.debugLog(this.logger, "#imageChartPath : " + imagePath);
                if (imageBinaryData != null) {
                    fileOutStream = new FileOutputStream(new File(imagePath.toString()));
                    fileOutStream.write(imageBinaryData);
                    fileOutStream.flush();
                }
            }
            catch (IOException e) {
                this.debugLog(this.logger, "#createService ===> " + e);
            }
        }
        finally {
            try {
                if (fileOutStream != null) {
                    fileOutStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return rndCnt;
    }

    private void initLoadOutput(JspWriter out) throws IOException {
        BufferedInputStream buffInpStream = null;
        FilterOutputStream outStream = null;
        String imageChartPath = "";
        try {
            try {
                String code;
                this.setCode();
                out.clear();
                out = this.commPageContext.pushBody();
                String savepath = this.getSavepath();
                String keycode = this.getB(this.commHttpRequest.getParameter("keyCode"));
                String string = code = keycode.length() > 10 ? keycode.substring(0, 2) : "";
                if (this.convertCd.get(code) != null) {
                    imageChartPath = String.valueOf(savepath) + this.getB(this.convertCd.get(code)) + "-" + keycode.subSequence(2, keycode.length()) + ".png";
                }
                this.debugLog(this.logger, "#imageChartPath : " + imageChartPath);
                outStream = new BufferedOutputStream((OutputStream)this.commHttpResponse.getOutputStream());
                buffInpStream = new BufferedInputStream(new FileInputStream(imageChartPath));
                byte[] b = new byte[1024];
                int read = 0;
                while ((read = buffInpStream.read(b)) != -1) {
                    ((BufferedOutputStream)outStream).write(b, 0, read);
                }
            }
            catch (Exception e) {
                this.debugLog(this.logger, "#initLoadOutput ===> " + e);
                try {
                    if (outStream != null) {
                        outStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (buffInpStream != null) {
                        buffInpStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (buffInpStream != null) {
                    buffInpStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void initLoadOutputHttps(JspWriter out) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        BufferedInputStream buffInpStream = null;
        try {
            try {
                String httpsUrl;
                this.logger = commLog;
                out.clear();
                out = this.commPageContext.pushBody();
                String protocol = this.getB(commProperties.get("protocolLevel"));
                if (!protocol.equals("")) {
                    this.getCommHTTPS(protocol);
                }
                if (!(httpsUrl = this.getB(this.commHttpRequest.getParameter("imgURL"))).equals("")) {
                    int readA;
                    StringBuffer imagePath = new StringBuffer();
                    imagePath.append(this.getSavepath());
                    imagePath.append("httpsimg-");
                    imagePath.append(String.valueOf(this.getCommDT("YYMMDDHHmmss")) + (int)(Math.random() * 100.0));
                    if (httpsUrl.indexOf(".jpg") != -1) {
                        imagePath.append(".jpg");
                    } else if (httpsUrl.indexOf(".png") != -1) {
                        imagePath.append(".png");
                    } else {
                        imagePath.append(".gif");
                    }
                    inputStream = new URL(httpsUrl).openStream();
                    outputStream = new FileOutputStream(imagePath.toString());
                    byte[] byteA = new byte[2048];
                    while ((readA = inputStream.read(byteA)) != -1) {
                        outputStream.write(byteA, 0, readA);
                    }
                    outputStream = new BufferedOutputStream((OutputStream)this.commHttpResponse.getOutputStream());
                    buffInpStream = new BufferedInputStream(new FileInputStream(imagePath.toString()));
                    while ((readA = buffInpStream.read(byteA)) != -1) {
                        outputStream.write(byteA, 0, readA);
                    }
                }
            }
            catch (Exception e) {
                this.debugLog(this.logger, "#initLoadOutputHttps ===> " + e);
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (buffInpStream != null) {
                        buffInpStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (buffInpStream != null) {
                    buffInpStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void getImageSize(int maxWidth, int maxHeight) {
        if (this.convertImageMap == null) {
            return;
        }
        if (this.convertImageMap.get("width") == null || this.convertImageMap.get("height") == null) {
            this.convertImageMap.put("rewidth", maxWidth);
            this.convertImageMap.put("reheight", maxHeight);
            return;
        }
        int imgWidth = Integer.parseInt(this.get0(this.convertImageMap.get("width")));
        int imgHeight = Integer.parseInt(this.get0(this.convertImageMap.get("height")));
        double ratio = 0.0;
        if (imgWidth > maxWidth) {
            ratio = (double)maxWidth / (double)imgWidth;
            imgWidth = maxWidth;
            imgHeight = (int)((double)imgHeight * ratio);
        }
        if (imgHeight > maxHeight) {
            ratio = (double)maxHeight / (double)imgHeight;
            imgHeight = maxHeight;
            imgWidth = (int)((double)imgWidth * ratio);
        }
        this.convertImageMap.put("rewidth", imgWidth);
        this.convertImageMap.put("reheight", imgHeight);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String initCreateBlob() {
        if (this.convertImageMap == null) {
            return "";
        }
        if (this.convertImageMap.get("path") == null) {
            return "";
        }
        String pathUrl = this.getB(this.convertImageMap.get("path"));
        String imgStream = "";
        if (pathUrl.indexOf("http://") != -1) {
            URLConnection urlConnection = null;
            BufferedInputStream bufferedInputStream = null;
            ByteArrayOutputStream byteOutStream = null;
            try {
                try {
                    urlConnection = new URL(pathUrl).openConnection();
                    bufferedInputStream = new BufferedInputStream(urlConnection.getInputStream());
                    byteOutStream = new ByteArrayOutputStream();
                    int len = 0;
                    byte[] buf = new byte[1024];
                    while ((len = bufferedInputStream.read(buf)) != -1) {
                        byteOutStream.write(buf, 0, len);
                    }
                    byte[] fileArray = byteOutStream.toByteArray();
                    imgStream = new String(Base64.encodeBase64((byte[])fileArray));
                    this.debugLog(this.logger, "#initCreateBlob : " + imgStream);
                    return imgStream;
                }
                catch (Exception len) {
                    if (byteOutStream != null) {
                        try {
                            byteOutStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (bufferedInputStream == null) return imgStream;
                    try {
                        bufferedInputStream.close();
                        return imgStream;
                    }
                    catch (IOException iOException) {}
                }
                return imgStream;
            }
            finally {
                if (byteOutStream != null) {
                    try {
                        byteOutStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        FileInputStream fileStream = null;
        ByteArrayOutputStream byteOutStream = null;
        try {
            try {
                fileStream = new FileInputStream((File)this.convertImageMap.get("path"));
                byteOutStream = new ByteArrayOutputStream();
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = fileStream.read(buf)) != -1) {
                    byteOutStream.write(buf, 0, len);
                }
                byte[] fileArray = byteOutStream.toByteArray();
                imgStream = new String(Base64.encodeBase64((byte[])fileArray));
                this.debugLog(this.logger, "#initCreateBlob : " + imgStream);
                return imgStream;
            }
            catch (Exception exception) {
                if (byteOutStream != null) {
                    try {
                        byteOutStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (fileStream == null) return imgStream;
                try {
                    fileStream.close();
                    return imgStream;
                }
                catch (IOException iOException) {}
            }
            return imgStream;
        }
        finally {
            if (byteOutStream != null) {
                try {
                    byteOutStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String initCreateBlob(String path) {
        String imgStream = "";
        FileInputStream fileStream = null;
        ByteArrayOutputStream byteOutStream = null;
        try {
            try {
                this.logger = commLog;
                fileStream = new FileInputStream(new File(path));
                byteOutStream = new ByteArrayOutputStream();
                int len = 0;
                byte[] buf = new byte[1024];
                while ((len = fileStream.read(buf)) != -1) {
                    byteOutStream.write(buf, 0, len);
                }
                byte[] fileArray = byteOutStream.toByteArray();
                imgStream = new String(Base64.encodeBase64((byte[])fileArray));
                this.debugLog(this.logger, "#initCreateBlob : " + imgStream);
            }
            catch (Exception e) {
                this.debugLog(this.logger, "#initCreateBlob ===> " + e);
                try {
                    if (byteOutStream != null) {
                        byteOutStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (fileStream != null) {
                        fileStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (byteOutStream != null) {
                    byteOutStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileStream != null) {
                    fileStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return imgStream;
    }

    private String initCreateBlob(String path, int defWidth, int defHeight) {
        String imgStream = "";
        BufferedImage buffImage = null;
        BufferedImage outBuffImage = null;
        ByteArrayOutputStream byteOutStream = null;
        try {
            int imgWidth = 0;
            int imgHeight = 0;
            File imgPath = new File(path);
            if (!imgPath.exists()) {
                return "";
            }
            try {
                buffImage = ImageIO.read(imgPath);
                String imgName = imgPath.getName();
                String extension = "";
                if (imgName.indexOf(".") != -1) {
                    String[] img = imgName.split("\\.");
                    extension = img[img.length - 1];
                }
                if ((imgWidth = buffImage.getWidth()) > (imgHeight = buffImage.getHeight())) {
                    if (imgWidth > defWidth) {
                        double resize = 0.0;
                        resize = (double)defWidth / (double)imgWidth;
                        imgWidth = defWidth;
                        imgHeight = (int)((double)imgHeight * resize);
                    }
                } else if (imgHeight > defHeight) {
                    double resize = 0.0;
                    resize = (double)defHeight / (double)imgHeight;
                    imgHeight = defHeight;
                    imgWidth = (int)((double)imgWidth * resize);
                }
                outBuffImage = new BufferedImage(imgWidth, imgHeight, 1);
                Graphics2D graphics2d = outBuffImage.createGraphics();
                graphics2d.drawImage(buffImage.getScaledInstance(imgWidth, imgHeight, 4), 0, 0, imgWidth, imgHeight, null);
                graphics2d.dispose();
                byteOutStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)outBuffImage, extension, byteOutStream);
                byte[] fileArray = byteOutStream.toByteArray();
                imgStream = new String(Base64.encodeBase64((byte[])fileArray));
                this.debugLog(this.logger, "#initCreateBlob : " + imgStream);
            }
            catch (Exception e) {
                this.debugLog(this.logger, "#initCreateBlob ===> " + e);
            }
        }
        finally {
            try {
                if (byteOutStream != null) {
                    byteOutStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return imgStream;
    }

    public final List<String> getImagePath() throws IOException {
        this.initCreateConvert(null);
        return this.fileList;
    }

    public final String getImage(String path) throws IOException {
        return this.initCreateBlob(path);
    }

    public final String getImage(String path, int width, int height) throws IOException {
        return this.initCreateBlob(path, width, height);
    }

    public final void getLoadimage(JspWriter out) throws IOException {
        this.initLoadOutput(out);
    }

    public final void getLoadhttpsimage(JspWriter out) throws IOException {
        this.initLoadOutputHttps(out);
    }

    public final void getConvertCode(JspWriter out) throws IOException {
        this.initCreateConvert(out);
    }

    public final byte[] getConvertCode() throws IOException {
        return this.initCreateConvert();
    }

    public Object getImageInfo(String name) {
        return this.convertImageMap.get(name);
    }

    public String getImageBlob() {
        return this.initCreateBlob();
    }
}

