/*
 * Decompiled with CFR 0.152.
 */
package com.solbitech.common.uds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommUdsBuffParser
extends DefaultHandler {
    private String buffRootNode;
    private String buffListNode;
    private String buffTopNode = "";
    private String buffEndNode = "";
    private String buffDataValue = "";
    private boolean mainflag = false;
    Map<String, String> buffNodeInfo;
    private StringBuffer mainDataSet = new StringBuffer();
    private StringBuffer subDataSet = new StringBuffer();
    private List<Object> dataSetList = new ArrayList<Object>();
    private static Map<String, String> specialCode;

    public void setWebbuffer(Map<String, String> nodeInfo) {
        this.buffRootNode = nodeInfo.get("rootNode");
        this.buffListNode = nodeInfo.get("listNode");
        this.buffTopNode = nodeInfo.get("topNode");
        CommUdsBuffParser.setSpecialCode();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.buffRootNode.equals("JSONDATA")) {
            return;
        }
        if (this.buffRootNode.equals("none")) {
            this.mainDataSet.append("<").append(qName).append(">");
        } else if (!this.mainflag) {
            if (qName.equals(this.buffRootNode)) {
                this.mainflag = true;
            } else {
                this.mainDataSet.append("<").append(qName).append(">");
            }
        } else {
            this.subDataSet.append("<").append(qName).append(">");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.buffRootNode.equals("JSONDATA")) {
            return;
        }
        if (this.buffRootNode.equals("none")) {
            if (!this.buffDataValue.trim().equals("")) {
                this.mainDataSet.append("<![CDATA[").append(this.getDataFilter(this.buffDataValue)).append("]]>");
            }
            this.buffDataValue = "";
            this.mainDataSet.append("</").append(qName).append(">");
        } else if (this.mainflag) {
            if (qName.equals(this.buffListNode)) {
                this.subDataSet.append("</").append(qName).append(">");
                this.dataSetList.add(this.subDataSet.toString());
                this.subDataSet.setLength(0);
            } else if (qName.equals(this.buffRootNode)) {
                this.mainflag = false;
            } else {
                if (!this.buffDataValue.trim().equals("")) {
                    this.subDataSet.append("<![CDATA[").append(this.getDataFilter(this.buffDataValue)).append("]]>");
                }
                this.subDataSet.append("</").append(qName).append(">");
                this.buffDataValue = "";
            }
        } else {
            if (!this.buffDataValue.trim().equals("")) {
                this.mainDataSet.append("<![CDATA[").append(this.getDataFilter(this.buffDataValue)).append("]]>");
            }
            this.mainDataSet.append("</").append(qName).append(">");
            this.buffDataValue = "";
        }
        this.buffEndNode = qName;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        if (!value.trim().equals("")) {
            this.buffDataValue = String.valueOf(this.buffDataValue) + value.trim();
        }
    }

    private static void setSpecialCode() {
        specialCode = new HashMap<String, String>();
        String[] special_no1 = new String[]{"!", "\"", "#", "\\$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/"};
        String[] special_no2 = new String[]{":", ";", "<", "=", ">", "?", "@"};
        String[] special_no3 = new String[]{"[", "\\\\", "]", "^", "_", "'"};
        String[] special_no4 = new String[]{"{", "\\|", "}", "~"};
        CommUdsBuffParser.setDataAppend(special_no1, 33);
        CommUdsBuffParser.setDataAppend(special_no2, 58);
        CommUdsBuffParser.setDataAppend(special_no3, 91);
        CommUdsBuffParser.setDataAppend(special_no4, 123);
    }

    private static void setDataAppend(String[] specialData, int code) {
        String[] stringArray = specialData;
        int n = specialData.length;
        int n2 = 0;
        while (n2 < n) {
            String codeData = stringArray[n2];
            specialCode.put("&#" + code + ";", codeData);
            ++code;
            ++n2;
        }
    }

    private String getDataFilter(String data) {
        for (String key : specialCode.keySet()) {
            if (data.indexOf(key) == -1) continue;
            data = data.replaceAll(key, specialCode.get(key));
        }
        data = data.replaceAll("&nbsp;", " ");
        data = data.replaceAll("&amp;", "&");
        data = data.replaceAll("&quot;", "\"");
        data = data.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
        data = data.replaceAll("<br>", "\r\n").replaceAll("<BR>", "\r\n").replaceAll("<br/>", "\r\n").replaceAll("<BR/>", "\r\n").replaceAll("<br />", "\r\n");
        return data;
    }

    public String udsBuffStr() {
        return this.mainDataSet.toString();
    }

    public List<String> udsBuffArray() {
        ArrayList<String> dataSetArray = null;
        String[] nodeOption = this.buffTopNode.toUpperCase().split("\\|");
        String mainTree = this.mainDataSet.toString().replaceAll("</" + this.buffEndNode + ">", "");
        StringBuffer finalTree = null;
        if (this.dataSetList.size() > 0) {
            dataSetArray = new ArrayList<String>();
            for (Object treedata : this.dataSetList) {
                finalTree = new StringBuffer();
                if (nodeOption[1].equals("Y")) {
                    treedata = "<" + this.buffRootNode + ">" + treedata.toString() + "</" + this.buffRootNode + ">";
                }
                if (nodeOption[0].equals("Y")) {
                    finalTree.append(mainTree).append(treedata.toString()).append("</").append(this.buffEndNode).append(">");
                } else {
                    finalTree.append(treedata.toString());
                }
                dataSetArray.add(finalTree.toString());
            }
            if (finalTree != null) {
                finalTree.setLength(0);
            }
            if (this.buffNodeInfo != null) {
                this.buffNodeInfo.clear();
            }
        }
        return dataSetArray;
    }
}

