/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.Collections;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.UnknownNameException;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.TypeNames;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

public final class Names
extends Static {
    private Names() {
    }

    private static NameSpace createNameSpace(CharSequence charSequence, String string) {
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return DefaultFactories.NAMES.createNameSpace((GenericName)DefaultFactories.NAMES.createLocalName(null, charSequence), string == null ? null : Collections.singletonMap("separator.head", string));
    }

    public static GenericName parseGenericName(CharSequence charSequence, String string, CharSequence charSequence2) {
        ArgumentChecks.ensureNonNull("localPart", charSequence2);
        ArgumentChecks.ensureNonNull("separator", string);
        return DefaultFactories.NAMES.parseGenericName(Names.createNameSpace(charSequence, string), charSequence2);
    }

    public static LocalName createLocalName(CharSequence charSequence, String string, CharSequence charSequence2) {
        ArgumentChecks.ensureNonNull("localPart", charSequence2);
        ArgumentChecks.ensureNonNull("separator", string);
        return DefaultFactories.NAMES.createLocalName(Names.createNameSpace(charSequence, string), charSequence2);
    }

    public static TypeName createTypeName(CharSequence charSequence, String string, CharSequence charSequence2) {
        ArgumentChecks.ensureNonNull("localPart", charSequence2);
        ArgumentChecks.ensureNonNull("separator", string);
        return DefaultFactories.NAMES.createTypeName(Names.createNameSpace(charSequence, string), charSequence2);
    }

    public static MemberName createMemberName(CharSequence charSequence, String string, CharSequence charSequence2, Class<?> clazz) {
        ArgumentChecks.ensureNonNull("localPart", charSequence2);
        ArgumentChecks.ensureNonNull("separator", string);
        ArgumentChecks.ensureNonNull("valueClass", clazz);
        return DefaultFactories.NAMES.createMemberName(Names.createNameSpace(charSequence, string), charSequence2, DefaultFactories.SIS_NAMES.toTypeName(clazz));
    }

    public static Class<?> toClass(TypeName typeName) throws UnknownNameException {
        Class<?> clazz;
        if (typeName == null) {
            return null;
        }
        if (typeName instanceof DefaultTypeName) {
            clazz = ((DefaultTypeName)typeName).toClass();
        } else {
            try {
                clazz = TypeNames.toClass(TypeNames.namespace(typeName.scope()), typeName.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnknownNameException(TypeNames.unknown((GenericName)typeName), classNotFoundException);
            }
            if (clazz == null) {
                throw new UnknownNameException(TypeNames.unknown((GenericName)typeName));
            }
            if (clazz == Void.TYPE) {
                clazz = null;
            }
        }
        return clazz;
    }

    public static String toExpandedString(GenericName genericName) {
        if (genericName == null) {
            return null;
        }
        String string = genericName.toString();
        NameSpace nameSpace = genericName.scope();
        if (nameSpace == null || nameSpace.isGlobal()) {
            return string;
        }
        String string2 = nameSpace.name().toString();
        return new StringBuilder(string2.length() + string.length() + 2).append('{').append(string2).append('}').append(string).toString();
    }
}

