/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.gco.CharSequenceAdapter;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.AbstractName;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.GlobalNameSpace;
import org.apache.sis.util.iso.SimpleInternationalString;
import org.apache.sis.util.iso.Types;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

@XmlSeeAlso(value={DefaultTypeName.class, DefaultMemberName.class})
public class DefaultLocalName
extends AbstractName
implements LocalName {
    private static final long serialVersionUID = -697839568997068872L;
    final NameSpace scope;
    @XmlJavaTypeAdapter(value=CharSequenceAdapter.class)
    @XmlElement(name="aName", namespace="http://www.isotc211.org/2005/gco")
    final CharSequence name;

    DefaultLocalName() {
        this.scope = null;
        this.name = null;
    }

    protected DefaultLocalName(NameSpace nameSpace, CharSequence charSequence) {
        ArgumentChecks.ensureNonNull("name", charSequence);
        if (nameSpace == GlobalNameSpace.GLOBAL) {
            nameSpace = null;
        }
        this.scope = nameSpace;
        if (charSequence instanceof InternationalString) {
            if (charSequence.getClass() == SimpleInternationalString.class) {
                this.asString = charSequence;
            } else {
                this.name = charSequence;
                return;
            }
        }
        this.name = charSequence.toString();
    }

    public static DefaultLocalName castOrCopy(LocalName localName) {
        if (localName instanceof MemberName) {
            return DefaultMemberName.castOrCopy((MemberName)localName);
        }
        if (localName instanceof TypeName) {
            return DefaultTypeName.castOrCopy((TypeName)localName);
        }
        if (localName == null || localName instanceof DefaultLocalName) {
            return (DefaultLocalName)localName;
        }
        NameSpace nameSpace = localName.scope();
        InternationalString internationalString = localName.toInternationalString();
        if (nameSpace instanceof DefaultNameSpace) {
            return ((DefaultNameSpace)nameSpace).local((CharSequence)internationalString, null);
        }
        return new DefaultLocalName(nameSpace, (CharSequence)internationalString);
    }

    @Override
    public NameSpace scope() {
        return this.scope != null ? this.scope : GlobalNameSpace.GLOBAL;
    }

    @Override
    public final int depth() {
        return 1;
    }

    public final List<DefaultLocalName> getParsedNames() {
        return Collections.singletonList(this);
    }

    @Override
    public final LocalName head() {
        return this;
    }

    @Override
    public final LocalName tip() {
        return this;
    }

    @Override
    public synchronized String toString() {
        if (this.asString == null) {
            this.asString = this.name instanceof InternationalString ? ((InternationalString)this.name).toString(Locale.ROOT) : this.name.toString();
        } else if (this.asString instanceof InternationalString) {
            return ((InternationalString)this.asString).toString(Locale.ROOT);
        }
        return this.asString.toString();
    }

    @Override
    public synchronized InternationalString toInternationalString() {
        if (!(this.asString instanceof InternationalString)) {
            this.asString = Types.toInternationalString(this.name);
        }
        return (InternationalString)this.asString;
    }

    @Override
    public int compareTo(GenericName genericName) {
        if (genericName instanceof LocalName) {
            return this.toString().compareTo(genericName.toString());
        }
        return super.compareTo(genericName);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultLocalName defaultLocalName = (DefaultLocalName)object;
            return Objects.equals(this.scope, defaultLocalName.scope) && Objects.equals(this.name, defaultLocalName.name);
        }
        return false;
    }

    @Override
    int computeHashCode() {
        return Objects.hash(this.scope, this.name) ^ 0xFBB7CFB8;
    }

    private Object readResolve() {
        DefaultNameSpace defaultNameSpace;
        if (this.scope == null) {
            defaultNameSpace = GlobalNameSpace.GLOBAL;
        } else if (this.scope instanceof DefaultNameSpace) {
            defaultNameSpace = (DefaultNameSpace)this.scope;
        } else {
            return this;
        }
        return defaultNameSpace.local(this.name, this);
    }
}

