/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class StringBuilders
extends Static {
    private static final String ASCII = "AAAAAA\u00c6CEEEEIIIIDNOOOOO*OUUUUY\u00desaaaaaa\u00e6ceeeeiiiionooooo/ouuuuy\u00fey";

    private StringBuilders() {
    }

    public static void replace(StringBuilder stringBuilder, char c, char c2) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        if (c != c2) {
            int n = stringBuilder.length();
            while (--n >= 0) {
                if (stringBuilder.charAt(n) != c) continue;
                stringBuilder.setCharAt(n, c2);
            }
        }
    }

    public static void replace(StringBuilder stringBuilder, String string, String string2) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        ArgumentChecks.ensureNonEmpty("toSearch", string);
        ArgumentChecks.ensureNonNull("replaceBy", string2);
        if (!string.equals(string2)) {
            int n = string.length();
            int n2 = stringBuilder.length();
            while ((n2 = stringBuilder.lastIndexOf(string, n2)) >= 0) {
                stringBuilder.replace(n2, n2 + n, string2);
                n2 -= n;
            }
        }
    }

    public static void replace(StringBuilder stringBuilder, int n, int n2, char[] cArray) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        ArgumentChecks.ensureNonNull("chars", cArray);
        int n3 = n2 - n;
        if (n < 0 || n3 < 0) {
            throw new StringIndexOutOfBoundsException(Errors.format((short)41, n, n2));
        }
        int n4 = cArray.length - n3;
        if (n4 < 0) {
            stringBuilder.delete(n2 + n4, n2);
            n3 = cArray.length;
        }
        for (int i = 0; i < n3; ++i) {
            stringBuilder.setCharAt(n++, cArray[i]);
        }
        if (n4 > 0) {
            stringBuilder.insert(n, cArray, n3, n4);
        }
    }

    public static void remove(StringBuilder stringBuilder, String string) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        ArgumentChecks.ensureNonEmpty("toSearch", string);
        int n = string.length();
        int n2 = stringBuilder.lastIndexOf(string);
        while (n2 >= 0) {
            stringBuilder.delete(n2, n2 + n);
            n2 = stringBuilder.lastIndexOf(string, n2);
        }
    }

    public static void trimFractionalPart(StringBuilder stringBuilder) {
        int n;
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        block4: for (int i = stringBuilder.length(); i > 0; i -= Character.charCount(n)) {
            n = stringBuilder.codePointBefore(i);
            switch (n) {
                case 48: {
                    continue block4;
                }
                case 46: {
                    stringBuilder.setLength(i);
                }
            }
            return;
        }
    }

    public static void toASCII(StringBuilder stringBuilder) {
        ArgumentChecks.ensureNonNull("buffer", stringBuilder);
        StringBuilders.toASCII(stringBuilder, stringBuilder);
    }

    static CharSequence toASCII(CharSequence charSequence, StringBuilder stringBuilder) {
        if (charSequence != null) {
            int n = charSequence.length();
            block4: while (n > 0) {
                char c;
                int n2 = Character.codePointBefore(charSequence, n);
                int n3 = Character.charCount(n2);
                int n4 = n2 - 192;
                n -= n3;
                if (n4 < 0) continue;
                if (n4 < ASCII.length()) {
                    c = ASCII.charAt(n4);
                } else {
                    switch (Character.getType(n2)) {
                        case 12: {
                            c = ' ';
                            break;
                        }
                        case 13: 
                        case 14: {
                            c = '\n';
                            break;
                        }
                        default: {
                            continue block4;
                        }
                    }
                }
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(charSequence.length()).append(charSequence);
                    charSequence = stringBuilder;
                }
                if (n3 == 2) {
                    stringBuilder.deleteCharAt(n + 1);
                }
                stringBuilder.setCharAt(n, c);
            }
        }
        return charSequence;
    }
}

