/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import java.util.Iterator;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class CompoundDirectPositions
implements DirectPosition,
Iterable<DirectPosition>,
Iterator<DirectPosition> {
    private final double[][] ordinates;
    private final int last;
    private int index;

    CompoundDirectPositions(double[] ... dArray) {
        this.ordinates = dArray;
        int n = dArray[0].length;
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i].length == n) continue;
            throw new IllegalArgumentException(Errors.format((short)56));
        }
        this.last = n - 1;
    }

    @Override
    public Iterator<DirectPosition> iterator() {
        this.index = -1;
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.last;
    }

    @Override
    public DirectPosition next() {
        ++this.index;
        return this;
    }

    public DirectPosition getDirectPosition() {
        return this;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return null;
    }

    public int getDimension() {
        return this.ordinates.length;
    }

    public double getOrdinate(int n) {
        return this.ordinates[n][this.index];
    }

    public double[] getCoordinate() {
        throw new UnsupportedOperationException();
    }

    public void setOrdinate(int n, double d) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

