/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

final class IdentifiedObjectFormat
extends Format {
    private static final long serialVersionUID = -832517434580782189L;
    private final Locale locale;

    IdentifiedObjectFormat(Locale locale) {
        this.locale = locale;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        ReferenceIdentifier referenceIdentifier = ((IdentifiedObject)object).getName();
        if (referenceIdentifier == null) {
            return stringBuffer.append(Vocabulary.getResources(this.locale).getString((short)65));
        }
        if (referenceIdentifier instanceof GenericName) {
            return stringBuffer.append(((GenericName)referenceIdentifier).toInternationalString().toString(this.locale));
        }
        String string = referenceIdentifier.getCode();
        String string2 = referenceIdentifier.getCodeSpace();
        if (string2 == null || string2.isEmpty()) {
            string2 = Citations.getIdentifier(referenceIdentifier.getAuthority());
        }
        if (string2 != null) {
            stringBuffer.append(string2).append(':');
        }
        return stringBuffer.append(string);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }
}

