/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.sis.internal.system.DaemonThread;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;

final class Threads
extends Static {
    static final ThreadGroup SIS;
    static final ThreadGroup DAEMONS;
    static DaemonThread lastCreatedDaemon;
    private static final ExecutorService executor;

    private Threads() {
    }

    static synchronized void shutdown(long l) throws InterruptedException {
        if (executor != null) {
            executor.shutdown();
            long l2 = l - System.nanoTime();
            if (l2 > 0L) {
                executor.awaitTermination(l2, TimeUnit.NANOSECONDS);
            }
        }
        DaemonThread.killAll(lastCreatedDaemon, l);
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        try {
            ThreadGroup threadGroup2;
            while ((threadGroup2 = threadGroup.getParent()) != null) {
                threadGroup = threadGroup2;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        SIS = new ThreadGroup(threadGroup, "Apache SIS");
        DAEMONS = new ThreadGroup(SIS, "Daemons"){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                Logging.severeException(Logging.getLogger("org.apache.sis"), thread.getClass(), "run", throwable);
            }
        };
        executor = null;
    }
}

