/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.lang.management.ManagementFactory;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.sis.internal.system.DaemonThread;
import org.apache.sis.internal.system.SupervisorMBean;
import org.apache.sis.internal.system.Threads;
import org.apache.sis.setup.About;
import org.apache.sis.util.Localized;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;

public final class Supervisor
extends StandardMBean
implements SupervisorMBean,
Localized {
    static final boolean ENABLED = false;
    public static final String NAME = "org.apache.sis:type=Supervisor";
    private static ObjectName name;
    private final Locale locale;
    private final TimeZone timezone;

    static synchronized void register() {
        if (name == null) {
            name = ObjectName.WILDCARD;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName objectName = new ObjectName(NAME);
                mBeanServer.registerMBean(new Supervisor(null, null), objectName);
                name = objectName;
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                LogRecord logRecord = Messages.getResources(null).getLogRecord(Level.CONFIG, (short)0, "MBean", NAME);
                logRecord.setLoggerName("org.apache.sis");
                Logging.log(Supervisor.class, "register", logRecord);
            }
            catch (Exception exception) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis"), Supervisor.class, "register", exception);
            }
        }
    }

    static synchronized void unregister() throws JMException {
        ObjectName objectName = name;
        if (objectName != null) {
            name = null;
            if (objectName != ObjectName.WILDCARD) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(objectName);
            }
        }
    }

    public Supervisor(Locale locale, TimeZone timeZone) throws NotCompliantMBeanException {
        super(SupervisorMBean.class);
        this.locale = locale;
        this.timezone = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    protected int getImpact(MBeanOperationInfo mBeanOperationInfo) {
        return 0;
    }

    @Override
    protected String getDescription(MBeanInfo mBeanInfo) {
        return this.getDescription("supervisor");
    }

    @Override
    protected String getDescription(MBeanFeatureInfo mBeanFeatureInfo) {
        return this.getDescription(mBeanFeatureInfo.getName());
    }

    @Override
    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return this.getDescription(this.getParameterName(mBeanConstructorInfo, mBeanParameterInfo, n));
    }

    @Override
    protected String getParameterName(MBeanConstructorInfo mBeanConstructorInfo, MBeanParameterInfo mBeanParameterInfo, int n) {
        return "locale";
    }

    private String getDescription(String string) {
        return ResourceBundle.getBundle("org.apache.sis.internal.system.Descriptions", this.locale != null ? this.locale : Locale.getDefault(), Supervisor.class.getClassLoader()).getString(string);
    }

    @Override
    public TreeTable configuration() {
        return About.configuration(EnumSet.allOf(About.class), this.locale, this.timezone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] warnings() {
        Object object = Threads.class;
        synchronized (Threads.class) {
            DaemonThread daemonThread = Threads.lastCreatedDaemon;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            object = DaemonThread.listStalledThreads(daemonThread);
            if (object == null) {
                return null;
            }
            String[] stringArray = new String[object.size()];
            Errors errors = Errors.getResources(this.locale);
            for (int i = 0; i < stringArray.length; ++i) {
                Thread thread = (Thread)object.get(i);
                stringArray[i] = errors.getString(thread.isAlive() ? (short)102 : 15, thread.getName());
            }
            return stringArray;
        }
    }
}

