/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.opengis.util.NameFactory;

public final class DefaultFactories
extends SystemListener {
    public static final DefaultNameFactory SIS_NAMES;
    public static final DefaultNameFactory NAMES;
    private static final Map<Class<?>, Object> FACTORIES;

    private DefaultFactories() {
        super("org.apache.sis.utility");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void classpathChanged() {
        Class<DefaultFactories> clazz = DefaultFactories.class;
        synchronized (DefaultFactories.class) {
            FACTORIES.clear();
            FACTORIES.put(NameFactory.class, NAMES);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized <T> T forClass(Class<T> clazz) {
        T t = clazz.cast(FACTORIES.get(clazz));
        if (t == null && !FACTORIES.containsKey(clazz)) {
            for (T t2 : ServiceLoader.load(clazz)) {
                Class<?> clazz2 = t2.getClass();
                if (clazz2.getName().startsWith("org.apache.sis.")) {
                    t = t2;
                    break;
                }
                if (t != null && !t.getClass().isAssignableFrom(clazz2)) continue;
                t = t2;
            }
            FACTORIES.put(clazz, t);
        }
        return t;
    }

    static {
        NAMES = SIS_NAMES = new DefaultNameFactory();
        FACTORIES = new IdentityHashMap(4);
        FACTORIES.put(NameFactory.class, NAMES);
        SystemListener.add(new DefaultFactories());
    }
}

