/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jdk8;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.DatatypeConverter;
import org.apache.sis.internal.jdk8.BiFunction;

public final class JDK8 {
    private static final AtomicReference<Calendar> CALENDAR = new AtomicReference();

    private JDK8() {
    }

    public static double nextDown(double d) {
        return Math.nextAfter(d, Double.NEGATIVE_INFINITY);
    }

    public static <K, V> V compute(ConcurrentMap<K, V> concurrentMap, K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        V v;
        boolean bl;
        do {
            Object v2;
            if ((v = biFunction.apply(k, v2 = concurrentMap.get(k))) != null) {
                if (v2 != null) {
                    bl = concurrentMap.replace(k, v2, v);
                    continue;
                }
                bl = concurrentMap.putIfAbsent(k, v) == null;
                continue;
            }
            if (v2 != null) {
                bl = concurrentMap.remove(k, v2);
                continue;
            }
            return null;
        } while (!bl);
        return v;
    }

    public static Date parseDateTime(String string) throws IllegalArgumentException {
        return DatatypeConverter.parseDateTime((String)string).getTime();
    }

    public static String printDateTime(Date date) {
        Calendar calendar = CALENDAR.getAndSet(null);
        if (calendar == null) {
            calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
        }
        calendar.setTime(date);
        String string = DatatypeConverter.printDateTime((Calendar)calendar);
        CALENDAR.set(calendar);
        return string;
    }
}

