/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;

class ObjectToString<S>
extends SystemConverter<S, String> {
    private static final long serialVersionUID = 502567744195102675L;
    private final SystemConverter<String, S> inverse;

    ObjectToString(Class<S> clazz, SystemConverter<String, S> systemConverter) {
        super(clazz, String.class);
        this.inverse = systemConverter;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.INVERTIBLE);
    }

    @Override
    public String apply(S s) {
        return s != null ? s.toString() : null;
    }

    @Override
    public final ObjectConverter<String, S> inverse() {
        return this.inverse != null ? this.inverse : super.inverse();
    }

    @Override
    public final ObjectConverter<S, String> unique() {
        if (this.inverse != null) {
            return this.inverse.unique().inverse();
        }
        return this;
    }

    static final class Enum<S extends java.lang.Enum<S>>
    extends ObjectToString<S> {
        private static final long serialVersionUID = 5391817175838307542L;

        Enum(Class<S> clazz, SystemConverter<String, S> systemConverter) {
            super(clazz, systemConverter);
        }

        @Override
        public Set<FunctionProperty> properties() {
            return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE, FunctionProperty.INVERTIBLE);
        }

        @Override
        public String apply(S s) {
            return s != null ? ((java.lang.Enum)s).name() : null;
        }
    }

    static final class CodeList<S extends org.opengis.util.CodeList<S>>
    extends ObjectToString<S> {
        private static final long serialVersionUID = 1454105232343463228L;

        CodeList(Class<S> clazz, SystemConverter<String, S> systemConverter) {
            super(clazz, systemConverter);
        }

        @Override
        public Set<FunctionProperty> properties() {
            return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE, FunctionProperty.INVERTIBLE);
        }

        @Override
        public String apply(S s) {
            return s != null ? s.name() : null;
        }
    }
}

