/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.ExtendedPrecisionMatrix;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.Matrix3;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NonSquareMatrix;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.Matrix;

public final class Matrices
extends Static {
    private static final int SPACING = 2;

    private Matrices() {
    }

    public static MatrixSIS createIdentity(int n) {
        switch (n) {
            case 1: {
                return new Matrix1();
            }
            case 2: {
                return new Matrix2();
            }
            case 3: {
                return new Matrix3();
            }
            case 4: {
                return new Matrix4();
            }
        }
        return new GeneralMatrix(n, n, true, 1);
    }

    public static MatrixSIS createDiagonal(int n, int n2) {
        if (n == n2) {
            return Matrices.createIdentity(n);
        }
        return new NonSquareMatrix(n, n2, true, 1);
    }

    public static MatrixSIS createZero(int n, int n2) {
        if (n == n2) {
            switch (n) {
                case 1: {
                    return new Matrix1(false);
                }
                case 2: {
                    return new Matrix2(false);
                }
                case 3: {
                    return new Matrix3(false);
                }
                case 4: {
                    return new Matrix4(false);
                }
            }
            return new GeneralMatrix(n, n2, false, 1);
        }
        return new NonSquareMatrix(n, n2, false, 1);
    }

    public static MatrixSIS create(int n, int n2, double[] dArray) {
        if (n == n2) {
            switch (n) {
                case 1: {
                    return new Matrix1(dArray);
                }
                case 2: {
                    return new Matrix2(dArray);
                }
                case 3: {
                    return new Matrix3(dArray);
                }
                case 4: {
                    return new Matrix4(dArray);
                }
            }
            return new GeneralMatrix(n, n2, dArray);
        }
        return new NonSquareMatrix(n, n2, dArray);
    }

    public static MatrixSIS create(int n, int n2, Number[] numberArray) {
        ArgumentChecks.ensureNonNull((String)"elements", (Object)numberArray);
        GeneralMatrix generalMatrix = GeneralMatrix.createExtendedPrecision(n, n2);
        if (generalMatrix.setElements(numberArray)) {
            return generalMatrix;
        }
        return Matrices.create(n, n2, generalMatrix.getElements());
    }

    private static MatrixSIS createTransform(Envelope envelope, AxisDirection[] axisDirectionArray, Envelope envelope2, AxisDirection[] axisDirectionArray2, boolean bl) {
        DirectPosition directPosition;
        DirectPosition directPosition2;
        DirectPosition directPosition3;
        if (bl) {
            directPosition3 = envelope2.getLowerCorner();
            directPosition2 = envelope.getLowerCorner();
            directPosition = envelope.getUpperCorner();
        } else {
            directPosition = null;
            directPosition2 = null;
            directPosition3 = null;
        }
        MatrixSIS matrixSIS = Matrices.createZero(axisDirectionArray2.length + 1, axisDirectionArray.length + 1);
        for (int i = 0; i < axisDirectionArray2.length; ++i) {
            boolean bl2 = false;
            AxisDirection axisDirection = axisDirectionArray2[i];
            AxisDirection axisDirection2 = AxisDirections.absolute(axisDirection);
            for (int j = 0; j < axisDirectionArray.length; ++j) {
                AxisDirection axisDirection3 = axisDirectionArray[j];
                if (!axisDirection2.equals((Object)AxisDirections.absolute(axisDirection3))) continue;
                if (bl2) {
                    throw new IllegalArgumentException(Errors.format((short)14, (Object)axisDirection3, (Object)axisDirection));
                }
                bl2 = true;
                boolean bl3 = axisDirection3.equals((Object)axisDirection);
                double d = bl3 ? 1.0 : -1.0;
                double d2 = 0.0;
                if (bl) {
                    d2 = directPosition3.getOrdinate(i);
                    d2 -= (d *= envelope2.getSpan(i) / envelope.getSpan(j)) * (bl3 ? directPosition2 : directPosition).getOrdinate(j);
                }
                matrixSIS.setElement(i, j, d);
                matrixSIS.setElement(i, axisDirectionArray.length, d2);
            }
            if (bl2) continue;
            throw new IllegalArgumentException(Errors.format((short)6, (Object)"srcAxes", (Object)axisDirectionArray2[i]));
        }
        matrixSIS.setElement(axisDirectionArray2.length, axisDirectionArray.length, 1.0);
        return matrixSIS;
    }

    public static MatrixSIS createTransform(Envelope envelope, Envelope envelope2) {
        ArgumentChecks.ensureNonNull((String)"srcEnvelope", (Object)envelope);
        ArgumentChecks.ensureNonNull((String)"dstEnvelope", (Object)envelope2);
        int n = envelope.getDimension();
        int n2 = envelope2.getDimension();
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope2.getLowerCorner();
        MatrixSIS matrixSIS = Matrices.createZero(n2 + 1, n + 1);
        int n3 = Math.min(n, n2);
        while (--n3 >= 0) {
            double d = envelope2.getSpan(n3) / envelope.getSpan(n3);
            double d2 = directPosition2.getOrdinate(n3) - directPosition.getOrdinate(n3) * d;
            matrixSIS.setElement(n3, n3, d);
            matrixSIS.setElement(n3, n, d2);
        }
        matrixSIS.setElement(n2, n, 1.0);
        return matrixSIS;
    }

    public static MatrixSIS createTransform(AxisDirection[] axisDirectionArray, AxisDirection[] axisDirectionArray2) {
        ArgumentChecks.ensureNonNull((String)"srcAxes", (Object)axisDirectionArray);
        ArgumentChecks.ensureNonNull((String)"dstAxes", (Object)axisDirectionArray2);
        return Matrices.createTransform(null, axisDirectionArray, null, axisDirectionArray2, false);
    }

    public static MatrixSIS createTransform(Envelope envelope, AxisDirection[] axisDirectionArray, Envelope envelope2, AxisDirection[] axisDirectionArray2) {
        ArgumentChecks.ensureNonNull((String)"srcEnvelope", (Object)envelope);
        ArgumentChecks.ensureNonNull((String)"dstEnvelope", (Object)envelope2);
        Matrices.ensureDimensionMatch("srcEnvelope", envelope, axisDirectionArray.length);
        Matrices.ensureDimensionMatch("dstEnvelope", envelope2, axisDirectionArray2.length);
        return Matrices.createTransform(envelope, axisDirectionArray, envelope2, axisDirectionArray2, true);
    }

    private static void ensureDimensionMatch(String string, Envelope envelope, int n) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)string, (Object)envelope);
        int n2 = envelope.getDimension();
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((short)59, (Object)string, (Object)n, (Object)n2));
        }
    }

    public static MatrixSIS createDimensionSelect(int n, int[] nArray) {
        int n2 = nArray.length;
        MatrixSIS matrixSIS = Matrices.createZero(n2 + 1, n + 1);
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            ArgumentChecks.ensureValidIndex((int)n, (int)n3);
            matrixSIS.setElement(i, n3, 1.0);
        }
        matrixSIS.setElement(n2, n, 1.0);
        return matrixSIS;
    }

    public static MatrixSIS createPassThrough(int n, Matrix matrix, int n2) {
        int n3;
        int n4;
        int n5;
        ArgumentChecks.ensurePositive((String)"firstAffectedOrdinate", (int)n);
        ArgumentChecks.ensurePositive((String)"numTrailingOrdinates", (int)n2);
        int n6 = n + n2;
        int n7 = matrix.getNumCol();
        int n8 = matrix.getNumRow();
        MatrixSIS matrixSIS = Matrices.createZero(n8-- + n6, n7-- + n6);
        for (n5 = 0; n5 < n; ++n5) {
            matrixSIS.setElement(n5, n5, 1.0);
        }
        n5 = n7 + n6;
        for (n4 = 0; n4 < n8; ++n4) {
            for (n3 = 0; n3 < n7; ++n3) {
                matrixSIS.setElement(n + n4, n + n3, matrix.getElement(n4, n3));
            }
            matrixSIS.setElement(n + n4, n5, matrix.getElement(n4, n7));
        }
        n4 = n8 - n7;
        for (n3 = n5 - n2; n3 < n5; ++n3) {
            matrixSIS.setElement(n4 + n3, n3, 1.0);
        }
        n3 = n8 + n6;
        for (int i = 0; i < n7; ++i) {
            matrixSIS.setElement(n3, i + n, matrix.getElement(n8, i));
        }
        matrixSIS.setElement(n3, n5, matrix.getElement(n8, n7));
        return matrixSIS;
    }

    public static MatrixSIS copy(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        int n = matrix.getNumRow();
        if (n != matrix.getNumCol()) {
            return new NonSquareMatrix(matrix);
        }
        if (!(matrix instanceof ExtendedPrecisionMatrix)) {
            switch (n) {
                case 1: {
                    return new Matrix1(matrix);
                }
                case 2: {
                    return new Matrix2(matrix);
                }
                case 3: {
                    return new Matrix3(matrix);
                }
                case 4: {
                    return new Matrix4(matrix);
                }
            }
        }
        return new GeneralMatrix(matrix);
    }

    public static boolean isAffine(Matrix matrix) {
        if (matrix instanceof MatrixSIS) {
            return ((MatrixSIS)matrix).isAffine();
        }
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        if (n2 != n--) {
            return false;
        }
        double d = 1.0;
        while (--n2 >= 0) {
            if (matrix.getElement(n, n2) != d) {
                return false;
            }
            d = 0.0;
        }
        return true;
    }

    public static boolean isIdentity(Matrix matrix, double d) {
        int n;
        int n2 = matrix.getNumRow();
        if (n2 != (n = matrix.getNumCol())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d2 = matrix.getElement(i, j);
                if (j == i) {
                    d2 -= 1.0;
                }
                if (Math.abs(d2) <= d) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean equals(Matrix matrix, Matrix matrix2, double d, boolean bl) {
        if (matrix != matrix2) {
            if (matrix == null || matrix2 == null) {
                return false;
            }
            int n = matrix.getNumRow();
            if (n != matrix2.getNumRow()) {
                return false;
            }
            int n2 = matrix.getNumCol();
            if (n2 != matrix2.getNumCol()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double d2 = matrix.getElement(i, j);
                    double d3 = matrix2.getElement(i, j);
                    double d4 = d;
                    if (bl) {
                        d4 *= Math.max(Math.abs(d2), Math.abs(d3));
                    }
                    if (Math.abs(d2 - d3) <= d4 || Numerics.equals((double)d2, (double)d3)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean equals(Matrix matrix, Matrix matrix2, ComparisonMode comparisonMode) {
        switch (comparisonMode) {
            case STRICT: {
                return Objects.equals((Object)matrix, (Object)matrix2);
            }
            case BY_CONTRACT: 
            case IGNORE_METADATA: {
                return Matrices.equals(matrix, matrix2, 0.0, false);
            }
            case DEBUG: 
            case APPROXIMATIVE: {
                return Matrices.equals(matrix, matrix2, 1.0E-14, true);
            }
        }
        throw new IllegalArgumentException(Errors.format((short)114, ComparisonMode.class, (Object)comparisonMode));
    }

    public static String toString(Matrix matrix) {
        int n;
        int n2;
        int n3;
        int n4 = matrix.getNumRow();
        int n5 = matrix.getNumCol();
        String[] stringArray = new String[n5 * n4];
        boolean[] blArray = new boolean[n5 * n4];
        boolean[] blArray2 = new boolean[n5];
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5 * n4];
        byte[] byArray3 = new byte[n5];
        byte[] byArray4 = new byte[n5];
        int n6 = 1;
        int n7 = 1;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n8;
                int n9 = j * n5 + i;
                double d = matrix.getElement(j, i);
                String string = Double.toString(d);
                if (d == -1.0 || d == 0.0 || d == 1.0) {
                    blArray[n9] = true;
                    n8 = n7 + string.length() - 2;
                    byArray3[i] = (byte)Math.max(byArray3[i], n8);
                } else {
                    n3 = string.lastIndexOf(46);
                    if (n3 < 0) {
                        string = CharSequences.replace((CharSequence)string, (CharSequence)"Infinity", (CharSequence)"\u221e").toString();
                        n8 = n7 + string.length();
                        byArray3[i] = (byte)Math.max(byArray3[i], n8);
                    } else {
                        blArray2[i] = true;
                        n2 = string.length() - ++n3;
                        byArray3[i] = (byte)Math.max(byArray3[i], n7 + n3);
                        byArray[i] = (byte)Math.max(byArray[i], n2);
                        n8 = byArray3[i] + byArray[i];
                        if (string.indexOf(69) < 0) {
                            n = (int)Math.ceil(-Math.log10(Math.ulp(d)));
                            byArray2[n9] = (byte)(n - n2);
                        }
                    }
                }
                byArray4[i] = (byte)Math.max(byArray4[i], n8);
                stringArray[n9] = string;
            }
            n6 += byArray4[i];
            n7 = 2;
        }
        String string = JDK7.lineSeparator();
        CharSequence charSequence = CharSequences.spaces((int)n6);
        StringBuilder stringBuilder = new StringBuilder((n6 + 2 + string.length()) * (n4 + 2));
        stringBuilder.append('\u250c').append(charSequence).append('\u2510').append(string);
        int n10 = 0;
        for (int i = 0; i < n4; ++i) {
            stringBuilder.append('\u2502');
            for (int j = 0; j < n5; ++j) {
                String string2 = stringArray[n10];
                n3 = string2.length();
                n = string2.lastIndexOf(46);
                if (n >= 0) {
                    if (blArray2[j]) {
                        ++n;
                    }
                    n2 = byArray3[j] - n;
                } else {
                    n2 = byArray4[j] - n3;
                }
                stringBuilder.append(CharSequences.spaces((int)n2)).append(string2);
                if (n >= 0) {
                    n += byArray[j] - n3;
                    if (blArray[n10]) {
                        stringBuilder.setLength(stringBuilder.length() - 2);
                        n += 2;
                    } else {
                        int n11 = Math.min(n, byArray2[n10]);
                        n -= n11;
                        while (--n11 >= 0) {
                            stringBuilder.append('0');
                        }
                    }
                    stringBuilder.append(CharSequences.spaces((int)n));
                }
                ++n10;
            }
            stringBuilder.append(" \u2502").append(string);
        }
        return stringBuilder.append('\u2514').append(charSequence).append('\u2518').append(string).toString();
    }
}

