/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.referencing.OperationMethods;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.DefaultFormula;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.Formula;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;

public class DefaultOperationMethod
extends AbstractIdentifiedObject
implements OperationMethod {
    private static final long serialVersionUID = -8181774670648793964L;
    private final Formula formula;
    private final Integer sourceDimension;
    private final Integer targetDimension;
    private final ParameterDescriptorGroup parameters;

    public DefaultOperationMethod(Map<String, ?> map, Integer n, Integer n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(map);
        if (n != null) {
            ArgumentChecks.ensurePositive((String)"sourceDimension", (int)n);
        }
        if (n2 != null) {
            ArgumentChecks.ensurePositive((String)"targetDimension", (int)n2);
        }
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameterDescriptorGroup);
        Object obj = map.get("formula");
        if (obj == null || obj instanceof Formula) {
            this.formula = (Formula)obj;
        } else if (obj instanceof Citation) {
            this.formula = new DefaultFormula((Citation)obj);
        } else if (obj instanceof CharSequence) {
            this.formula = new DefaultFormula((CharSequence)obj);
        } else {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)40, (Object)"formula", obj.getClass()));
        }
        this.parameters = parameterDescriptorGroup;
        this.sourceDimension = n;
        this.targetDimension = n2;
    }

    public DefaultOperationMethod(MathTransform mathTransform) {
        super(DefaultOperationMethod.getProperties(mathTransform));
        this.sourceDimension = mathTransform.getSourceDimensions();
        this.targetDimension = mathTransform.getTargetDimensions();
        this.parameters = mathTransform instanceof Parameterized ? ((Parameterized)mathTransform).getParameterDescriptors() : null;
        this.formula = null;
    }

    private static Map<String, ?> getProperties(MathTransform mathTransform) {
        ParameterDescriptorGroup parameterDescriptorGroup;
        ArgumentChecks.ensureNonNull((String)"transform", (Object)mathTransform);
        if (mathTransform instanceof Parameterized && (parameterDescriptorGroup = ((Parameterized)mathTransform).getParameterDescriptors()) != null) {
            return DefaultOperationMethod.getProperties((IdentifiedObject)parameterDescriptorGroup, null);
        }
        return Collections.singletonMap("name", Vocabulary.format((short)65));
    }

    static Map<String, Object> getProperties(IdentifiedObject identifiedObject, Citation citation) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(IdentifiedObjects.getProperties(identifiedObject, new String[0]));
        hashMap.put("name", (Object)new NamedIdentifier(citation, identifiedObject.getName().getCode()));
        hashMap.remove("identifiers");
        return hashMap;
    }

    protected DefaultOperationMethod(OperationMethod operationMethod) {
        super((IdentifiedObject)operationMethod);
        this.formula = operationMethod.getFormula();
        this.parameters = operationMethod.getParameters();
        this.sourceDimension = operationMethod.getSourceDimensions();
        this.targetDimension = operationMethod.getTargetDimensions();
    }

    public static DefaultOperationMethod castOrCopy(OperationMethod operationMethod) {
        return operationMethod == null || operationMethod instanceof DefaultOperationMethod ? (DefaultOperationMethod)operationMethod : new DefaultOperationMethod(operationMethod);
    }

    private DefaultOperationMethod(OperationMethod operationMethod, Integer n, Integer n2) {
        super((IdentifiedObject)operationMethod);
        this.formula = operationMethod.getFormula();
        this.parameters = operationMethod.getParameters();
        this.sourceDimension = n;
        this.targetDimension = n2;
    }

    public static OperationMethod redimension(OperationMethod operationMethod, Integer n, Integer n2) {
        if (n != null) {
            ArgumentChecks.ensurePositive((String)"sourceDimension", (int)n);
        }
        if (n2 != null) {
            ArgumentChecks.ensurePositive((String)"targetDimension", (int)n2);
        }
        if (!(operationMethod == null || Objects.equals((Object)n, (Object)operationMethod.getSourceDimensions()) && Objects.equals((Object)n2, (Object)operationMethod.getTargetDimensions()))) {
            operationMethod = new DefaultOperationMethod(operationMethod, n, n2);
        }
        return operationMethod;
    }

    public Class<? extends OperationMethod> getInterface() {
        return OperationMethod.class;
    }

    public Class<? extends CoordinateOperation> getOperationType() {
        return CoordinateOperation.class;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public Integer getSourceDimensions() {
        return this.sourceDimension;
    }

    public Integer getTargetDimensions() {
        return this.targetDimension;
    }

    public ParameterDescriptorGroup getParameters() {
        return this.parameters;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            OperationMethod operationMethod;
            switch (comparisonMode) {
                case STRICT: {
                    DefaultOperationMethod defaultOperationMethod = (DefaultOperationMethod)object;
                    return Objects.equals((Object)this.formula, (Object)defaultOperationMethod.formula) && Objects.equals((Object)this.sourceDimension, (Object)defaultOperationMethod.sourceDimension) && Objects.equals((Object)this.targetDimension, (Object)defaultOperationMethod.targetDimension) && Objects.equals((Object)this.parameters, (Object)defaultOperationMethod.parameters);
                }
                case BY_CONTRACT: {
                    if (Objects.equals((Object)this.getFormula(), (Object)((OperationMethod)object).getFormula())) break;
                    return false;
                }
                default: {
                    operationMethod = (OperationMethod)object;
                    Boolean bl = OperationMethods.hasCommonIdentifier(this.getIdentifiers(), operationMethod.getIdentifiers());
                    if (!(bl != null ? bl == false : !this.isHeuristicMatchForName(operationMethod.getName().getCode()) && !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)operationMethod, this.getName().getCode()))) break;
                    return false;
                }
            }
            operationMethod = (OperationMethod)object;
            return Objects.equals((Object)this.getSourceDimensions(), (Object)operationMethod.getSourceDimensions()) && Objects.equals((Object)this.getTargetDimensions(), (Object)operationMethod.getTargetDimensions()) && Utilities.deepEquals((Object)this.getParameters(), (Object)operationMethod.getParameters(), (ComparisonMode)comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash((Object[])new Object[]{this.sourceDimension, this.targetDimension, this.parameters});
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            Class<? extends CoordinateOperation> clazz = this.getOperationType();
            if (Projection.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(Projection.class)) {
                return "Projection";
            }
            formatter.setInvalidWKT((IdentifiedObject)this, null);
        }
        return "Method";
    }
}

