/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.datum;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.Matrix4;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Matrix;

public class BursaWolfParameters
extends FormattableObject
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 754825592343010900L;
    static final double PPM = 1000000.0;
    public double tX;
    public double tY;
    public double tZ;
    public double rX;
    public double rY;
    public double rZ;
    public double dS;
    private final GeodeticDatum targetDatum;
    private final Extent domainOfValidity;

    public BursaWolfParameters(GeodeticDatum geodeticDatum, Extent extent) {
        this.targetDatum = geodeticDatum;
        this.domainOfValidity = extent;
    }

    void verify() {
        ArgumentChecks.ensureFinite((String)"tX", (double)this.tX);
        ArgumentChecks.ensureFinite((String)"tY", (double)this.tY);
        ArgumentChecks.ensureFinite((String)"tZ", (double)this.tZ);
        ArgumentChecks.ensureFinite((String)"rX", (double)this.rX);
        ArgumentChecks.ensureFinite((String)"rY", (double)this.rY);
        ArgumentChecks.ensureFinite((String)"rZ", (double)this.rZ);
        ArgumentChecks.ensureBetween((String)"dS", (double)-1000000.0, (double)1000000.0, (double)this.dS);
    }

    public GeodeticDatum getTargetDatum() {
        return this.targetDatum;
    }

    final boolean isToWGS84() {
        return this.targetDatum != null && IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)this.targetDatum, "WGS84");
    }

    public boolean isIdentity() {
        return this.tX == 0.0 && this.tY == 0.0 && this.tZ == 0.0 && this.isTranslation();
    }

    public boolean isTranslation() {
        return this.rX == 0.0 && this.rY == 0.0 && this.rZ == 0.0 && this.dS == 0.0;
    }

    public void reverseRotation() {
        this.rX = -this.rX;
        this.rY = -this.rY;
        this.rZ = -this.rZ;
    }

    public void invert() {
        this.tX = -this.tX;
        this.tY = -this.tY;
        this.tZ = -this.tZ;
        this.rX = -this.rX;
        this.rY = -this.rY;
        this.rZ = -this.rZ;
        this.dS = -this.dS;
    }

    DoubleDouble period(Date date) {
        return null;
    }

    DoubleDouble param(int n, DoubleDouble doubleDouble) {
        double d;
        switch (n) {
            case 0: {
                d = this.tX;
                break;
            }
            case 1: {
                d = this.tY;
                break;
            }
            case 2: {
                d = this.tZ;
                break;
            }
            case 3: {
                d = this.rX;
                break;
            }
            case 4: {
                d = this.rY;
                break;
            }
            case 5: {
                d = this.rZ;
                break;
            }
            case 6: {
                d = this.dS;
                break;
            }
            default: {
                throw new AssertionError(n);
            }
        }
        return new DoubleDouble(d);
    }

    public Matrix getPositionVectorTransformation(Date date) {
        DoubleDouble doubleDouble = this.period(date);
        if (doubleDouble == null && this.isTranslation()) {
            Matrix4 matrix4 = new Matrix4();
            matrix4.m03 = this.tX;
            matrix4.m13 = this.tY;
            matrix4.m23 = this.tZ;
            return matrix4;
        }
        DoubleDouble doubleDouble2 = DoubleDouble.createSecondsToRadians();
        DoubleDouble doubleDouble3 = this.param(6, doubleDouble);
        doubleDouble3.divide(1000000.0, 0.0);
        doubleDouble3.add(1.0, 0.0);
        doubleDouble2.multiply(doubleDouble3);
        DoubleDouble doubleDouble4 = this.param(3, doubleDouble);
        doubleDouble4.multiply(doubleDouble2);
        DoubleDouble doubleDouble5 = this.param(4, doubleDouble);
        doubleDouble5.multiply(doubleDouble2);
        DoubleDouble doubleDouble6 = this.param(5, doubleDouble);
        doubleDouble6.multiply(doubleDouble2);
        DoubleDouble doubleDouble7 = new DoubleDouble(doubleDouble4);
        doubleDouble7.negate();
        DoubleDouble doubleDouble8 = new DoubleDouble(doubleDouble5);
        doubleDouble8.negate();
        DoubleDouble doubleDouble9 = new DoubleDouble(doubleDouble6);
        doubleDouble9.negate();
        Integer n = 0;
        return Matrices.create(4, 4, new Number[]{doubleDouble3, doubleDouble9, doubleDouble5, this.param(0, doubleDouble), doubleDouble6, doubleDouble3, doubleDouble7, this.param(1, doubleDouble), doubleDouble8, doubleDouble4, doubleDouble3, this.param(2, doubleDouble), n, n, n, 1});
    }

    public void setPositionVectorTransformation(Matrix matrix, double d) throws IllegalArgumentException {
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        if (n != 4 || n2 != 4) {
            Integer n3 = 4;
            throw new IllegalArgumentException(Errors.format((short)60, (Object)n3, (Object)n3, (Object)n, (Object)n2));
        }
        if (!Matrices.isAffine(matrix)) {
            throw new IllegalArgumentException(Errors.format((short)93));
        }
        this.tX = matrix.getElement(0, 3);
        this.tY = matrix.getElement(1, 3);
        this.tZ = matrix.getElement(2, 3);
        DoubleDouble doubleDouble = new DoubleDouble(BursaWolfParameters.getNumber(matrix, 0, 0));
        doubleDouble.add(BursaWolfParameters.getNumber(matrix, 1, 1));
        doubleDouble.add(BursaWolfParameters.getNumber(matrix, 2, 2));
        doubleDouble.divide(3.0, 0.0);
        DoubleDouble doubleDouble2 = DoubleDouble.createSecondsToRadians();
        doubleDouble2.multiply(doubleDouble);
        doubleDouble.add(-1.0, 0.0);
        doubleDouble.multiply(1000000.0, 0.0);
        this.dS = doubleDouble.value;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs((matrix.getElement(i, i) - 1.0) * 1000000.0 - this.dS) <= d)) {
                throw new IllegalArgumentException(Errors.format((short)88));
            }
            block6: for (int j = i + 1; j < 3; ++j) {
                doubleDouble.setFrom(doubleDouble2);
                doubleDouble.inverseDivide(BursaWolfParameters.getNumber(matrix, i, j));
                double d2 = doubleDouble.value;
                double d3 = doubleDouble.error;
                doubleDouble.setFrom(doubleDouble2);
                doubleDouble.inverseDivide(BursaWolfParameters.getNumber(matrix, j, i));
                if (!(Math.abs(d2 + doubleDouble.value) <= d)) {
                    throw new IllegalArgumentException(Errors.format((short)91));
                }
                doubleDouble.subtract(d2, d3);
                doubleDouble.multiply(0.5, 0.0);
                d2 = doubleDouble.value;
                switch (i * 4 + j) {
                    case 1: {
                        this.rZ = d2;
                        continue block6;
                    }
                    case 2: {
                        this.rY = -d2;
                        continue block6;
                    }
                    case 6: {
                        this.rX = d2;
                    }
                }
            }
        }
    }

    private static Number getNumber(Matrix matrix, int n, int n2) {
        if (matrix instanceof MatrixSIS) {
            return ((MatrixSIS)matrix).getNumber(n, n2);
        }
        return matrix.getElement(n, n2);
    }

    public Extent getDomainOfValidity() {
        if (this.domainOfValidity == null && this.targetDatum != null) {
            return this.targetDatum.getDomainOfValidity();
        }
        return this.domainOfValidity;
    }

    public BursaWolfParameters clone() {
        try {
            return (BursaWolfParameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            BursaWolfParameters bursaWolfParameters = (BursaWolfParameters)object;
            return Numerics.equals((double)this.tX, (double)bursaWolfParameters.tX) && Numerics.equals((double)this.tY, (double)bursaWolfParameters.tY) && Numerics.equals((double)this.tZ, (double)bursaWolfParameters.tZ) && Numerics.equals((double)this.rX, (double)bursaWolfParameters.rX) && Numerics.equals((double)this.rY, (double)bursaWolfParameters.rY) && Numerics.equals((double)this.rZ, (double)bursaWolfParameters.rZ) && Numerics.equals((double)this.dS, (double)bursaWolfParameters.dS) && Objects.equals((Object)this.targetDatum, (Object)bursaWolfParameters.targetDatum) && Objects.equals((Object)this.domainOfValidity, (Object)bursaWolfParameters.domainOfValidity);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new double[]{this.tX, this.tY, this.tZ, this.rX, this.rY, this.rZ, this.dS}) ^ 0x82FA9E54;
    }

    protected String formatTo(Formatter formatter) {
        formatter.append(this.tX);
        formatter.append(this.tY);
        formatter.append(this.tZ);
        formatter.append(this.rX);
        formatter.append(this.rY);
        formatter.append(this.rZ);
        formatter.append(this.dS);
        if (this.isToWGS84()) {
            return "ToWGS84";
        }
        formatter.setInvalidWKT(BursaWolfParameters.class, null);
        String string = IdentifiedObjects.getUnicodeIdentifier((IdentifiedObject)this.targetDatum);
        if (string == null) {
            string = "Unknown";
        }
        return "To" + string;
    }
}

