/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.datum.EngineeringDatum;

@XmlType(name="EngineeringCRSType", propOrder={"affineCS", "cartesianCS", "cylindricalCS", "linearCS", "polarCS", "sphericalCS", "userDefinedCS", "datum"})
@XmlRootElement(name="EngineeringCRS")
public class DefaultEngineeringCRS
extends AbstractCRS
implements EngineeringCRS {
    private static final long serialVersionUID = 6695541732063382701L;
    @XmlElement(name="engineeringDatum")
    private final EngineeringDatum datum;

    private DefaultEngineeringCRS() {
        this.datum = null;
    }

    public DefaultEngineeringCRS(Map<String, ?> map, EngineeringDatum engineeringDatum, CoordinateSystem coordinateSystem) {
        super(map, coordinateSystem);
        ArgumentChecks.ensureNonNull((String)"datum", (Object)engineeringDatum);
        this.datum = engineeringDatum;
    }

    protected DefaultEngineeringCRS(EngineeringCRS engineeringCRS) {
        super((CoordinateReferenceSystem)engineeringCRS);
        this.datum = engineeringCRS.getDatum();
    }

    public static DefaultEngineeringCRS castOrCopy(EngineeringCRS engineeringCRS) {
        return engineeringCRS == null || engineeringCRS instanceof DefaultEngineeringCRS ? (DefaultEngineeringCRS)engineeringCRS : new DefaultEngineeringCRS(engineeringCRS);
    }

    public Class<? extends EngineeringCRS> getInterface() {
        return EngineeringCRS.class;
    }

    public final EngineeringDatum getDatum() {
        return this.datum;
    }

    @XmlElement(name="affineCS")
    private AffineCS getAffineCS() {
        return this.getCoordinateSystem(AffineCS.class);
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="cylindricalCS")
    private CylindricalCS getCylindricalCS() {
        return this.getCoordinateSystem(CylindricalCS.class);
    }

    @XmlElement(name="linearCS")
    private LinearCS getLinearCS() {
        return this.getCoordinateSystem(LinearCS.class);
    }

    @XmlElement(name="polarCS")
    private PolarCS getPolarCS() {
        return this.getCoordinateSystem(PolarCS.class);
    }

    @XmlElement(name="sphericalCS")
    private SphericalCS getSphericalCS() {
        return this.getCoordinateSystem(SphericalCS.class);
    }

    @XmlElement(name="userDefinedCS")
    private UserDefinedCS getUserDefinedCS() {
        return this.getCoordinateSystem(UserDefinedCS.class);
    }

    private void setAffineCS(AffineCS affineCS) {
        super.setCoordinateSystem("affineCS", (CoordinateSystem)affineCS);
    }

    private void setCartesianCS(CartesianCS cartesianCS) {
        super.setCoordinateSystem("cartesianCS", (CoordinateSystem)cartesianCS);
    }

    private void setCylindricalCS(CylindricalCS cylindricalCS) {
        super.setCoordinateSystem("cylindricalCS", (CoordinateSystem)cylindricalCS);
    }

    private void setLinearCS(LinearCS linearCS) {
        super.setCoordinateSystem("linearCS", (CoordinateSystem)linearCS);
    }

    private void setPolarCS(PolarCS polarCS) {
        super.setCoordinateSystem("polarCS", (CoordinateSystem)polarCS);
    }

    private void setSphericalCS(SphericalCS sphericalCS) {
        super.setCoordinateSystem("sphericalCS", (CoordinateSystem)sphericalCS);
    }

    private void setUserDefinedCS(UserDefinedCS userDefinedCS) {
        super.setCoordinateSystem("userDefinedCS", (CoordinateSystem)userDefinedCS);
    }

    @Override
    public DefaultEngineeringCRS forConvention(AxesConvention axesConvention) {
        return (DefaultEngineeringCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultEngineeringCRS(map, this.datum, coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        return formatter.getConvention().majorVersion() == 1 ? "Local_CS" : "EngineeringCRS";
    }
}

