/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.parameter.ParameterFormat;
import org.apache.sis.parameter.ParameterValueList;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterCardinalityException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public class DefaultParameterValueGroup
implements ParameterValueGroup,
LenientComparable,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1985309386356545126L;
    private ParameterValueList values;

    public DefaultParameterValueGroup(ParameterDescriptorGroup parameterDescriptorGroup) {
        ArgumentChecks.ensureNonNull((String)"descriptor", (Object)parameterDescriptorGroup);
        this.values = new ParameterValueList(parameterDescriptorGroup);
    }

    public ParameterDescriptorGroup getDescriptor() {
        return this.values.descriptor;
    }

    public List<GeneralParameterValue> values() {
        return this.values;
    }

    public ParameterValue<?> parameter(String string) throws ParameterNotFoundException {
        GeneralParameterDescriptor generalParameterDescriptor;
        int n;
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        ParameterValueList parameterValueList = this.values;
        int n2 = parameterValueList.size();
        for (n = 0; n < n2; ++n) {
            GeneralParameterDescriptor generalParameterDescriptor2 = parameterValueList.descriptor(n);
            if (!(generalParameterDescriptor2 instanceof ParameterDescriptor) || !string.equals(generalParameterDescriptor2.getName().toString())) continue;
            return (ParameterValue)parameterValueList.get(n);
        }
        n = -1;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            generalParameterDescriptor = parameterValueList.descriptor(i);
            if (!(generalParameterDescriptor instanceof ParameterDescriptor) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)generalParameterDescriptor, string)) continue;
            if (n < 0) {
                n = i;
                continue;
            }
            n3 = i;
        }
        if (n >= 0) {
            if (n3 < 0) {
                return (ParameterValue)parameterValueList.get(n);
            }
            throw new ParameterNotFoundException(Errors.format((short)151, (Object)parameterValueList.descriptor(n).getName(), (Object)parameterValueList.descriptor(n3).getName(), (Object)string), string);
        }
        GeneralParameterDescriptor generalParameterDescriptor3 = parameterValueList.descriptor.descriptor(string);
        if (generalParameterDescriptor3 instanceof ParameterDescriptor && generalParameterDescriptor3.getMaximumOccurs() != 0) {
            generalParameterDescriptor = ((ParameterDescriptor)generalParameterDescriptor3).createValue();
            parameterValueList.addUnchecked((GeneralParameterValue)generalParameterDescriptor);
            return generalParameterDescriptor;
        }
        throw new ParameterNotFoundException(Errors.format((short)147, (Object)parameterValueList.descriptor.getName(), (Object)string), string);
    }

    public List<ParameterValueGroup> groups(String string) throws ParameterNotFoundException {
        ParameterDescriptorGroup parameterDescriptorGroup;
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        ParameterValueList parameterValueList = this.values;
        ArrayList<ParameterValueGroup> arrayList = new ArrayList<ParameterValueGroup>(4);
        int n = parameterValueList.size();
        for (int i = 0; i < n; ++i) {
            GeneralParameterDescriptor generalParameterDescriptor = parameterValueList.descriptor(i);
            if (!(generalParameterDescriptor instanceof ParameterDescriptorGroup) || !IdentifiedObjects.isHeuristicMatchForName((IdentifiedObject)generalParameterDescriptor, string)) continue;
            arrayList.add((ParameterValueGroup)parameterValueList.get(i));
        }
        if (arrayList.isEmpty() && !((parameterDescriptorGroup = parameterValueList.descriptor).descriptor(string) instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((short)147, (Object)parameterDescriptorGroup.getName(), (Object)string), string);
        }
        return arrayList;
    }

    public ParameterValueGroup addGroup(String string) throws ParameterNotFoundException, InvalidParameterCardinalityException {
        ParameterValueList parameterValueList = this.values;
        ParameterDescriptorGroup parameterDescriptorGroup = parameterValueList.descriptor;
        GeneralParameterDescriptor generalParameterDescriptor = parameterDescriptorGroup.descriptor(string);
        if (!(generalParameterDescriptor instanceof ParameterDescriptorGroup)) {
            throw new ParameterNotFoundException(Errors.format((short)147, (Object)parameterDescriptorGroup.getName(), (Object)string), string);
        }
        ParameterValueGroup parameterValueGroup = ((ParameterDescriptorGroup)generalParameterDescriptor).createValue();
        parameterValueList.add((GeneralParameterValue)parameterValueGroup);
        return parameterValueGroup;
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            if (comparisonMode == ComparisonMode.STRICT) {
                if (this.getClass() == object.getClass()) {
                    DefaultParameterValueGroup defaultParameterValueGroup = (DefaultParameterValueGroup)object;
                    return Objects.equals((Object)this.values.descriptor, (Object)defaultParameterValueGroup.values.descriptor) && Objects.equals((Object)this.values, (Object)defaultParameterValueGroup.values);
                }
            } else if (object instanceof ParameterValueGroup) {
                ParameterValueGroup parameterValueGroup = (ParameterValueGroup)object;
                return Utilities.deepEquals((Object)this.getDescriptor(), (Object)parameterValueGroup.getDescriptor(), (ComparisonMode)comparisonMode) && Utilities.deepEquals(this.values(), (Object)parameterValueGroup.values(), (ComparisonMode)comparisonMode);
            }
        }
        return false;
    }

    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        return this.values.descriptor.hashCode() ^ this.values.hashCode();
    }

    public DefaultParameterValueGroup clone() {
        DefaultParameterValueGroup defaultParameterValueGroup;
        try {
            defaultParameterValueGroup = (DefaultParameterValueGroup)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        defaultParameterValueGroup.values = new ParameterValueList(defaultParameterValueGroup.values);
        return defaultParameterValueGroup;
    }

    public String toString() {
        return ParameterFormat.sharedFormat(this);
    }

    public void print() {
        ParameterFormat.print(this);
    }
}

