/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Map;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public final class OperationMethods
extends Static {
    private OperationMethods() {
    }

    public static Boolean hasCommonIdentifier(Iterable<? extends Identifier> iterable, Iterable<? extends Identifier> iterable2) {
        if (iterable != null && iterable2 != null) {
            boolean bl = false;
            for (Identifier identifier : iterable) {
                Citation citation = identifier.getAuthority();
                String string = identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getCodeSpace() : null;
                for (Identifier identifier2 : iterable2) {
                    if (!OperationMethods.authorityMatches(identifier, citation, string)) continue;
                    if (CharSequences.equalsFiltered((CharSequence)identifier.getCode(), (CharSequence)identifier2.getCode(), (Characters.Filter)Characters.Filter.UNICODE_IDENTIFIER, (boolean)true)) {
                        return Boolean.TRUE;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static boolean authorityMatches(Identifier identifier, Citation citation, String string) {
        Citation citation2;
        if (citation != null && (citation2 = identifier.getAuthority()) != null) {
            return Citations.identifierMatches((Citation)citation, (Citation)citation2);
        }
        if (string != null) {
            String string2 = citation2 = identifier instanceof ReferenceIdentifier ? ((ReferenceIdentifier)identifier).getCodeSpace() : null;
            if (citation2 != null) {
                return CharSequences.equalsFiltered((CharSequence)string, (CharSequence)citation2, (Characters.Filter)Characters.Filter.UNICODE_IDENTIFIER, (boolean)true);
            }
        }
        return false;
    }

    public static void checkDimensions(OperationMethod operationMethod, MathTransform mathTransform, Map<String, ?> map) throws IllegalArgumentException {
        int n = mathTransform.getSourceDimensions();
        Integer n2 = operationMethod.getSourceDimensions();
        if (n2 != null && n > n2) {
            MathTransform mathTransform2 = null;
            for (MathTransform mathTransform3 : MathTransforms.getSteps(mathTransform)) {
                if (OperationMethods.isIgnorable(mathTransform3)) continue;
                if (mathTransform2 == null && mathTransform3 instanceof PassThroughTransform) {
                    mathTransform2 = ((PassThroughTransform)mathTransform3).getSubTransform();
                    continue;
                }
                mathTransform2 = null;
                break;
            }
            if (mathTransform2 != null) {
                mathTransform = mathTransform2;
                n = mathTransform.getSourceDimensions();
            }
        }
        byte by = 0;
        if (n2 == null || n == n2) {
            n = mathTransform.getTargetDimensions();
            n2 = operationMethod.getTargetDimensions();
            if (n2 == null || n == n2) {
                return;
            }
            by = 1;
        }
        throw new IllegalArgumentException(Errors.getResources(map).getString((short)178, (Object)by, (Object)n2, (Object)n));
    }

    private static boolean isIgnorable(MathTransform mathTransform) {
        Matrix matrix = MathTransforms.getMatrix(mathTransform);
        if (matrix != null) {
            int n = matrix.getNumRow();
            if (matrix.getNumCol() == n) {
                for (int i = 0; i < n; ++i) {
                    int n2 = 0;
                    int n3 = 0;
                    for (int j = 0; j < n; ++j) {
                        if (matrix.getElement(i, j) != 0.0) {
                            ++n2;
                        }
                        if (matrix.getElement(j, i) == 0.0) continue;
                        ++n3;
                    }
                    if (n2 == 1 && n3 == true) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

