/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeneralDirectPosition
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5524426558018300122L;
    public final double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(CoordinateReferenceSystem coordinateReferenceSystem) {
        this(coordinateReferenceSystem.getCoordinateSystem().getDimension());
        this.crs = coordinateReferenceSystem;
    }

    public GeneralDirectPosition(int n) throws NegativeArraySizeException {
        this.ordinates = new double[n];
    }

    public GeneralDirectPosition(double ... dArray) {
        this.ordinates = dArray;
    }

    public GeneralDirectPosition(DirectPosition directPosition) {
        this.ordinates = directPosition.getCoordinate();
        this.crs = directPosition.getCoordinateReferenceSystem();
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.ordinates.length, (CoordinateReferenceSystem)this.crs);
    }

    public GeneralDirectPosition(CharSequence charSequence) throws IllegalArgumentException {
        this.ordinates = GeneralDirectPosition.parse(charSequence);
        if (this.ordinates == null) {
            throw new IllegalArgumentException(Errors.format((short)124, (Object)"POINT", (Object)charSequence));
        }
    }

    public final int getDimension() {
        return this.ordinates.length;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)this.getDimension(), (CoordinateReferenceSystem)coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.ordinates.clone();
    }

    public void setCoordinate(double ... dArray) throws MismatchedDimensionException {
        if (dArray == null) {
            Arrays.fill(this.ordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches((String)"ordinates", (int)this.ordinates.length, (double[])dArray);
            System.arraycopy(dArray, 0, this.ordinates, 0, dArray.length);
        }
    }

    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        return this.ordinates[n];
    }

    public void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        this.ordinates[n] = d;
    }

    @Override
    public void setLocation(DirectPosition directPosition) throws MismatchedDimensionException {
        if (directPosition == null) {
            Arrays.fill(this.ordinates, Double.NaN);
        } else {
            ArgumentChecks.ensureDimensionMatches((String)"position", (int)this.ordinates.length, (DirectPosition)directPosition);
            this.setCoordinateReferenceSystem(directPosition.getCoordinateReferenceSystem());
            for (int i = 0; i < this.ordinates.length; ++i) {
                this.ordinates[i] = directPosition.getOrdinate(i);
            }
        }
    }

    @Override
    public String toString() {
        return GeneralDirectPosition.toString(this, GeneralDirectPosition.isSimplePrecision(this.ordinates));
    }

    public GeneralDirectPosition clone() {
        try {
            GeneralDirectPosition generalDirectPosition = (GeneralDirectPosition)super.clone();
            Field field = GeneralDirectPosition.class.getDeclaredField("ordinates");
            field.setAccessible(true);
            field.set(generalDirectPosition, this.ordinates.clone());
            return generalDirectPosition;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.ordinates) + Objects.hashCode((Object)this.getCoordinateReferenceSystem());
        assert (n == super.hashCode());
        return n;
    }
}

