/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DirectPosition1D
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -9196647508968517838L;
    private CoordinateReferenceSystem crs;
    public double ordinate;

    public DirectPosition1D() {
    }

    public DirectPosition1D(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)1, (CoordinateReferenceSystem)coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    public DirectPosition1D(double d) {
        this.ordinate = d;
    }

    public DirectPosition1D(CharSequence charSequence) throws IllegalArgumentException {
        double[] dArray = DirectPosition1D.parse(charSequence);
        if (dArray == null) {
            throw new IllegalArgumentException(Errors.format((short)124, (Object)"POINT", (Object)charSequence));
        }
        ArgumentChecks.ensureDimensionMatches((String)"wkt", (int)1, (double[])dArray);
        this.ordinate = dArray[0];
    }

    public final int getDimension() {
        return 1;
    }

    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureDimensionMatches((String)"crs", (int)1, (CoordinateReferenceSystem)coordinateReferenceSystem);
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final double[] getCoordinate() {
        return new double[]{this.ordinate};
    }

    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.ordinate;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)49, (Object)n));
    }

    public void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        if (n != 0) {
            throw new IndexOutOfBoundsException(Errors.format((short)49, (Object)n));
        }
        this.ordinate = d;
    }

    @Override
    public void setLocation(DirectPosition directPosition) throws MismatchedDimensionException {
        ArgumentChecks.ensureDimensionMatches((String)"position", (int)1, (DirectPosition)directPosition);
        this.setCoordinateReferenceSystem(directPosition.getCoordinateReferenceSystem());
        this.ordinate = directPosition.getOrdinate(0);
    }

    @Override
    public String toString() {
        return DirectPosition1D.toString(this, this.ordinate == (double)((float)this.ordinate));
    }

    public DirectPosition1D clone() {
        try {
            return (DirectPosition1D)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    @Override
    public int hashCode() {
        int n = 31 + Numerics.hashCode((long)Double.doubleToLongBits(this.ordinate)) + Objects.hashCode((Object)this.crs);
        assert (n == super.hashCode());
        return n;
    }
}

