/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.maintenance;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.LegacyPropertyAdapter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.maintenance.ScopeDescription;
import org.opengis.metadata.quality.Scope;

@XmlType(name="DQ_Scope_Type", propOrder={"level", "extents", "levelDescription"})
@XmlRootElement(name="DQ_Scope")
public class DefaultScope
extends ISOMetadata
implements Scope {
    private static final long serialVersionUID = -979575548481874359L;
    private ScopeCode level;
    private Collection<Extent> extents;
    private Collection<ScopeDescription> levelDescription;

    public DefaultScope() {
    }

    public DefaultScope(ScopeCode scopeCode) {
        this.level = scopeCode;
    }

    public DefaultScope(Scope scope) {
        super(scope);
        if (scope != null) {
            this.level = scope.getLevel();
            this.levelDescription = this.copyCollection(scope.getLevelDescription(), ScopeDescription.class);
            this.extents = scope instanceof DefaultScope ? this.copyCollection(((DefaultScope)scope).getExtents(), Extent.class) : this.singleton(scope.getExtent(), Extent.class);
        }
    }

    public static DefaultScope castOrCopy(Scope scope) {
        if (scope == null || scope instanceof DefaultScope) {
            return (DefaultScope)scope;
        }
        return new DefaultScope(scope);
    }

    @XmlElement(name="level", required=true)
    public ScopeCode getLevel() {
        return this.level;
    }

    public void setLevel(ScopeCode scopeCode) {
        this.checkWritePermission();
        this.level = scopeCode;
    }

    @XmlElement(name="extent")
    @UML(identifier="extent", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Extent> getExtents() {
        this.extents = this.nonNullCollection(this.extents, Extent.class);
        return this.extents;
    }

    public void setExtents(Collection<? extends Extent> collection) {
        this.extents = this.writeCollection(collection, this.extents, Extent.class);
    }

    @Deprecated
    public Extent getExtent() {
        return LegacyPropertyAdapter.getSingleton(this.getExtents(), Extent.class, null, DefaultScope.class, "getExtent");
    }

    @Deprecated
    public void setExtent(Extent extent) {
        this.setExtents(LegacyPropertyAdapter.asCollection(extent));
    }

    @XmlElement(name="levelDescription")
    public Collection<ScopeDescription> getLevelDescription() {
        this.levelDescription = this.nonNullCollection(this.levelDescription, ScopeDescription.class);
        return this.levelDescription;
    }

    public void setLevelDescription(Collection<? extends ScopeDescription> collection) {
        this.levelDescription = this.writeCollection(collection, this.levelDescription, ScopeDescription.class);
    }
}

