/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.content;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.util.GenericName;

@XmlType(name="MD_FeatureTypeInfo", propOrder={"featureTypeName", "featureInstanceCount"})
@XmlRootElement(name="MD_FeatureTypeInfo")
@UML(identifier="MD_FeatureTypeInfo", specification=Specification.ISO_19115)
public class DefaultFeatureTypeInfo
extends ISOMetadata {
    private static final long serialVersionUID = -4103901642915981422L;
    private GenericName featureTypeName;
    private Integer featureInstanceCount;

    public DefaultFeatureTypeInfo() {
    }

    public DefaultFeatureTypeInfo(GenericName genericName) {
        this.featureTypeName = genericName;
    }

    public DefaultFeatureTypeInfo(DefaultFeatureTypeInfo defaultFeatureTypeInfo) {
        super(defaultFeatureTypeInfo);
        if (defaultFeatureTypeInfo != null) {
            this.featureTypeName = defaultFeatureTypeInfo.getFeatureTypeName();
            this.featureInstanceCount = defaultFeatureTypeInfo.getFeatureInstanceCount();
        }
    }

    @XmlElement(name="featureTypeName", required=true)
    @UML(identifier="featureTypeName", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public GenericName getFeatureTypeName() {
        return this.featureTypeName;
    }

    public void setFeatureTypeName(GenericName genericName) {
        this.checkWritePermission();
        this.featureTypeName = genericName;
    }

    @ValueRange(minimum=1.0)
    @XmlElement(name="featureInstanceCount")
    @UML(identifier="featureInstanceCount", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Integer getFeatureInstanceCount() {
        return this.featureInstanceCount;
    }

    public void setFeatureInstanceCount(Integer n) {
        this.checkWritePermission();
        if (n != null && n < 0) {
            MetadataUtilities.warnNonPositiveArgument(DefaultFeatureTypeInfo.class, "featureInstanceCount", true, n);
        }
        this.featureInstanceCount = n;
    }
}

