/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.metadata.Cloner;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.PropertyComparator;
import org.apache.sis.metadata.PropertyInformation;
import org.apache.sis.metadata.TypeValuePolicy;
import org.apache.sis.metadata.UnmodifiableMetadataException;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.IdentifiedObject;
import org.opengis.annotation.UML;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.citation.Citation;

class PropertyAccessor {
    static final int COUNT_FIRST = 0;
    static final int COUNT_SHALLOW = 1;
    static final int COUNT_DEEP = 2;
    static final int RETURN_NULL = 0;
    static final int RETURN_PREVIOUS = 1;
    static final int APPEND = 2;
    private static final Method EXTRA_GETTER;
    private final Citation standard;
    final Class<?> type;
    final Class<?> implementation;
    private final int allCount;
    private final int standardCount;
    private final Method[] getters;
    private final Method[] setters;
    private final String[] names;
    private final Class<?>[] elementTypes;
    private final Map<String, Integer> mapping;
    private volatile transient ObjectConverter<?, ?> lastConverter;
    private transient ExtendedElementInformation[] informations;

    PropertyAccessor(Citation citation, Class<?> clazz, Class<?> clazz2) {
        int n;
        assert (clazz.isAssignableFrom(clazz2)) : clazz2;
        this.standard = citation;
        this.type = clazz;
        this.implementation = clazz2;
        this.getters = PropertyAccessor.getGetters(clazz, clazz2);
        int n2 = n = this.getters.length;
        if (n != 0 && this.getters[n - 1] == EXTRA_GETTER) {
            if (!EXTRA_GETTER.getDeclaringClass().isAssignableFrom(clazz2)) {
                --n;
            }
            --n2;
        }
        while (n2 != 0 && this.isDeprecated(n2 - 1)) {
            --n2;
        }
        this.allCount = n;
        this.standardCount = n2;
        this.mapping = new HashMap<String, Integer>(Containers.hashMapCapacity((int)n));
        this.names = new String[n];
        this.elementTypes = new Class[n];
        Method[] methodArray = null;
        Class[] classArray = new Class[1];
        for (int i = 0; i < n; ++i) {
            Class clazz3;
            Method method;
            Method method2;
            block18: {
                Class<?> clazz4;
                Integer n3 = i;
                method2 = this.getters[i];
                String string = method2.getName();
                int n4 = PropertyComparator.prefix(string).length();
                this.addMapping(string, n3);
                this.names[i] = PropertyComparator.toPropertyName(string, n4);
                this.addMappingWithLowerCase(this.names[i], n3);
                UML uML = method2.getAnnotation(UML.class);
                if (uML != null) {
                    this.addMappingWithLowerCase(uML.identifier().intern(), n3);
                }
                classArray[0] = clazz4 = method2.getReturnType();
                if (string.length() > n4) {
                    int n5 = string.codePointAt(n4);
                    int n6 = Character.toUpperCase(n5);
                    int n7 = string.length();
                    StringBuilder stringBuilder = new StringBuilder(n7 - n4 + 5).append("set");
                    if (n5 != n6) {
                        stringBuilder.appendCodePoint(n6).append(string, n4 + Character.charCount(n5), n7);
                    } else {
                        stringBuilder.append(string, n4, n7);
                    }
                    string = stringBuilder.toString();
                }
                method = null;
                try {
                    method = clazz2.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        method2 = clazz2.getMethod(method2.getName(), null);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        throw new AssertionError((Object)noSuchMethodException2);
                    }
                    Class<?> clazz5 = clazz4;
                    clazz4 = method2.getReturnType();
                    if (clazz5 == clazz4) break block18;
                    classArray[0] = clazz4;
                    try {
                        method = clazz2.getMethod(string, classArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        // empty catch block
                    }
                }
            }
            if (method != null) {
                if (methodArray == null) {
                    methodArray = new Method[n];
                }
                methodArray[i] = method;
            }
            if (Collection.class.isAssignableFrom(clazz3 = method2.getReturnType())) {
                clazz3 = Classes.boundOfParameterizedProperty((Method)method2);
            }
            this.elementTypes[i] = Numbers.primitiveToWrapper((Class)clazz3);
        }
        this.setters = methodArray;
    }

    private void addMapping(String string, Integer n) {
        Integer n2;
        if (!string.isEmpty() && (n2 = this.mapping.put(string, n)) != null && !n2.equals(n)) {
            boolean bl = this.isDeprecated(n);
            if (bl == this.isDeprecated(n2)) {
                throw new IllegalStateException(Errors.format((short)17, (Object)(Classes.getShortName(this.type) + '.' + string)));
            }
            if (bl) {
                this.mapping.put(string, n2);
            }
        }
    }

    private void addMappingWithLowerCase(String string, Integer n) {
        this.addMapping(string, n);
        String string2 = string.toLowerCase(Locale.ROOT);
        if (!string2.equals(string)) {
            this.addMapping(string2, n);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Method[] getGetters(Class<?> clazz, Class<?> clazz2) {
        Object[] objectArray = clazz2.getMethods();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(Containers.hashMapCapacity((int)objectArray.length));
        boolean bl = false;
        int n = 0;
        for (Method method : objectArray) {
            void method2;
            Integer n2;
            String string;
            if (!Classes.isPossibleGetter((Method)method) || (string = method.getName()).startsWith("set")) continue;
            if (clazz == clazz2) {
                if (!clazz.isInterface() && !method.isAnnotationPresent(UML.class)) {
                    continue;
                }
            } else {
                try {
                    Method method3 = clazz.getMethod(string, null);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!method.isAnnotationPresent(UML.class)) continue;
                }
            }
            if ((n2 = hashMap.put(string, n)) != null) {
                Class<?> clazz3 = ((Method)objectArray[n2]).getReturnType();
                Class<?> clazz4 = method2.getReturnType();
                if (clazz4.isAssignableFrom(clazz3)) continue;
                if (clazz3.isAssignableFrom(clazz4)) {
                    objectArray[n2.intValue()] = method2;
                    continue;
                }
                throw new ClassCastException(Errors.format((short)29, (Object)(Classes.getShortName(clazz) + '.' + string), clazz4, clazz3));
            }
            objectArray[n++] = method2;
            if (bl) continue;
            bl = string.equals(EXTRA_GETTER.getName());
        }
        Arrays.sort(objectArray, 0, n, new PropertyComparator(clazz2));
        if (!bl) {
            if (objectArray.length == n) {
                objectArray = (Method[])Arrays.copyOf(objectArray, n + 1);
            }
            objectArray[n++] = EXTRA_GETTER;
        }
        objectArray = (Method[])ArraysExt.resize((Object[])objectArray, (int)n);
        return objectArray;
    }

    final int count() {
        return this.standardCount;
    }

    final int indexOf(String string, boolean bl) {
        String string2;
        Integer n = this.mapping.get(string);
        if (n == null && ((string2 = CharSequences.trimWhitespaces((String)CharSequences.replace((CharSequence)string, (CharSequence)" ", (CharSequence)"").toString().toLowerCase(Locale.ROOT))) == string || (n = this.mapping.get(string2)) == null)) {
            if (!bl) {
                return -1;
            }
            throw new IllegalArgumentException(Errors.format((short)71, this.type, (Object)string));
        }
        return n;
    }

    final String name(int n, KeyNamePolicy keyNamePolicy) {
        if (n >= 0 && n < this.names.length) {
            switch (keyNamePolicy) {
                case UML_IDENTIFIER: {
                    UML uML = this.getters[n].getAnnotation(UML.class);
                    if (uML != null) {
                        return uML.identifier().intern();
                    }
                }
                case JAVABEANS_PROPERTY: {
                    return this.names[n];
                }
                case METHOD_NAME: {
                    return this.getters[n].getName();
                }
                case SENTENCE: {
                    return CharSequences.camelCaseToSentence((CharSequence)this.names[n]).toString();
                }
            }
        }
        return null;
    }

    Class<?> type(int n, TypeValuePolicy typeValuePolicy) {
        if (n >= 0 && n < this.allCount) {
            switch (typeValuePolicy) {
                case ELEMENT_TYPE: {
                    return this.elementTypes[n];
                }
                case PROPERTY_TYPE: {
                    return this.getters[n].getReturnType();
                }
                case DECLARING_INTERFACE: {
                    return this.getters[n].getDeclaringClass();
                }
                case DECLARING_CLASS: {
                    Method method = this.getters[n];
                    if (this.implementation != this.type) {
                        try {
                            method = this.implementation.getMethod(method.getName(), null);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new AssertionError((Object)noSuchMethodException);
                        }
                    }
                    return method.getDeclaringClass();
                }
            }
        }
        return null;
    }

    final boolean isCollection(int n) {
        if (n >= 0 && n < this.allCount) {
            return Collection.class.isAssignableFrom(this.getters[n].getReturnType());
        }
        return false;
    }

    private boolean isDeprecated(int n) {
        return PropertyComparator.isDeprecated(this.implementation, this.getters[n]);
    }

    final synchronized ExtendedElementInformation information(int n) {
        ExtendedElementInformation[] extendedElementInformationArray = this.informations;
        if (extendedElementInformationArray == null) {
            this.informations = extendedElementInformationArray = new PropertyInformation[this.standardCount];
        }
        if (n < 0 || n >= extendedElementInformationArray.length) {
            return null;
        }
        PropertyInformation propertyInformation = extendedElementInformationArray[n];
        if (propertyInformation == null) {
            ValueRange valueRange;
            Class<?> clazz = this.elementTypes[n];
            String string = this.name(n, KeyNamePolicy.UML_IDENTIFIER);
            Method method = this.getters[n];
            try {
                valueRange = this.implementation.getMethod(method.getName(), null).getAnnotation(ValueRange.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
            extendedElementInformationArray[n] = propertyInformation = new PropertyInformation(this.standard, string, method, clazz, valueRange);
        }
        return propertyInformation;
    }

    final boolean isWritable(int n) {
        return n >= 0 && n < this.allCount && this.setters != null && this.setters[n] != null;
    }

    Object get(int n, Object object) throws BackingStoreException {
        return n >= 0 && n < this.allCount ? PropertyAccessor.get(this.getters[n], object) : null;
    }

    private static Object get(Method method, Object object) throws BackingStoreException {
        assert (method.getReturnType() != Void.TYPE) : method;
        try {
            return method.invoke(object, (Object[])null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new BackingStoreException(throwable);
        }
    }

    Object set(int n, Object object, Object object2, int n2) throws UnmodifiableMetadataException, ClassCastException, BackingStoreException {
        if (n < 0 || n >= this.allCount) {
            return null;
        }
        if (this.setters != null) {
            Method method = this.getters[n];
            Method method2 = this.setters[n];
            if (method2 != null) {
                Object object3;
                Object object4;
                switch (n2) {
                    case 0: {
                        object4 = null;
                        object3 = null;
                        break;
                    }
                    case 2: {
                        object4 = PropertyAccessor.get(method, object);
                        object3 = null;
                        break;
                    }
                    case 1: {
                        object4 = PropertyAccessor.get(method, object);
                        if (object4 instanceof Collection) {
                            if (object4 instanceof List) {
                                object3 = CollectionsExt.snapshot((List)((List)object4));
                                break;
                            }
                            object3 = CollectionsExt.modifiableCopy((Collection)((Collection)object4));
                            break;
                        }
                        if (object4 instanceof Map) {
                            object3 = CollectionsExt.modifiableCopy((Map)((Map)object4));
                            break;
                        }
                        object3 = object4;
                        break;
                    }
                    default: {
                        throw new AssertionError(n2);
                    }
                }
                Object[] objectArray = new Object[]{object2};
                Boolean bl = this.convert(method, object, object4, objectArray, this.elementTypes[n], n2 == 2);
                if (bl == null && (bl = Boolean.valueOf(n2 == 0 || objectArray[0] != object4)).booleanValue() && n2 == 2 && !ValueExistencePolicy.isNullOrEmpty(object4)) {
                    return null;
                }
                if (bl.booleanValue()) {
                    PropertyAccessor.set(method2, object, objectArray);
                }
                return n2 == 2 ? bl : object3;
            }
        }
        throw new UnmodifiableMetadataException(Errors.format((short)11, (Object)this.names[n]));
    }

    private static void set(Method method, Object object, Object[] objectArray) throws BackingStoreException {
        try {
            method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new BackingStoreException(throwable);
        }
    }

    private Boolean convert(Method method, Object object, Object object2, Object[] objectArray, Class<?> clazz, boolean bl) throws ClassCastException, BackingStoreException {
        assert (objectArray.length == 1);
        Collection<Object> collection = objectArray[0];
        Class clazz2 = method.getReturnType();
        if (collection == null) {
            if (clazz2.isPrimitive()) {
                objectArray[0] = Numbers.valueOfNil(clazz2);
            }
            return null;
        }
        Boolean bl2 = null;
        if (!Collection.class.isAssignableFrom(clazz2)) {
            if (collection instanceof Collection) {
                Iterator iterator = ((Collection)collection).iterator();
                if (!iterator.hasNext()) {
                    objectArray[0] = null;
                    return null;
                }
                Object e = iterator.next();
                if (!iterator.hasNext()) {
                    collection = e;
                }
            }
            clazz2 = Numbers.primitiveToWrapper(clazz2);
        } else {
            List<Object> list;
            Object[] objectArray2;
            boolean bl3 = collection instanceof Collection;
            if (bl3) {
                objectArray2 = ((Collection)collection).toArray();
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = collection;
            }
            Object[] objectArray4 = objectArray2;
            collection = list = Arrays.asList(objectArray4);
            Collection collection2 = null;
            if (!bl3 || bl) {
                if (object2 == null) {
                    object2 = PropertyAccessor.get(method, object);
                }
                if (object2 != null) {
                    collection2 = (Collection)object2;
                    if (collection2 instanceof CheckedContainer) {
                        clazz = ((CheckedContainer)collection2).getElementType();
                    }
                    collection = collection2;
                }
            }
            if (clazz != null) {
                this.convert(objectArray4, clazz);
            }
            if (collection2 != null) {
                bl2 = collection2.addAll(list);
            }
        }
        objectArray[0] = collection;
        this.convert(objectArray, clazz2);
        return bl2;
    }

    private void convert(Object[] objectArray, Class<?> clazz) throws ClassCastException {
        boolean bl = false;
        ObjectConverter objectConverter = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Class<?> clazz2;
            Object object = objectArray[i];
            if (object == null || clazz.isAssignableFrom(clazz2 = object.getClass())) continue;
            try {
                if (objectConverter == null) {
                    objectConverter = this.lastConverter;
                }
                if (objectConverter == null || objectConverter.getSourceClass() != clazz2 || objectConverter.getTargetClass() != clazz) {
                    objectConverter = ObjectConverters.find(clazz2, clazz);
                    bl = true;
                }
                objectArray[i] = objectConverter.apply(object);
                continue;
            }
            catch (UnconvertibleObjectException unconvertibleObjectException) {
                ClassCastException classCastException = new ClassCastException(Errors.format((short)34, clazz, clazz2));
                classCastException.initCause(unconvertibleObjectException);
                throw classCastException;
            }
        }
        if (bl) {
            this.lastConverter = objectConverter;
        }
    }

    public int count(Object object, ValueExistencePolicy valueExistencePolicy, int n) throws BackingStoreException {
        assert (this.type.isInstance(object)) : object;
        if (valueExistencePolicy == ValueExistencePolicy.ALL && n != 2) {
            return this.count();
        }
        int n2 = 0;
        block5: for (int i = 0; i < this.standardCount; ++i) {
            Object object2 = PropertyAccessor.get(this.getters[i], object);
            if (valueExistencePolicy.isSkipped(object2)) continue;
            switch (n) {
                case 0: {
                    return 1;
                }
                case 1: {
                    ++n2;
                    continue block5;
                }
                case 2: {
                    n2 += object2 != null && this.isCollection(i) ? Math.max(((Collection)object2).size(), 1) : 1;
                    continue block5;
                }
                default: {
                    throw new AssertionError(n);
                }
            }
        }
        return n2;
    }

    public boolean equals(Object object, Object object2, ComparisonMode comparisonMode) throws BackingStoreException {
        Object object3;
        assert (this.type.isInstance(object)) : object;
        assert (this.type.isInstance(object2)) : object2;
        for (int i = 0; i < this.standardCount; ++i) {
            object3 = this.getters[i];
            Object object4 = PropertyAccessor.get((Method)object3, object);
            Object object5 = PropertyAccessor.get((Method)object3, object2);
            if (ValueExistencePolicy.isNullOrEmpty(object4) && ValueExistencePolicy.isNullOrEmpty(object5) || Utilities.deepEquals((Object)object4, (Object)object5, (ComparisonMode)comparisonMode) || comparisonMode.ordinal() >= ComparisonMode.APPROXIMATIVE.ordinal() && Numerics.floatEpsilonEqual((Object)object4, (Object)object5)) continue;
            return false;
        }
        if (comparisonMode == ComparisonMode.STRICT && EXTRA_GETTER.getDeclaringClass().isInstance(object2)) {
            Object object6 = PropertyAccessor.get(EXTRA_GETTER, object);
            object3 = PropertyAccessor.get(EXTRA_GETTER, object2);
            if (!ValueExistencePolicy.isNullOrEmpty(object6) || !ValueExistencePolicy.isNullOrEmpty(object3)) {
                return Utilities.deepEquals((Object)object6, (Object)object3, (ComparisonMode)comparisonMode);
            }
        }
        return true;
    }

    final void freeze(Object object) throws BackingStoreException {
        assert (this.implementation.isInstance(object)) : object;
        if (this.setters != null) {
            try {
                Object[] objectArray = new Object[1];
                Cloner cloner = new Cloner();
                for (int i = 0; i < this.allCount; ++i) {
                    Object object2;
                    Method method;
                    Object object3;
                    Method method2 = this.setters[i];
                    if (method2 == null || method2.isAnnotationPresent(Deprecated.class) || (object3 = PropertyAccessor.get(method = this.getters[i], object)) == (object2 = cloner.clone(object3))) continue;
                    objectArray[0] = object2;
                    PropertyAccessor.set(method2, object, objectArray);
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new UnsupportedOperationException(cloneNotSupportedException);
            }
        }
    }

    public int hashCode(Object object) throws BackingStoreException {
        assert (this.type.isInstance(object)) : object;
        int n = this.type.hashCode();
        for (int i = 0; i < this.standardCount; ++i) {
            Object object2 = PropertyAccessor.get(this.getters[i], object);
            if (ValueExistencePolicy.isNullOrEmpty(object2)) continue;
            n += object2.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(60);
        stringBuilder.append("PropertyAccessor[").append(this.standardCount).append(" getters");
        int n = this.allCount - this.standardCount;
        if (n != 0) {
            stringBuilder.append(" (+").append(n).append(" ext.)");
        }
        if (this.setters != null) {
            int n2 = 0;
            for (Method method : this.setters) {
                if (method == null) continue;
                ++n2;
            }
            stringBuilder.append(" & ").append(n2).append(" setters");
        }
        stringBuilder.append(" in ").append(Classes.getShortName(this.implementation));
        if (this.type != this.implementation) {
            stringBuilder.append(':').append(Classes.getShortName(this.type));
        }
        return stringBuilder.append(" from \u201c").append(Citations.getIdentifier((Citation)this.standard)).append("\u201d]").toString();
    }

    static {
        try {
            EXTRA_GETTER = IdentifiedObject.class.getMethod("getIdentifiers", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }
}

