/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Map;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.system.Semaphores;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.Pruner;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;

@XmlTransient
public abstract class AbstractMetadata
implements LenientComparable,
Emptiable {
    protected static final Logger LOGGER = Logging.getLogger(AbstractMetadata.class);

    protected AbstractMetadata() {
    }

    public abstract MetadataStandard getStandard();

    public Class<?> getInterface() {
        return this.getStandard().getInterface(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean bl = Semaphores.queryAndSet((byte)4);
        try {
            boolean bl2 = Pruner.isEmpty(this, true, false);
            return bl2;
        }
        finally {
            if (!bl) {
                Semaphores.clear((byte)4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune() {
        boolean bl = Semaphores.queryAndSet((byte)4);
        try {
            Pruner.isEmpty(this, true, true);
        }
        finally {
            if (!bl) {
                Semaphores.clear((byte)4);
            }
        }
    }

    public Map<String, Object> asMap() {
        return this.getStandard().asValueMap(this, KeyNamePolicy.JAVABEANS_PROPERTY, ValueExistencePolicy.NON_EMPTY);
    }

    public TreeTable asTreeTable() {
        return this.getStandard().asTreeTable(this, ValueExistencePolicy.NON_EMPTY);
    }

    public boolean equals(Object object, ComparisonMode comparisonMode) {
        return this.getStandard().equals(this, object, comparisonMode);
    }

    public final boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public int hashCode() {
        return this.getStandard().hashCode(this);
    }

    public String toString() {
        return this.asTreeTable().toString();
    }
}

