/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.Console;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.io.wkt.UnformattableObjectException;
import org.apache.sis.util.ArgumentChecks;

@XmlTransient
public abstract class FormattableObject {
    private static final AtomicReference<Formatter> FORMATTER = new AtomicReference();

    protected FormattableObject() {
    }

    public String toWKT() throws UnformattableObjectException {
        return this.formatWKT(Convention.DEFAULT, false, true);
    }

    public String toString() {
        return this.formatWKT(Convention.WKT2_SIMPLIFIED, false, false);
    }

    public String toString(Convention convention) {
        ArgumentChecks.ensureNonNull((String)"convention", (Object)((Object)convention));
        return this.formatWKT(convention, false, false);
    }

    public void print() {
        Console console = System.console();
        PrintWriter printWriter = console != null ? console.writer() : null;
        String string = this.formatWKT(Convention.WKT2_SIMPLIFIED, printWriter != null && X364.isAnsiSupported(), false);
        if (printWriter != null) {
            printWriter.println(string);
        } else {
            System.out.println(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String formatWKT(Convention convention, boolean bl, boolean bl2) throws UnformattableObjectException {
        String string;
        Formatter formatter = FORMATTER.getAndSet(null);
        if (formatter == null) {
            formatter = new Formatter();
        }
        formatter.configure(convention, null, bl ? Colors.DEFAULT : null, convention.majorVersion() == 1, (byte)2);
        try {
            String string2;
            formatter.append(this);
            if (bl2 && (string2 = formatter.getErrorMessage()) != null) {
                throw new UnformattableObjectException(string2, formatter.getErrorCause());
            }
            string = formatter.toWKT();
        }
        finally {
            formatter.clear();
        }
        FORMATTER.set(formatter);
        return string;
    }

    protected abstract String formatTo(Formatter var1);
}

