/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.truetype;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.ByteArrayTableBuilder;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;

public final class ControlValueTable
extends Table {
    protected ControlValueTable(Header header, ReadableFontData data) {
        super(header, data);
    }

    public int fword(int index) {
        return this.data.readFWord(index);
    }

    public int fwordCount() {
        return this.dataLength() / FontData.DataSize.FWORD.size();
    }

    public static class Builder
    extends ByteArrayTableBuilder<ControlValueTable> {
        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        @Override
        protected ControlValueTable subBuildTable(ReadableFontData data) {
            return new ControlValueTable(this.header(), data);
        }
    }
}

