/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.BitmapGlyphInfo;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;
import com.google.typography.font.sfntly.table.bitmap.IndexSubTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class IndexSubTableFormat3
extends IndexSubTable {
    private IndexSubTableFormat3(ReadableFontData data, int firstGlyphIndex, int lastGlyphIndex) {
        super(data, firstGlyphIndex, lastGlyphIndex);
    }

    @Override
    public int numGlyphs() {
        return this.lastGlyphIndex() - this.firstGlyphIndex() + 1;
    }

    @Override
    public int glyphStartOffset(int glyphId) {
        int loca = this.checkGlyphRange(glyphId);
        return this.loca(loca);
    }

    @Override
    public int glyphLength(int glyphId) {
        int loca = this.checkGlyphRange(glyphId);
        return this.loca(loca + 1) - this.loca(loca);
    }

    private int loca(int loca) {
        int readLocation = EblcTable.Offset.indexSubTable3_offsetArray.offset + loca * FontData.DataSize.USHORT.size();
        int readOffset = this.data.readUShort(EblcTable.Offset.indexSubTable3_offsetArray.offset + loca * FontData.DataSize.USHORT.size());
        return readOffset;
    }

    public static final class Builder
    extends IndexSubTable.Builder<IndexSubTableFormat3> {
        private List<Integer> offsetArray;

        public static Builder createBuilder() {
            return new Builder();
        }

        static Builder createBuilder(ReadableFontData data, int indexSubTableOffset, int firstGlyphIndex, int lastGlyphIndex) {
            int length = Builder.dataLength(data, indexSubTableOffset, firstGlyphIndex, lastGlyphIndex);
            return new Builder(data.slice(indexSubTableOffset, length), firstGlyphIndex, lastGlyphIndex);
        }

        static Builder createBuilder(WritableFontData data, int indexSubTableOffset, int firstGlyphIndex, int lastGlyphIndex) {
            int length = Builder.dataLength(data, indexSubTableOffset, firstGlyphIndex, lastGlyphIndex);
            return new Builder(data.slice(indexSubTableOffset, length), firstGlyphIndex, lastGlyphIndex);
        }

        private static int dataLength(ReadableFontData data, int indexSubTableOffset, int firstGlyphIndex, int lastGlyphIndex) {
            return EblcTable.Offset.indexSubHeaderLength.offset + (lastGlyphIndex - firstGlyphIndex + 1 + 1) * FontData.DataSize.USHORT.size();
        }

        private Builder() {
            super(EblcTable.Offset.indexSubTable3_builderDataSize.offset, 3);
        }

        private Builder(WritableFontData data, int firstGlyphIndex, int lastGlyphIndex) {
            super(data, firstGlyphIndex, lastGlyphIndex);
        }

        private Builder(ReadableFontData data, int firstGlyphIndex, int lastGlyphIndex) {
            super(data, firstGlyphIndex, lastGlyphIndex);
        }

        @Override
        public int numGlyphs() {
            return this.getOffsetArray().size() - 1;
        }

        @Override
        public int glyphLength(int glyphId) {
            int loca = this.checkGlyphRange(glyphId);
            List<Integer> offsetArray = this.getOffsetArray();
            return offsetArray.get(loca + 1) - offsetArray.get(loca);
        }

        @Override
        public int glyphStartOffset(int glyphId) {
            int loca = this.checkGlyphRange(glyphId);
            List<Integer> offsetArray = this.getOffsetArray();
            return offsetArray.get(loca);
        }

        public List<Integer> offsetArray() {
            return this.getOffsetArray();
        }

        private List<Integer> getOffsetArray() {
            if (this.offsetArray == null) {
                this.initialize(super.internalReadData());
                super.setModelChanged();
            }
            return this.offsetArray;
        }

        private void initialize(ReadableFontData data) {
            if (this.offsetArray == null) {
                this.offsetArray = new ArrayList<Integer>();
            } else {
                this.offsetArray.clear();
            }
            if (data != null) {
                int numOffsets = this.lastGlyphIndex() - this.firstGlyphIndex() + 1 + 1;
                for (int i = 0; i < numOffsets; ++i) {
                    this.offsetArray.add(data.readUShort(EblcTable.Offset.indexSubTable3_offsetArray.offset + i * FontData.DataSize.USHORT.size()));
                }
            }
        }

        public void setOffsetArray(List<Integer> array) {
            this.offsetArray = array;
            this.setModelChanged();
        }

        @Override
        Iterator<BitmapGlyphInfo> iterator() {
            return new BitmapGlyphInfoIterator();
        }

        @Override
        protected void revert() {
            super.revert();
            this.offsetArray = null;
        }

        @Override
        protected IndexSubTableFormat3 subBuildTable(ReadableFontData data) {
            return new IndexSubTableFormat3(data, this.firstGlyphIndex(), this.lastGlyphIndex());
        }

        @Override
        protected void subDataSet() {
            this.revert();
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.offsetArray == null) {
                return this.internalReadData().length();
            }
            return EblcTable.Offset.indexSubHeaderLength.offset + this.offsetArray.size() * FontData.DataSize.ULONG.size();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.offsetArray != null;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            int size = super.serializeIndexSubHeader(newData);
            if (!this.modelChanged()) {
                size += this.internalReadData().slice(EblcTable.Offset.indexSubTable3_offsetArray.offset).copyTo(newData.slice(EblcTable.Offset.indexSubTable3_offsetArray.offset));
            } else {
                for (Integer loca : this.offsetArray) {
                    size += newData.writeUShort(size, loca);
                }
            }
            return size;
        }

        private class BitmapGlyphInfoIterator
        implements Iterator<BitmapGlyphInfo> {
            private int glyphId;

            public BitmapGlyphInfoIterator() {
                this.glyphId = Builder.this.firstGlyphIndex();
            }

            @Override
            public boolean hasNext() {
                return this.glyphId <= Builder.this.lastGlyphIndex();
            }

            @Override
            public BitmapGlyphInfo next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more characters to iterate.");
                }
                BitmapGlyphInfo info = new BitmapGlyphInfo(this.glyphId, Builder.this.imageDataOffset(), Builder.this.glyphStartOffset(this.glyphId), Builder.this.glyphLength(this.glyphId), Builder.this.imageFormat());
                ++this.glyphId;
                return info;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unable to remove a glyph info.");
            }
        }
    }
}

