/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.FontData;
import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.SubTable;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.bitmap.EblcTable;

public class EbscTable
extends Table {
    private EbscTable(Header header, ReadableFontData data) {
        super(header, data);
    }

    public int version() {
        return this.data.readFixed(Offset.version.offset);
    }

    public int numSizes() {
        return this.data.readULongAsInt(Offset.numSizes.offset);
    }

    public BitmapScaleTable bitmapScaleTable(int index) {
        if (index < 0 || index > this.numSizes() - 1) {
            throw new IndexOutOfBoundsException("BitmapScaleTable index is outside the bounds of available tables.");
        }
        return new BitmapScaleTable(this.data, Offset.bitmapScaleTableStart.offset + index * Offset.bitmapScaleTableLength.offset);
    }

    public static class Builder
    extends Table.Builder<EbscTable> {
        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        @Override
        protected EbscTable subBuildTable(ReadableFontData data) {
            return new EbscTable(this.header(), data);
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return 0;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return false;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            return 0;
        }
    }

    public static class BitmapScaleTable
    extends SubTable {
        protected BitmapScaleTable(ReadableFontData data, int offset) {
            super(data, offset, Offset.bitmapScaleTableLength.offset);
        }

        public int ppemX() {
            return this.data.readByte(Offset.bitmapScaleTable_ppemX.offset);
        }

        public int ppemY() {
            return this.data.readByte(Offset.bitmapScaleTable_ppemY.offset);
        }

        public int substitutePpemX() {
            return this.data.readByte(Offset.bitmapScaleTable_substitutePpemX.offset);
        }

        public int substitutePpemY() {
            return this.data.readByte(Offset.bitmapScaleTable_substitutePpemY.offset);
        }
    }

    static enum Offset {
        version(0),
        numSizes(FontData.DataSize.Fixed.size()),
        headerLength(Offset.numSizes.offset + FontData.DataSize.ULONG.size()),
        bitmapScaleTableStart(Offset.headerLength.offset),
        bitmapScaleTable_hori(0),
        bitmapScaleTable_vert(EblcTable.Offset.sbitLineMetricsLength.offset),
        bitmapScaleTable_ppemX(Offset.bitmapScaleTable_vert.offset + EblcTable.Offset.sbitLineMetricsLength.offset),
        bitmapScaleTable_ppemY(Offset.bitmapScaleTable_ppemX.offset + FontData.DataSize.BYTE.size()),
        bitmapScaleTable_substitutePpemX(Offset.bitmapScaleTable_ppemY.offset + FontData.DataSize.BYTE.size()),
        bitmapScaleTable_substitutePpemY(Offset.bitmapScaleTable_substitutePpemX.offset + FontData.DataSize.BYTE.size()),
        bitmapScaleTableLength(Offset.bitmapScaleTable_substitutePpemY.offset + FontData.DataSize.BYTE.size());

        final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

