/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.sample.sflint;

import com.google.typography.font.sfntly.Font;
import com.google.typography.font.sfntly.FontFactory;
import com.google.typography.font.sfntly.Tag;
import com.google.typography.font.sfntly.table.core.HorizontalHeaderTable;
import com.google.typography.font.sfntly.table.core.HorizontalMetricsTable;
import com.google.typography.font.sfntly.table.core.NameTable;
import com.google.typography.font.sfntly.table.core.OS2Table;
import com.google.typography.font.sfntly.table.truetype.CompositeGlyph;
import com.google.typography.font.sfntly.table.truetype.Glyph;
import com.google.typography.font.sfntly.table.truetype.GlyphTable;
import com.google.typography.font.sfntly.table.truetype.LocaTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class SFLint {
    private FontFactory fontFactory = FontFactory.getInstance();
    private int problemCount;

    public static void main(String[] args) throws IOException {
        SFLint dumper = new SFLint();
        File fontFile = null;
        for (int i = 0; i < args.length; ++i) {
            String option = null;
            if (args[i].charAt(0) == '-') {
                option = args[i].substring(1);
            }
            if (option != null) {
                if (!option.equals("h") && !option.equals("help") && !option.equals("?")) continue;
                SFLint.printUsage();
                System.exit(0);
                continue;
            }
            fontFile = new File(args[i]);
            break;
        }
        if (fontFile != null) {
            dumper.lintFontFile(fontFile);
        }
    }

    private static final void printUsage() {
        System.out.println("SFLint [-?|-h|-help] fontfile");
        System.out.println("find problems with the font file");
        System.out.println("\t-?,-h,-help\tprint this help information");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lintFontFile(File fontFile) throws IOException {
        FileInputStream fis = null;
        try {
            Font[] fontArray;
            fis = new FileInputStream(fontFile);
            for (Font font : fontArray = this.fontFactory.loadFonts(fis)) {
                this.lintFont(font);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    private void lintNameTable(Font font) {
        NameTable name = (NameTable)font.getTable(Tag.name);
        for (NameTable.NameEntry entry : name) {
            if (entry.nameId() != NameTable.NameId.FontFamilyName.value()) continue;
            for (NameTable.NameEntry entry2 : name) {
                if (entry2.nameId() != NameTable.NameId.FullFontName.value() || entry.platformId() != entry2.platformId() || entry.encodingId() != entry2.encodingId() || entry.languageId() != entry2.languageId() || entry2.name().startsWith(entry.name())) continue;
                this.reportProblem("Full font name doesn't begin with family name: FontFamilyName = " + entry.name() + "; FullFontName = " + entry2.name());
            }
        }
    }

    private void lintWindowsClipping(Font font) {
        LocaTable loca = (LocaTable)font.getTable(Tag.loca);
        int nGlyphs = loca.numGlyphs();
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        int bbox_xMin = 0;
        int bbox_yMin = 0;
        int bbox_xMax = 0;
        int bbox_yMax = 0;
        for (int glyphId = 0; glyphId < nGlyphs; ++glyphId) {
            int length;
            int offset = loca.glyphOffset(glyphId);
            Glyph glyph = glyphTable.glyph(offset, length = loca.glyphLength(glyphId));
            if (glyph == null || glyph.numberOfContours() == 0) continue;
            int xMin = glyph.xMin();
            int yMin = glyph.yMin();
            int xMax = glyph.xMax();
            int yMax = glyph.yMax();
            if (glyphId == 0 || xMin < bbox_xMin) {
                bbox_xMin = xMin;
            }
            if (glyphId == 0 || yMin < bbox_yMin) {
                bbox_yMin = yMin;
            }
            if (glyphId == 0 || xMax > bbox_xMax) {
                bbox_xMax = xMax;
            }
            if (glyphId != 0 && yMax <= bbox_yMax) continue;
            bbox_yMax = yMax;
        }
        OS2Table os2 = (OS2Table)font.getTable(Tag.OS_2);
        if (os2.usWinAscent() < bbox_yMax) {
            this.reportProblem("font is clipped on top by " + (bbox_yMax - os2.usWinAscent()) + " units");
        }
        if (os2.usWinDescent() < -bbox_yMin) {
            this.reportProblem("font is clipped on bottom by " + (-bbox_yMin - os2.usWinDescent()) + " units");
        }
    }

    private void lintAdvanceWidths(Font font) {
        int maxAdvanceWidth = 0;
        HorizontalMetricsTable hmtx = (HorizontalMetricsTable)font.getTable(Tag.hmtx);
        for (int i = 0; i < hmtx.numberOfHMetrics(); ++i) {
            int advanceWidth = hmtx.hMetricAdvanceWidth(i);
            if (i != 0 && advanceWidth <= maxAdvanceWidth) continue;
            maxAdvanceWidth = advanceWidth;
        }
        HorizontalHeaderTable hhea = (HorizontalHeaderTable)font.getTable(Tag.hhea);
        int hheaMax = hhea.advanceWidthMax();
        if (maxAdvanceWidth != hhea.advanceWidthMax()) {
            this.reportProblem("advanceWidthMax mismatch, expected " + maxAdvanceWidth + " got " + hheaMax);
        }
    }

    private void lintCompositeGlyph(Font font, CompositeGlyph glyph, int glyphId) {
        int VAR_FLAGS = 200;
        int MASK = -801;
        for (int i = 0; i < glyph.numGlyphs(); ++i) {
            if ((glyph.flags(i) & 0xC8) != 0) continue;
            for (int j = 0; j < i; ++j) {
                if ((glyph.flags(i) & 0xFFFFFCDF) != (glyph.flags(j) & 0xFFFFFCDF) || glyph.glyphIndex(i) != glyph.glyphIndex(j) || glyph.argument1(i) != glyph.argument1(j) || glyph.argument2(i) != glyph.argument2(j)) continue;
                this.reportProblem("glyph " + glyphId + " contains duplicate references");
            }
        }
    }

    private void lintAllGlyphs(Font font) {
        LocaTable loca = (LocaTable)font.getTable(Tag.loca);
        GlyphTable glyphTable = (GlyphTable)font.getTable(Tag.glyf);
        int nGlyphs = loca.numGlyphs();
        for (int glyphId = 0; glyphId < nGlyphs; ++glyphId) {
            int length;
            int offset = loca.glyphOffset(glyphId);
            Glyph glyph = glyphTable.glyph(offset, length = loca.glyphLength(glyphId));
            if (glyph == null || glyph.glyphType() != Glyph.GlyphType.Composite) continue;
            this.lintCompositeGlyph(font, (CompositeGlyph)glyph, glyphId);
        }
    }

    private void lintOS2Misc(Font font) {
        int weightClass;
        OS2Table os2 = (OS2Table)font.getTable(Tag.OS_2);
        int widthClass = os2.usWidthClass();
        if (widthClass < 1 || widthClass > 9) {
            this.reportProblem("widthClass must be [1..9] inclusive, was " + widthClass + "; IE9 fail");
        }
        if ((weightClass = os2.usWeightClass()) < 100 || weightClass > 900) {
            this.reportProblem("weightClass must be [100..900] inclusive, was " + weightClass);
        } else if (weightClass % 100 != 0) {
            this.reportProblem("weightClass must be multiple of 100, was " + weightClass);
        }
    }

    private void lintFont(Font font) {
        this.problemCount = 0;
        this.lintNameTable(font);
        this.lintWindowsClipping(font);
        this.lintAdvanceWidths(font);
        this.lintAllGlyphs(font);
        this.lintOS2Misc(font);
        if (this.problemCount == 0) {
            System.out.println("No problems found");
        }
    }

    private void reportProblem(String string) {
        ++this.problemCount;
        System.out.println(string);
    }
}

