/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel.contrib;

import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class HSSFCellUtil {
    public static final String ALIGNMENT = "alignment";
    public static final String BORDER_BOTTOM = "borderBottom";
    public static final String BORDER_LEFT = "borderLeft";
    public static final String BORDER_RIGHT = "borderRight";
    public static final String BORDER_TOP = "borderTop";
    public static final String BOTTOM_BORDER_COLOR = "bottomBorderColor";
    public static final String DATA_FORMAT = "dataFormat";
    public static final String FILL_BACKGROUND_COLOR = "fillBackgroundColor";
    public static final String FILL_FOREGROUND_COLOR = "fillForegroundColor";
    public static final String FILL_PATTERN = "fillPattern";
    public static final String FONT = "font";
    public static final String HIDDEN = "hidden";
    public static final String INDENTION = "indention";
    public static final String LEFT_BORDER_COLOR = "leftBorderColor";
    public static final String LOCKED = "locked";
    public static final String RIGHT_BORDER_COLOR = "rightBorderColor";
    public static final String ROTATION = "rotation";
    public static final String TOP_BORDER_COLOR = "topBorderColor";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String WRAP_TEXT = "wrapText";
    private static UnicodeMapping[] unicodeMappings = new UnicodeMapping[]{HSSFCellUtil.um("alpha", "\u03b1"), HSSFCellUtil.um("beta", "\u03b2"), HSSFCellUtil.um("gamma", "\u03b3"), HSSFCellUtil.um("delta", "\u03b4"), HSSFCellUtil.um("epsilon", "\u03b5"), HSSFCellUtil.um("zeta", "\u03b6"), HSSFCellUtil.um("eta", "\u03b7"), HSSFCellUtil.um("theta", "\u03b8"), HSSFCellUtil.um("iota", "\u03b9"), HSSFCellUtil.um("kappa", "\u03ba"), HSSFCellUtil.um("lambda", "\u03bb"), HSSFCellUtil.um("mu", "\u03bc"), HSSFCellUtil.um("nu", "\u03bd"), HSSFCellUtil.um("xi", "\u03be"), HSSFCellUtil.um("omicron", "\u03bf")};

    private HSSFCellUtil() {
    }

    public static HSSFRow getRow(int rowCounter, HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(rowCounter);
        if (row == null) {
            row = sheet.createRow(rowCounter);
        }
        return row;
    }

    public static HSSFCell getCell(HSSFRow row, int column) {
        HSSFCell cell = row.getCell(column);
        if (cell == null) {
            cell = row.createCell(column);
        }
        return cell;
    }

    public static HSSFCell createCell(HSSFRow row, int column, String value, HSSFCellStyle style) {
        HSSFCell cell = HSSFCellUtil.getCell(row, column);
        cell.setCellValue(new HSSFRichTextString(value));
        if (style != null) {
            cell.setCellStyle(style);
        }
        return cell;
    }

    public static HSSFCell createCell(HSSFRow row, int column, String value) {
        return HSSFCellUtil.createCell(row, column, value, null);
    }

    public static void setAlignment(HSSFCell cell, HSSFWorkbook workbook, short align) {
        HSSFCellUtil.setCellStyleProperty(cell, workbook, ALIGNMENT, new Short(align));
    }

    public static void setFont(HSSFCell cell, HSSFWorkbook workbook, HSSFFont font) {
        HSSFCellUtil.setCellStyleProperty(cell, workbook, FONT, font);
    }

    public static void setCellStyleProperty(HSSFCell cell, HSSFWorkbook workbook, String propertyName, Object propertyValue) {
        HSSFCellStyle originalStyle = cell.getCellStyle();
        HSSFCellStyle newStyle = null;
        Map values = HSSFCellUtil.getFormatProperties(originalStyle);
        values.put(propertyName, propertyValue);
        short numberCellStyles = workbook.getNumCellStyles();
        for (short i = 0; i < numberCellStyles; i = (short)(i + 1)) {
            HSSFCellStyle wbStyle = workbook.getCellStyleAt(i);
            Map wbStyleMap = HSSFCellUtil.getFormatProperties(wbStyle);
            if (!((Object)wbStyleMap).equals(values)) continue;
            newStyle = wbStyle;
            break;
        }
        if (newStyle == null) {
            newStyle = workbook.createCellStyle();
            HSSFCellUtil.setFormatProperties(newStyle, workbook, values);
        }
        cell.setCellStyle(newStyle);
    }

    private static Map getFormatProperties(HSSFCellStyle style) {
        HashMap properties = new HashMap();
        HSSFCellUtil.putShort(properties, ALIGNMENT, style.getAlignment());
        HSSFCellUtil.putShort(properties, BORDER_BOTTOM, style.getBorderBottom());
        HSSFCellUtil.putShort(properties, BORDER_LEFT, style.getBorderLeft());
        HSSFCellUtil.putShort(properties, BORDER_RIGHT, style.getBorderRight());
        HSSFCellUtil.putShort(properties, BORDER_TOP, style.getBorderTop());
        HSSFCellUtil.putShort(properties, BOTTOM_BORDER_COLOR, style.getBottomBorderColor());
        HSSFCellUtil.putShort(properties, DATA_FORMAT, style.getDataFormat());
        HSSFCellUtil.putShort(properties, FILL_BACKGROUND_COLOR, style.getFillBackgroundColor());
        HSSFCellUtil.putShort(properties, FILL_FOREGROUND_COLOR, style.getFillForegroundColor());
        HSSFCellUtil.putShort(properties, FILL_PATTERN, style.getFillPattern());
        HSSFCellUtil.putShort(properties, FONT, style.getFontIndex());
        HSSFCellUtil.putBoolean(properties, HIDDEN, style.getHidden());
        HSSFCellUtil.putShort(properties, INDENTION, style.getIndention());
        HSSFCellUtil.putShort(properties, LEFT_BORDER_COLOR, style.getLeftBorderColor());
        HSSFCellUtil.putBoolean(properties, LOCKED, style.getLocked());
        HSSFCellUtil.putShort(properties, RIGHT_BORDER_COLOR, style.getRightBorderColor());
        HSSFCellUtil.putShort(properties, ROTATION, style.getRotation());
        HSSFCellUtil.putShort(properties, TOP_BORDER_COLOR, style.getTopBorderColor());
        HSSFCellUtil.putShort(properties, VERTICAL_ALIGNMENT, style.getVerticalAlignment());
        HSSFCellUtil.putBoolean(properties, WRAP_TEXT, style.getWrapText());
        return properties;
    }

    private static void setFormatProperties(HSSFCellStyle style, HSSFWorkbook workbook, Map properties) {
        style.setAlignment(HSSFCellUtil.getShort(properties, ALIGNMENT));
        style.setBorderBottom(HSSFCellUtil.getShort(properties, BORDER_BOTTOM));
        style.setBorderLeft(HSSFCellUtil.getShort(properties, BORDER_LEFT));
        style.setBorderRight(HSSFCellUtil.getShort(properties, BORDER_RIGHT));
        style.setBorderTop(HSSFCellUtil.getShort(properties, BORDER_TOP));
        style.setBottomBorderColor(HSSFCellUtil.getShort(properties, BOTTOM_BORDER_COLOR));
        style.setDataFormat(HSSFCellUtil.getShort(properties, DATA_FORMAT));
        style.setFillBackgroundColor(HSSFCellUtil.getShort(properties, FILL_BACKGROUND_COLOR));
        style.setFillForegroundColor(HSSFCellUtil.getShort(properties, FILL_FOREGROUND_COLOR));
        style.setFillPattern(HSSFCellUtil.getShort(properties, FILL_PATTERN));
        style.setFont(workbook.getFontAt(HSSFCellUtil.getShort(properties, FONT)));
        style.setHidden(HSSFCellUtil.getBoolean(properties, HIDDEN));
        style.setIndention(HSSFCellUtil.getShort(properties, INDENTION));
        style.setLeftBorderColor(HSSFCellUtil.getShort(properties, LEFT_BORDER_COLOR));
        style.setLocked(HSSFCellUtil.getBoolean(properties, LOCKED));
        style.setRightBorderColor(HSSFCellUtil.getShort(properties, RIGHT_BORDER_COLOR));
        style.setRotation(HSSFCellUtil.getShort(properties, ROTATION));
        style.setTopBorderColor(HSSFCellUtil.getShort(properties, TOP_BORDER_COLOR));
        style.setVerticalAlignment(HSSFCellUtil.getShort(properties, VERTICAL_ALIGNMENT));
        style.setWrapText(HSSFCellUtil.getBoolean(properties, WRAP_TEXT));
    }

    private static short getShort(Map properties, String name) {
        Object value = properties.get(name);
        if (value instanceof Short) {
            return (Short)value;
        }
        return 0;
    }

    private static boolean getBoolean(Map properties, String name) {
        Object value = properties.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    private static void putShort(Map properties, String name, short value) {
        properties.put(name, new Short(value));
    }

    private static void putBoolean(Map properties, String name, boolean value) {
        properties.put(name, new Boolean(value));
    }

    public static HSSFCell translateUnicodeValues(HSSFCell cell) {
        String s = cell.getRichStringCellValue().getString();
        boolean foundUnicode = false;
        String lowerCaseStr = s.toLowerCase();
        for (int i = 0; i < unicodeMappings.length; ++i) {
            UnicodeMapping entry = unicodeMappings[i];
            String key = entry.entityName;
            if (lowerCaseStr.indexOf(key) == -1) continue;
            s = s.replaceAll(key, entry.resolvedValue);
            foundUnicode = true;
        }
        if (foundUnicode) {
            cell.setCellValue(new HSSFRichTextString(s));
        }
        return cell;
    }

    private static UnicodeMapping um(String entityName, String resolvedValue) {
        return new UnicodeMapping(entityName, resolvedValue);
    }

    private static final class UnicodeMapping {
        public final String entityName;
        public final String resolvedValue;

        public UnicodeMapping(String pEntityName, String pResolvedValue) {
            this.entityName = "&" + pEntityName + ";";
            this.resolvedValue = pResolvedValue;
        }
    }
}

