/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.defaults;

import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.session.Configuration;
import org.w3c.dom.NodeList;

public class RawLanguageDriver
implements LanguageDriver {
    @Override
    public ParameterHandler createParameterHandler(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        return new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
    }

    @Override
    public SqlSource createSqlSource(Configuration configuration, XNode script, Class<?> parameterType) {
        StringBuilder contents = new StringBuilder();
        NodeList children = script.getNode().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XNode child = script.newXNode(children.item(i));
            if (child.getNode().getNodeType() != 4 && child.getNode().getNodeType() != 3) continue;
            String data = child.getStringBody("");
            contents.append(data);
        }
        return new RawSqlSource(configuration, contents.toString(), parameterType);
    }

    @Override
    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        return new RawSqlSource(configuration, script, parameterType);
    }
}

