/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.xmp;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.impl.XMPDateTimeImpl;
import com.adobe.xmp.impl.XMPMetaImpl;
import com.adobe.xmp.options.PropertyOptions;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.xmp.XmpDescriptor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmpDirectory
extends Directory {
    public static final int TAG_XMP_VALUE_COUNT = 65535;
    public static final int TAG_MAKE = 1;
    public static final int TAG_MODEL = 2;
    public static final int TAG_EXPOSURE_TIME = 3;
    public static final int TAG_SHUTTER_SPEED = 4;
    public static final int TAG_F_NUMBER = 5;
    public static final int TAG_LENS_INFO = 6;
    public static final int TAG_LENS = 7;
    public static final int TAG_CAMERA_SERIAL_NUMBER = 8;
    public static final int TAG_FIRMWARE = 9;
    public static final int TAG_FOCAL_LENGTH = 10;
    public static final int TAG_APERTURE_VALUE = 11;
    public static final int TAG_EXPOSURE_PROGRAM = 12;
    public static final int TAG_DATETIME_ORIGINAL = 13;
    public static final int TAG_DATETIME_DIGITIZED = 14;
    public static final int TAG_RATING = 4097;
    public static final int TAG_LABEL = 8192;
    public static int TAG_SUBJECT = 8193;
    @NotNull
    protected static final HashMap<Integer, String> _tagNameMap = new HashMap();
    @NotNull
    protected static final HashMap<Integer, String> _tagSchemaMap = new HashMap();
    @NotNull
    protected static final HashMap<Integer, String> _tagPropNameMap = new HashMap();
    @NotNull
    private final Map<String, String> _propertyValueByPath = new HashMap<String, String>();
    @Nullable
    private XMPMeta _xmpMeta;

    public XmpDirectory() {
        this.setDescriptor(new XmpDescriptor(this));
    }

    @Override
    @NotNull
    public String getName() {
        return "Xmp";
    }

    @Override
    @NotNull
    protected HashMap<Integer, String> getTagNameMap() {
        return _tagNameMap;
    }

    void addProperty(@NotNull String path, @NotNull String value) {
        this._propertyValueByPath.put(path, value);
    }

    @NotNull
    public Map<String, String> getXmpProperties() {
        return Collections.unmodifiableMap(this._propertyValueByPath);
    }

    public void setXMPMeta(@NotNull XMPMeta xmpMeta) {
        this._xmpMeta = xmpMeta;
        try {
            int valueCount = 0;
            for (XMPPropertyInfo prop : this._xmpMeta) {
                if (prop.getPath() == null) continue;
                ++valueCount;
            }
            this.setInt(65535, valueCount);
        }
        catch (XMPException xMPException) {
            // empty catch block
        }
    }

    @Nullable
    public XMPMeta getXMPMeta() {
        if (this._xmpMeta == null) {
            this._xmpMeta = new XMPMetaImpl();
        }
        return this._xmpMeta;
    }

    public void updateInt(int tagType, int value) {
        super.setInt(tagType, value);
        try {
            this.getXMPMeta().setPropertyInteger(_tagSchemaMap.get(tagType), _tagPropNameMap.get(tagType), value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void updateIntArray(int tagType, int[] ints) {
        super.setIntArray(tagType, ints);
        try {
            String schemaNS = _tagSchemaMap.get(tagType);
            String propName = _tagPropNameMap.get(tagType);
            this.getXMPMeta().deleteProperty(schemaNS, propName);
            PropertyOptions po = new PropertyOptions().setArray(true);
            for (int item : ints) {
                this.getXMPMeta().appendArrayItem(schemaNS, propName, po, String.valueOf(item), null);
            }
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void updateFloat(int tagType, float value) {
        super.setFloat(tagType, value);
        try {
            this.getXMPMeta().setPropertyDouble(_tagSchemaMap.get(tagType), _tagPropNameMap.get(tagType), (double)value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void updateFloatArray(int tagType, float[] floats) {
        super.setFloatArray(tagType, floats);
        try {
            String schemaNS = _tagSchemaMap.get(tagType);
            String propName = _tagPropNameMap.get(tagType);
            this.getXMPMeta().deleteProperty(schemaNS, propName);
            PropertyOptions po = new PropertyOptions().setArray(true);
            for (float item : floats) {
                this.getXMPMeta().appendArrayItem(schemaNS, propName, po, String.valueOf(item), null);
            }
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void updateDouble(int tagType, double value) {
        super.setDouble(tagType, value);
        try {
            this.getXMPMeta().setPropertyDouble(_tagSchemaMap.get(tagType), _tagPropNameMap.get(tagType), value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void updateDoubleArray(int tagType, double[] doubles) {
        super.setDoubleArray(tagType, doubles);
        try {
            String schemaNS = _tagSchemaMap.get(tagType);
            String propName = _tagPropNameMap.get(tagType);
            this.getXMPMeta().deleteProperty(schemaNS, propName);
            PropertyOptions po = new PropertyOptions().setArray(true);
            for (double item : doubles) {
                this.getXMPMeta().appendArrayItem(schemaNS, propName, po, String.valueOf(item), null);
            }
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void updateString(int tagType, String value) {
        super.setString(tagType, value);
        try {
            this.getXMPMeta().setProperty(_tagSchemaMap.get(tagType), _tagPropNameMap.get(tagType), (Object)value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void deleteProperty(int tagType) {
        this.getXMPMeta().deleteProperty(_tagSchemaMap.get(tagType), _tagPropNameMap.get(tagType));
    }

    public void updateStringArray(int tagType, String[] strings) {
        super.setStringArray(tagType, strings);
        try {
            String schemaNS = _tagSchemaMap.get(tagType);
            String propName = _tagPropNameMap.get(tagType);
            this.getXMPMeta().deleteProperty(schemaNS, propName);
            PropertyOptions po = new PropertyOptions().setArray(true);
            for (String item : strings) {
                this.getXMPMeta().appendArrayItem(schemaNS, propName, po, item, null);
            }
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void updateBoolean(int tagType, boolean value) {
        super.setBoolean(tagType, value);
        try {
            this.getXMPMeta().setPropertyBoolean(_tagSchemaMap.get(tagType), _tagPropNameMap.get(tagType), value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void updateLong(int tagType, long value) {
        super.setLong(tagType, value);
        try {
            this.getXMPMeta().setPropertyLong(_tagSchemaMap.get(tagType), _tagPropNameMap.get(tagType), value);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    public void updateDate(int tagType, Date value) {
        super.setDate(tagType, value);
        XMPDateTimeImpl date = new XMPDateTimeImpl(value, TimeZone.getDefault());
        try {
            this.getXMPMeta().setPropertyDate(_tagSchemaMap.get(tagType), _tagPropNameMap.get(tagType), (XMPDateTime)date);
        }
        catch (XMPException e) {
            e.printStackTrace();
        }
    }

    static {
        _tagNameMap.put(65535, "XMP Value Count");
        _tagNameMap.put(1, "Make");
        _tagNameMap.put(2, "Model");
        _tagNameMap.put(3, "Exposure Time");
        _tagNameMap.put(4, "Shutter Speed Value");
        _tagNameMap.put(5, "F-Number");
        _tagNameMap.put(6, "Lens Information");
        _tagNameMap.put(7, "Lens");
        _tagNameMap.put(8, "Serial Number");
        _tagNameMap.put(9, "Firmware");
        _tagNameMap.put(10, "Focal Length");
        _tagNameMap.put(11, "Aperture Value");
        _tagNameMap.put(12, "Exposure Program");
        _tagNameMap.put(13, "Date/Time Original");
        _tagNameMap.put(14, "Date/Time Digitized");
        _tagNameMap.put(4097, "Rating");
        _tagNameMap.put(8192, "Label");
        _tagNameMap.put(TAG_SUBJECT, "Subject");
        _tagPropNameMap.put(1, "tiff:Make");
        _tagPropNameMap.put(2, "tiff:Model");
        _tagPropNameMap.put(3, "exif:ExposureTime");
        _tagPropNameMap.put(4, "exif:ShutterSpeedValue");
        _tagPropNameMap.put(5, "exif:FNumber");
        _tagPropNameMap.put(6, "aux:LensInfo");
        _tagPropNameMap.put(7, "aux:Lens");
        _tagPropNameMap.put(8, "aux:SerialNumber");
        _tagPropNameMap.put(9, "aux:Firmware");
        _tagPropNameMap.put(10, "exif:FocalLength");
        _tagPropNameMap.put(11, "exif:ApertureValue");
        _tagPropNameMap.put(12, "exif:ExposureProgram");
        _tagPropNameMap.put(13, "exif:DateTimeOriginal");
        _tagPropNameMap.put(14, "exif:DateTimeDigitized");
        _tagPropNameMap.put(4097, "xmp:Rating");
        _tagPropNameMap.put(8192, "xmp:Label");
        _tagPropNameMap.put(TAG_SUBJECT, "dc:subject");
        _tagSchemaMap.put(1, "http://ns.adobe.com/tiff/1.0/");
        _tagSchemaMap.put(2, "http://ns.adobe.com/tiff/1.0/");
        _tagSchemaMap.put(3, "http://ns.adobe.com/exif/1.0/");
        _tagSchemaMap.put(4, "http://ns.adobe.com/exif/1.0/");
        _tagSchemaMap.put(5, "http://ns.adobe.com/exif/1.0/");
        _tagSchemaMap.put(6, "http://ns.adobe.com/exif/1.0/aux/");
        _tagSchemaMap.put(7, "http://ns.adobe.com/exif/1.0/aux/");
        _tagSchemaMap.put(8, "http://ns.adobe.com/exif/1.0/aux/");
        _tagSchemaMap.put(9, "http://ns.adobe.com/exif/1.0/aux/");
        _tagSchemaMap.put(10, "http://ns.adobe.com/exif/1.0/");
        _tagSchemaMap.put(11, "http://ns.adobe.com/exif/1.0/");
        _tagSchemaMap.put(12, "http://ns.adobe.com/exif/1.0/");
        _tagSchemaMap.put(13, "http://ns.adobe.com/exif/1.0/");
        _tagSchemaMap.put(14, "http://ns.adobe.com/exif/1.0/");
        _tagSchemaMap.put(4097, "http://ns.adobe.com/xap/1.0/");
        _tagSchemaMap.put(8192, "http://ns.adobe.com/xap/1.0/");
        _tagSchemaMap.put(TAG_SUBJECT, "http://purl.org/dc/elements/1.1/");
    }
}

