/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

abstract class AbstractAppendingLongBuffer {
    static final int MIN_PAGE_SIZE = 64;
    static final int MAX_PAGE_SIZE = 0x100000;
    final int pageShift;
    final int pageMask;
    PackedInts.Reader[] values;
    private long valuesBytes;
    int valuesOff;
    long[] pending;
    int pendingOff;
    float acceptableOverheadRatio;

    AbstractAppendingLongBuffer(int initialBlockCount, int pageSize, float acceptableOverheadRatio) {
        this.values = new PackedInts.Reader[initialBlockCount];
        this.pending = new long[pageSize];
        this.pageShift = PackedInts.checkBlockSize(pageSize, 64, 0x100000);
        this.pageMask = pageSize - 1;
        this.valuesOff = 0;
        this.pendingOff = 0;
        this.acceptableOverheadRatio = acceptableOverheadRatio;
    }

    final int pageSize() {
        return this.pageMask + 1;
    }

    public final long size() {
        long size = this.pendingOff;
        if (this.valuesOff > 0) {
            size += (long)this.values[this.valuesOff - 1].size();
        }
        if (this.valuesOff > 1) {
            size += (long)(this.valuesOff - 1) * (long)this.pageSize();
        }
        return size;
    }

    public final void add(long l) {
        if (this.pending == null) {
            throw new IllegalStateException("This buffer is frozen");
        }
        if (this.pendingOff == this.pending.length) {
            if (this.values.length == this.valuesOff) {
                int newLength = ArrayUtil.oversize(this.valuesOff + 1, 8);
                this.grow(newLength);
            }
            this.packPendingValues();
            this.valuesBytes += this.values[this.valuesOff].ramBytesUsed();
            ++this.valuesOff;
            this.pendingOff = 0;
        }
        this.pending[this.pendingOff++] = l;
    }

    void grow(int newBlockCount) {
        this.values = Arrays.copyOf(this.values, newBlockCount);
    }

    abstract void packPendingValues();

    public final long get(long index) {
        assert (index >= 0L && index < this.size());
        int block = (int)(index >> this.pageShift);
        int element = (int)(index & (long)this.pageMask);
        return this.get(block, element);
    }

    public final int get(long index, long[] arr, int off, int len) {
        assert (len > 0) : "len must be > 0 (got " + len + ")";
        assert (index >= 0L && index < this.size());
        assert (off + len <= arr.length);
        int block = (int)(index >> this.pageShift);
        int element = (int)(index & (long)this.pageMask);
        return this.get(block, element, arr, off, len);
    }

    abstract long get(int var1, int var2);

    abstract int get(int var1, int var2, long[] var3, int var4, int var5);

    public Iterator iterator() {
        return new Iterator();
    }

    long baseRamBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 8 + 8 + 4 + 8;
    }

    public long ramBytesUsed() {
        long bytesUsed = RamUsageEstimator.alignObjectSize(this.baseRamBytesUsed()) + (this.pending != null ? RamUsageEstimator.sizeOf(this.pending) : 0L) + RamUsageEstimator.alignObjectSize((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)this.values.length);
        return bytesUsed + this.valuesBytes;
    }

    public void freeze() {
        if (this.pendingOff > 0) {
            if (this.values.length == this.valuesOff) {
                this.grow(this.valuesOff + 1);
            }
            this.packPendingValues();
            this.valuesBytes += this.values[this.valuesOff].ramBytesUsed();
            ++this.valuesOff;
            this.pendingOff = 0;
        }
        this.pending = null;
    }

    public final class Iterator {
        long[] currentValues;
        int vOff = 0;
        int pOff = 0;
        int currentCount;

        Iterator() {
            if (AbstractAppendingLongBuffer.this.valuesOff == 0) {
                this.currentValues = AbstractAppendingLongBuffer.this.pending;
                this.currentCount = AbstractAppendingLongBuffer.this.pendingOff;
            } else {
                this.currentValues = new long[AbstractAppendingLongBuffer.this.values[0].size()];
                this.fillValues();
            }
        }

        void fillValues() {
            if (this.vOff == AbstractAppendingLongBuffer.this.valuesOff) {
                this.currentValues = AbstractAppendingLongBuffer.this.pending;
                this.currentCount = AbstractAppendingLongBuffer.this.pendingOff;
            } else {
                this.currentCount = AbstractAppendingLongBuffer.this.values[this.vOff].size();
                for (int k = 0; k < this.currentCount; k += AbstractAppendingLongBuffer.this.get(this.vOff, k, this.currentValues, k, this.currentCount - k)) {
                }
            }
        }

        public final boolean hasNext() {
            return this.pOff < this.currentCount;
        }

        public final long next() {
            assert (this.hasNext());
            long result = this.currentValues[this.pOff++];
            if (this.pOff == this.currentCount) {
                ++this.vOff;
                this.pOff = 0;
                if (this.vOff <= AbstractAppendingLongBuffer.this.valuesOff) {
                    this.fillValues();
                } else {
                    this.currentCount = 0;
                }
            }
            return result;
        }
    }
}

