/*
 * Decompiled with CFR 0.152.
 */
package core.log.jdbc;

import core.log.impl.ConnectionLoggable;
import core.log.logger.SL;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public abstract class DriverLoggables
implements Driver {
    private String banderDriver;
    private Driver driver = null;
    public final String ORACLE_DRIVER = "oracle.jdbc.driver.OracleDriver";
    public final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public final String SYBASE_DRIVER = "com.sybase.jdbc2.jdbc.SybDriver";
    public final String DB2_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    public final String INFOMIX_DRIVER = "com.informix.jdbc.IfxDriver";
    public final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    public final String MAXDB_DRIVER = "com.sap.dbtech.jdbc.DriverSapDB";
    public final String FRONTBASE_DRIVER = "com.frontbase.jdbc.FBJDriver";
    public final String HSQL_DRIVER = "org.hsqldb.jdbcDriver";
    public final String POINTBASE_DRIVER = "com.pointbase.jdbc.jdbcUniversalDriver";
    public final String MIMER_DRIVER = "com.mimer.jdbc.Driver";
    public final String PERVASIVE_DRIVER = "com.pervasive.jdbc.v2.Driver";
    public final String DAFFODILDB_DRIVER = "in.co.daffodil.db.jdbc.DaffodilDBDriver";
    public final String JDATASTORE_DRIVER = "com.borland.datastore.jdbc.DataStoreDriver";
    public final String CACHE_DRIVER = "com.intersys.jdbc.CacheDriver";
    public final String DERBY_DRIVER = "org.apache.derby.jdbc.ClientDriver";
    public final String ALTIBASE_DRIVER = "Altibase.jdbc.driver.AltibaseDriver";
    public final String MCKOI_DRIVER = "com.mckoi.JDBCDriver";
    public final String JSQL_DRIVER = "com.jnetdirect.jsql.JSQLDriver";
    public final String JTURBO_DRIVER = "com.newatlanta.jturbo.driver.Driver";
    public final String JTDS_DRIVER = "net.sourceforge.jtds.jdbc.Driver";
    public final String INTERCLIENT_DRIVER = "interbase.interclient.Driver";
    public final String PURE_JAVA_DRIVER = "org.firebirdsql.jdbc.FBDriver";
    public final String JDBC_ODBC_DRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
    public final String CUBRID_DRIVER = "cubrid.jdbc.driver.CUBRIDDriver";
    public final String MSSQL_2000_DRIVER = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public final String MSSQL_2005_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private boolean isAcceptable = false;

    public void setDriver(String banderDriver) {
        this.banderDriver = banderDriver;
    }

    public Driver getDriver() {
        try {
            this.driver = (Driver)Class.forName(this.banderDriver).newInstance();
        }
        catch (Throwable t) {
            SL.getInstance().logError(t);
        }
        return this.driver;
    }

    public int getMajorVersion() {
        return this.getDriver().getMajorVersion();
    }

    public int getMinorVersion() {
        return this.getDriver().getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return this.getDriver().jdbcCompliant();
    }

    public boolean acceptsURL(String url) throws SQLException {
        block3: {
            this.isAcceptable = this.getDriver().acceptsURL(url);
            try {
                if (this.isAcceptable) break block3;
                Enumeration<Driver> enumeration = DriverManager.getDrivers();
                while (enumeration.hasMoreElements()) {
                    Driver driverObject = enumeration.nextElement();
                    if (driverObject.getClass() != Class.forName(this.banderDriver)) continue;
                    DriverManager.deregisterDriver(driverObject);
                    break;
                }
            }
            catch (Throwable t) {
                SL.getInstance().logError(t);
            }
        }
        return this.isAcceptable;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        this.acceptsURL(url);
        if (!this.isAcceptable) {
            return null;
        }
        return new ConnectionLoggable(this.getDriver().connect(url, info));
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.getDriver().getPropertyInfo(url, info);
    }
}

