/*
 * Decompiled with CFR 0.152.
 */
package core.log.aop.handler;

import core.log.aop.reflection.profiler.AroundProfiler;
import core.log.conf.reloadable.ReloadableConfiguration;
import core.log.exception.InternalException;
import core.log.impl.PreparedStatementLoggable;
import core.log.logger.ConcurrentThreadPool;
import core.log.logger.LoggingQuery;
import core.log.logger.SL;
import core.log.logger.resource.LogResource;
import core.log.triggers.TriggerRegister;
import core.log.util.ApacheCommonLangTimeStopWatch;
import core.log.util.PatternCheck;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DaoInfo
extends AroundProfiler {
    private String sql;
    private PreparedStatementLoggable preparedStatementLoggable;
    private ConcurrentThreadPool concurentThreadPool = ConcurrentThreadPool.getInstance();

    public DaoInfo(Connection connection) throws SQLException {
        this.preparedStatementLoggable = new PreparedStatementLoggable(connection);
    }

    public DaoInfo(Connection connection, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.preparedStatementLoggable = new PreparedStatementLoggable(connection, resultSetType, resultSetConcurrency);
    }

    public DaoInfo(Connection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.preparedStatementLoggable = new PreparedStatementLoggable(connection, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public DaoInfo(Connection connection, String sql) throws SQLException {
        this.sql = sql;
        this.preparedStatementLoggable = new PreparedStatementLoggable(connection, sql);
    }

    public DaoInfo(Connection connection, String sql, int autoGeneratedKeys) throws SQLException {
        this.sql = sql;
        this.preparedStatementLoggable = new PreparedStatementLoggable(connection, sql, autoGeneratedKeys);
    }

    public DaoInfo(Connection connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.sql = sql;
        this.preparedStatementLoggable = new PreparedStatementLoggable(connection, sql, resultSetType, resultSetConcurrency);
    }

    public DaoInfo(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.sql = sql;
        this.preparedStatementLoggable = new PreparedStatementLoggable(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public DaoInfo(Connection connection, String sql, int[] columnIndexes) throws SQLException {
        this.sql = sql;
        this.preparedStatementLoggable = new PreparedStatementLoggable(connection, sql, columnIndexes);
    }

    public DaoInfo(Connection connection, String sql, String[] columnNames) throws SQLException {
        this.sql = sql;
        this.preparedStatementLoggable = new PreparedStatementLoggable(connection, sql, columnNames);
    }

    public Object doAround(Object object, Method method, Object[] args) throws Throwable {
        Object obj;
        block16: {
            obj = null;
            String convertedSql = null;
            ApacheCommonLangTimeStopWatch stopWatch = null;
            try {
                boolean isFilteredMethodNamePossible = ReloadableConfiguration.getInstance().isFieltered(method.getName());
                if (this.sql == null && args != null && args.length > 0 && args[0] != null && args[0] instanceof String) {
                    this.sql = (String)args[0];
                }
                if (this.sql != null && isFilteredMethodNamePossible) {
                    stopWatch = new ApacheCommonLangTimeStopWatch();
                    convertedSql = this.sqlLogging(this.preparedStatementLoggable);
                    stopWatch.start();
                }
                obj = method.invoke((Object)this.preparedStatementLoggable, args);
                if (this.sql != null && isFilteredMethodNamePossible) {
                    if (stopWatch != null) {
                        stopWatch.stop();
                    }
                    if (obj instanceof ResultSet) {
                        this.log(true, convertedSql, stopWatch.toString(), null);
                    } else if (obj instanceof Integer) {
                        this.log(false, convertedSql, stopWatch.toString(), obj.toString());
                    }
                    if (stopWatch != null) {
                        stopWatch.reset();
                    }
                }
            }
            catch (Throwable t) {
                if (stopWatch != null) {
                    stopWatch.reset();
                }
                SL.getInstance().logError(t);
                try {
                    convertedSql = this.sqlLogging(this.preparedStatementLoggable);
                }
                catch (Throwable t1) {
                    new InternalException(t1);
                }
                if (t instanceof InternalException || t instanceof IllegalAccessException) break block16;
                if (convertedSql != null) {
                    SL.getInstance().logError(t, convertedSql);
                } else if (this.sql != null) {
                    SL.getInstance().logError(t, this.sql);
                }
                throw t;
            }
        }
        return obj;
    }

    private void log(boolean isSelect, String convertedSql, String elapsedTime, String result) throws InternalException {
        Throwable throwable = SL.getInstance().getMessageThrowableForThread(convertedSql);
        if (new PatternCheck().doLog(ReloadableConfiguration.getInstance().getViewAppoint(), throwable)) {
            try {
                LogResource logResource = new LogResource(isSelect, throwable);
                logResource.setConvertedSql(convertedSql);
                logResource.setElapsedTime(elapsedTime);
                if (!isSelect) {
                    logResource.setResult("[" + TriggerRegister.changeNotify(this.sql) + "]: " + result);
                }
                if (ReloadableConfiguration.getInstance().getAsynchronous()) {
                    this.concurentThreadPool.addTask(logResource);
                } else {
                    SL.getInstance().logSql(logResource);
                }
            }
            catch (Throwable t) {
                if (isSelect) {
                    throw new InternalException("LoggingDaoR Error", t);
                }
                throw new InternalException("LoggingDaoCUD Error", t);
            }
            finally {
                this.preparedStatementLoggable.setParameterValuesInitailize();
            }
        }
    }

    private String sqlLogging(PreparedStatementLoggable preparedStatementLoggable) throws InternalException {
        String loggingSql = null;
        try {
            loggingSql = LoggingQuery.log(this.sql, (Object)preparedStatementLoggable.getParameterValues().toArray());
        }
        catch (Throwable t) {
            throw new InternalException("SQL Logging Error!", t);
        }
        return loggingSql;
    }
}

