/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.varia;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.RollingFileAppender;

public final class ExternallyRolledFileAppender
extends RollingFileAppender {
    public static final String ROLL_OVER = "RollOver";
    public static final String OK = "OK";
    private int port = 0;
    private HUP hup;

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void activateOptions() {
        super.activateOptions();
        if (this.port != 0) {
            this.hup = new HUP(this, this.port);
            this.hup.setDaemon(true);
            this.hup.start();
        }
    }

    public void close() {
        HUP dying = null;
        ExternallyRolledFileAppender externallyRolledFileAppender = this;
        synchronized (externallyRolledFileAppender) {
            dying = this.hup;
            this.hup = null;
        }
        if (dying != null) {
            dying.interrupt();
            try {
                new Socket(InetAddress.getLocalHost(), this.port);
                dying.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.close();
    }

    private static class HUP
    extends Thread {
        private final ExternallyRolledFileAppender er;
        private final int port;

        public HUP(ExternallyRolledFileAppender er, int port) {
            this.er = er;
            this.port = port;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            ServerSocket serverSocket = null;
            IOException ioex = null;
            int i = 0;
            while (i < 10) {
                try {
                    serverSocket = new ServerSocket(this.port);
                    break;
                }
                catch (IOException ex) {
                    ioex = ex;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException intex) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            if (serverSocket == null) {
                if (ioex == null) return;
                ioex.printStackTrace();
                return;
            }
            try {
                while (true) {
                    Socket socket = serverSocket.accept();
                    if (!this.isInterrupted()) {
                        DataInputStream dis = new DataInputStream(socket.getInputStream());
                        DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
                        try {
                            String line = dis.readUTF();
                            if (ExternallyRolledFileAppender.ROLL_OVER.equals(line)) {
                                ExternallyRolledFileAppender externallyRolledFileAppender = this.er;
                                synchronized (externallyRolledFileAppender) {
                                    this.er.rollOver();
                                }
                                dos.writeUTF(ExternallyRolledFileAppender.OK);
                                continue;
                            }
                            dos.writeUTF("Expecting [RollOver] string.");
                        }
                        catch (IOException ex) {}
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                serverSocket.close();
                return;
            }
            catch (IOException ex) {
                return;
            }
        }
    }
}

