/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.formula;

import java.util.List;
import java.util.Set;
import net.sf.jxls.controller.WorkbookCellFinder;
import net.sf.jxls.formula.BaseFormulaResolver;
import net.sf.jxls.formula.Formula;

public class CommonFormulaResolver
extends BaseFormulaResolver {
    static String leftReplacementMarker = "{";
    static String rightReplacementMarker = "}";
    static String regexReplacementMarker = "\\" + leftReplacementMarker + "[(),a-zA-Z0-9_ :*+/.-]+" + "\\" + rightReplacementMarker;

    public String resolve(Formula sourceFormula, WorkbookCellFinder cellFinder) {
        String resolvedFormula = sourceFormula.containsListRanges() ? this.replaceListRanges(sourceFormula) : sourceFormula.getActualFormula();
        return resolvedFormula;
    }

    String replaceTransformedCells(Formula sourceFormula, WorkbookCellFinder cellFinder) {
        Set refCells = sourceFormula.findRefCells();
        String adjustedFormula = sourceFormula.getFormula();
        for (String refCell : refCells) {
            List resultCells;
            String sheetName;
            String newCell = "";
            String refSheetName = this.extractRefSheetName(refCell);
            String cellName = this.extractCellName(refCell);
            String string = sheetName = refSheetName == null ? sourceFormula.getSheet().getSheetName() : refSheetName;
            if (sheetName.startsWith("'") && sheetName.endsWith("'")) {
                sheetName = sheetName.substring(1, sheetName.length() - 1);
            }
            if ((resultCells = cellFinder.findCell(sheetName, cellName)) != null && !resultCells.isEmpty()) {
                if (resultCells.size() == 1) {
                    newCell = (String)resultCells.get(0);
                    newCell = this.getRefCellName(refSheetName, newCell);
                } else {
                    newCell = this.detectCellRange(refSheetName, resultCells);
                }
            }
            String formulaPart = adjustedFormula;
            adjustedFormula = CommonFormulaResolver.replaceFormulaPart(formulaPart, refCell, newCell);
        }
        adjustedFormula = adjustedFormula.replaceAll("\\" + leftReplacementMarker, "");
        adjustedFormula = adjustedFormula.replaceAll("\\" + rightReplacementMarker, "");
        return adjustedFormula;
    }

    public static String replaceFormulaPart(String formulaPart, String refCell, String newCell) {
        String replacedFormulaPart = "";
        String[] parts = formulaPart.split(regexReplacementMarker, 2);
        while (parts.length == 2) {
            replacedFormulaPart = replacedFormulaPart + parts[0].replaceAll(refCell, leftReplacementMarker + newCell + rightReplacementMarker);
            int secondPartIndex = formulaPart.indexOf(parts[1], parts[0].length());
            replacedFormulaPart = replacedFormulaPart + formulaPart.substring(parts[0].length(), secondPartIndex);
            formulaPart = parts[1];
            parts = formulaPart.split(regexReplacementMarker, 2);
        }
        replacedFormulaPart = replacedFormulaPart + parts[0].replaceAll(refCell, leftReplacementMarker + newCell + rightReplacementMarker);
        return replacedFormulaPart;
    }

    private String extractCellName(String refCell) {
        if (refCell != null) {
            if (refCell.indexOf("!") < 0) {
                return refCell;
            }
            return refCell.substring(refCell.indexOf("!") + 1);
        }
        return null;
    }

    private String extractRefSheetName(String refCell) {
        if (refCell != null) {
            if (refCell.indexOf("!") < 0) {
                return null;
            }
            return refCell.substring(0, refCell.indexOf("!"));
        }
        return null;
    }
}

