/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter.openoffice.connection;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.net.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenOfficeConnection
implements OpenOfficeConnection,
XEventListener {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String connectionString;
    private XComponent bridgeComponent;
    private XMultiComponentFactory serviceManager;
    private XComponentContext componentContext;
    private XBridge bridge;
    private boolean connected = false;
    private boolean expectingDisconnection = false;

    protected AbstractOpenOfficeConnection(String connectionString) {
        this.connectionString = connectionString;
    }

    public synchronized void connect() throws ConnectException {
        this.logger.debug("connecting");
        try {
            XComponentContext localContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory localServiceManager = localContext.getServiceManager();
            XConnector connector = (XConnector)UnoRuntime.queryInterface((Class)XConnector.class, (Object)localServiceManager.createInstanceWithContext("com.sun.star.connection.Connector", localContext));
            XConnection connection = connector.connect(this.connectionString);
            XBridgeFactory bridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface((Class)XBridgeFactory.class, (Object)localServiceManager.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", localContext));
            this.bridge = bridgeFactory.createBridge("", "urp", connection, null);
            this.bridgeComponent = (XComponent)UnoRuntime.queryInterface((Class)XComponent.class, (Object)this.bridge);
            this.bridgeComponent.addEventListener((XEventListener)this);
            this.serviceManager = (XMultiComponentFactory)UnoRuntime.queryInterface((Class)XMultiComponentFactory.class, (Object)this.bridge.getInstance("StarOffice.ServiceManager"));
            XPropertySet properties = (XPropertySet)UnoRuntime.queryInterface((Class)XPropertySet.class, (Object)this.serviceManager);
            this.componentContext = (XComponentContext)UnoRuntime.queryInterface((Class)XComponentContext.class, (Object)properties.getPropertyValue("DefaultContext"));
            this.connected = true;
            this.logger.info("connected");
        }
        catch (NoConnectException connectException) {
            throw new ConnectException("connection failed: " + this.connectionString + ": " + connectException.getMessage());
        }
        catch (Exception exception) {
            throw new OpenOfficeException("connection failed: " + this.connectionString, exception);
        }
    }

    public synchronized void disconnect() {
        this.logger.debug("disconnecting");
        this.expectingDisconnection = true;
        this.bridgeComponent.dispose();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disposing(EventObject event) {
        this.connected = false;
        if (this.expectingDisconnection) {
            this.logger.info("disconnected");
        } else {
            this.logger.error("disconnected unexpectedly");
        }
        this.expectingDisconnection = false;
    }

    void simulateUnexpectedDisconnection() {
        this.disposing(null);
        this.bridgeComponent.dispose();
    }

    private Object getService(String className) {
        try {
            if (!this.connected) {
                this.logger.info("trying to (re)connect");
                this.connect();
            }
            return this.serviceManager.createInstanceWithContext(className, this.componentContext);
        }
        catch (Exception exception) {
            throw new OpenOfficeException("could not obtain service: " + className, exception);
        }
    }

    public XComponentLoader getDesktop() {
        return (XComponentLoader)UnoRuntime.queryInterface((Class)XComponentLoader.class, (Object)this.getService("com.sun.star.frame.Desktop"));
    }

    public XFileIdentifierConverter getFileContentProvider() {
        return (XFileIdentifierConverter)UnoRuntime.queryInterface((Class)XFileIdentifierConverter.class, (Object)this.getService("com.sun.star.ucb.FileContentProvider"));
    }

    public XBridge getBridge() {
        return this.bridge;
    }

    public XMultiComponentFactory getRemoteServiceManager() {
        return this.serviceManager;
    }

    public XComponentContext getComponentContext() {
        return this.componentContext;
    }
}

