/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging;

import java.text.MessageFormat;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerPlugin;
import org.jboss.logging.LoggerPluginInstance;

public abstract class AbstractLoggerPluginInstance
implements LoggerPluginInstance {
    private final Logger logger;
    private final LoggerPlugin loggerPlugin;

    protected AbstractLoggerPluginInstance(String name, String resourceBundleName, LoggerPlugin loggerPlugin) {
        this.loggerPlugin = loggerPlugin;
        this.logger = new Logger(name, resourceBundleName, this);
    }

    public LoggerPlugin getLoggerPlugin() {
        return this.loggerPlugin;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void logf(Logger.Level level, String loggerFqcn, String format, Object[] params, Throwable t) {
        if (this.isEnabled(level)) {
            this.log(level, loggerFqcn, params == null || params.length == 0 ? format : String.format(String.valueOf(format), params), t);
        }
    }

    public void log(Logger.Level level, String loggerFqcn, Object message, Object[] params, Throwable t) {
        if (this.isEnabled(level)) {
            String msgStr = String.valueOf(message);
            this.log(level, loggerFqcn, params == null || params.length == 0 ? msgStr : MessageFormat.format(msgStr, params), t);
        }
    }

    protected void log(Logger.Level level, String loggerFqcn, String message, Throwable t) {
    }
}

